/*
 * Decompiled with CFR 0.152.
 */
package megabytesme.minelights;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import megabytesme.minelights.MineLightsClient;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class DownloadProgressScreen
extends class_437 {
    private final class_437 parent;
    private final String tagName = "v2-server";
    private final Path destination;
    private final AtomicReference<Status> status = new AtomicReference<Status>(Status.STARTING);
    private final AtomicInteger progress = new AtomicInteger(0);
    private final AtomicReference<String> errorMessage = new AtomicReference<String>("");
    private final AtomicReference<String> downloadSpeed = new AtomicReference<String>("");
    private String statusMessage = "";
    private class_4185 closeButton;
    private static final char[] HEX_ARRAY = "0123456789abcdef".toCharArray();

    public DownloadProgressScreen(class_437 parent, Path destination) {
        super((class_2561)new class_2585(""));
        this.parent = parent;
        this.destination = destination;
        new Thread(this::downloadAndStartServer, "MineLights-Downloader").start();
    }

    protected void init() {
        super.init();
        int centerX = this.width / 2;
        this.closeButton = new class_4185(centerX - 100, this.height - 40, 200, 20, new class_2588("minelights.gui.button.close", new Object[0]).getString(), button -> this.onClose());
        this.closeButton.active = false;
        this.addButton((class_339)this.closeButton);
    }

    public void render(int mouseX, int mouseY, float delta) {
        this.renderBackground();
        super.render(mouseX, mouseY, delta);
        int centerX = this.width / 2;
        this.drawCenteredString(this.font, new class_2588("minelights.gui.download.progress_title", new Object[0]).getString(), centerX, 40, 0xFFFFFF);
        this.drawCenteredString(this.font, new class_2588("minelights.gui.download.info", new Object[0]).getString(), centerX, 65, 0xFFFFFF);
        this.drawCenteredString(this.font, this.statusMessage, centerX, this.height / 2 + 15, 0xFFFFFF);
        int barWidth = 300;
        int barHeight = 8;
        int barX = this.width / 2 - barWidth / 2;
        int barY = this.height / 2;
        int fillWidth = (int)((float)barWidth * ((float)this.progress.get() / 100.0f));
        DownloadProgressScreen.fill((int)barX, (int)barY, (int)(barX + barWidth), (int)(barY + barHeight), (int)-13619152);
        DownloadProgressScreen.fill((int)barX, (int)barY, (int)(barX + fillWidth), (int)(barY + barHeight), (int)-1);
    }

    public void onClose() {
        this.minecraft.method_1507(this.parent);
    }

    private String formatSpeed(long bytesPerSecond) {
        if (bytesPerSecond < 1024L) {
            return String.format("%d B/s", bytesPerSecond);
        }
        long kbps = bytesPerSecond / 1024L;
        if (kbps < 1024L) {
            return String.format("%d KB/s", kbps);
        }
        return String.format("%.2f MB/s", (double)kbps / 1024.0);
    }

    private String formatETA(long seconds) {
        if (seconds < 0L) {
            return "Calculating...";
        }
        long mins = seconds / 60L;
        long secs = seconds % 60L;
        return String.format("%dm %ds remaining", mins, secs);
    }

    private void updateStatusWidget(long totalFileSize, long totalBytesRead, long speed) {
        long remainingBytes = totalFileSize - totalBytesRead;
        long etaSeconds = speed > 0L ? remainingBytes / speed : -1L;
        String eta = this.formatETA(etaSeconds);
        String speedString = this.downloadSpeed.get();
        if (speedString == null || speedString.isEmpty()) {
            speedString = "0 B/s";
        }
        this.statusMessage = String.format("%d%% (%s) \u2014 %s", this.progress.get(), speedString, eta);
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    private String sha256(Path file) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        try (InputStream fis = Files.newInputStream(file, new OpenOption[0]);){
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = fis.read(buffer)) != -1) {
                digest.update(buffer, 0, bytesRead);
            }
        }
        return DownloadProgressScreen.bytesToHex(digest.digest());
    }

    private static String readAllBytes(InputStream inputStream) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[4096];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        return new String(buffer.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadAndStartServer() {
        block34: {
            try {
                String json;
                this.status.set(Status.DOWNLOADING);
                URL apiUrl = URI.create("https://api.github.com/repos/megabytesme/MineLights/releases/tags/v2-server").toURL();
                HttpURLConnection conn = (HttpURLConnection)apiUrl.openConnection();
                conn.setRequestProperty("Accept", "application/vnd.github+json");
                try (InputStream in = conn.getInputStream();){
                    json = DownloadProgressScreen.readAllBytes(in);
                }
                JsonObject root = new JsonParser().parse(json).getAsJsonObject();
                JsonArray assets = root.getAsJsonArray("assets");
                if (assets.size() == 0) {
                    throw new IOException("No assets found in release");
                }
                JsonObject asset = assets.get(0).getAsJsonObject();
                String downloadUrl = asset.get("browser_download_url").getAsString();
                String expectedHash = asset.get("digest").getAsString().replace("sha256:", "");
                Files.createDirectories(this.destination.getParent(), new FileAttribute[0]);
                URL url = URI.create(downloadUrl).toURL();
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestProperty("User-Agent", "MineLights-Mod-Downloader/1.0");
                long totalFileSize = connection.getContentLength();
                long totalBytesRead = 0L;
                long lastTime = System.currentTimeMillis();
                long lastBytes = 0L;
                try (InputStream inputStream = connection.getInputStream();
                     FileOutputStream outputStream = new FileOutputStream(this.destination.toFile());){
                    int bytesRead;
                    byte[] buffer = new byte[8192];
                    while ((bytesRead = inputStream.read(buffer)) != -1) {
                        long currentTime;
                        outputStream.write(buffer, 0, bytesRead);
                        totalBytesRead += (long)bytesRead;
                        if (totalFileSize > 0L) {
                            this.progress.set((int)(totalBytesRead * 100L / totalFileSize));
                        }
                        if ((currentTime = System.currentTimeMillis()) - lastTime < 500L) continue;
                        long currentSpeed = (totalBytesRead - lastBytes) * 1000L / (currentTime - lastTime);
                        this.downloadSpeed.set(this.formatSpeed(currentSpeed));
                        lastTime = currentTime;
                        lastBytes = totalBytesRead;
                        this.updateStatusWidget(totalFileSize, totalBytesRead, currentSpeed);
                    }
                }
                String actualHash = this.sha256(this.destination);
                if (!actualHash.equalsIgnoreCase(expectedHash)) {
                    throw new IOException("Hash mismatch! Expected " + expectedHash + " but got " + actualHash);
                }
                this.status.set(Status.STARTING);
                this.statusMessage = new class_2588("minelights.gui.download.status.starting", new Object[0]).getString();
                if (MineLightsClient.serverMonitorThread != null) {
                    MineLightsClient.serverMonitorThread.interrupt();
                }
                try {
                    ProcessBuilder pb = new ProcessBuilder(this.destination.toAbsolutePath().toString());
                    pb.directory(this.destination.getParent().toFile());
                    pb.start();
                }
                catch (IOException e) {
                    throw new IOException("Failed to start downloaded process", e);
                }
                boolean serverStarted = false;
                for (int i = 0; i < 20; ++i) {
                    if (MineLightsClient.isServerRunning()) {
                        serverStarted = true;
                        break;
                    }
                    Thread.sleep(500L);
                }
                if (serverStarted) {
                    MineLightsClient.LOGGER.info("Server is running. Refreshing device list.");
                    MineLightsClient.refreshLightingManager();
                    this.status.set(Status.SUCCESS);
                    this.statusMessage = new class_2588("minelights.gui.download.status.success", new Object[0]).getString();
                    break block34;
                }
                throw new IOException("Server did not start within 10 seconds.");
            }
            catch (Exception e) {
                MineLightsClient.LOGGER.error("Failed during download, verification, or server start", (Throwable)e);
                this.errorMessage.set(e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName());
                this.status.set(Status.FAILED);
                this.statusMessage = new class_2588("minelights.gui.download.status.failed", new Object[]{this.errorMessage.get()}).getString();
            }
            finally {
                this.minecraft.execute(() -> {
                    this.closeButton.active = true;
                });
            }
        }
    }

    private static enum Status {
        DOWNLOADING,
        SUCCESS,
        FAILED,
        STARTING;

    }
}

