/*
 * Decompiled with CFR 0.152.
 */
package megabytesme.minelights;

import java.util.ArrayList;
import megabytesme.minelights.CompassState;
import megabytesme.minelights.CompassType;
import megabytesme.minelights.MineLightsClient;
import megabytesme.minelights.PlayerDto;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2874;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class PlayerDataCollector {
    public static PlayerDto getCurrentState(class_310 client) {
        PlayerDto playerDto = new PlayerDto();
        if (client == null || client.field_1687 == null || client.field_1724 == null) {
            playerDto.setInGame(false);
            return playerDto;
        }
        class_746 player = client.field_1724;
        class_638 world = client.field_1687;
        playerDto.setInGame(true);
        playerDto.setHealth(player.method_6032());
        playerDto.setHunger(player.method_7344().method_7586());
        playerDto.setSaturation(player.method_7344().method_7589());
        playerDto.setAir(player.method_5669());
        playerDto.setExperience(player.field_7510);
        playerDto.setCurrentBlock(world.method_8320(player.method_5704()).method_11614().method_9539());
        playerDto.setCurrentBiome(class_2378.field_11153.method_10221((Object)world.method_8310(player.method_5704())).toString());
        playerDto.setCurrentWorld(class_2378.field_11155.method_10221((Object)world.method_8597().method_12460()).toString());
        playerDto.setIsOnFire(player.method_5809());
        playerDto.setIsPoisoned(player.method_6059(class_1294.field_5899));
        playerDto.setIsWithering(player.method_6059(class_1294.field_5920));
        playerDto.setIsTakingDamage(player.field_6235 > 0);
        PlayerDataCollector.updateCompassData(playerDto, player, world);
        if (world.method_8546()) {
            playerDto.setWeather("Thunderstorm");
        } else if (world.method_8419()) {
            playerDto.setWeather("Rain");
        } else {
            playerDto.setWeather("Clear");
        }
        return playerDto;
    }

    private static void updateCompassData(PlayerDto dto, class_746 player, class_638 world) {
        CompassFindResult result = PlayerDataCollector.findCompass((class_1657)player);
        if (result == null) {
            if (MineLightsClient.CONFIG.alwaysShowCompass && world.field_9247.method_12460() == class_2874.field_13072) {
                dto.setCompassType(CompassType.STANDARD);
                PlayerDataCollector.setCompassTarget(dto, player, world.method_8395());
            } else {
                dto.setCompassState(CompassState.NONE);
                dto.setCompassType(CompassType.NONE);
            }
            return;
        }
        dto.setCompassType(result.type);
        class_2338 targetPos = PlayerDataCollector.getCompassTargetPos(result.stack, (class_1657)player, world);
        if (targetPos != null && !(targetPos.method_10262((class_2382)new class_2338(player.method_19538())) < 1.0E-5)) {
            PlayerDataCollector.setCompassTarget(dto, player, targetPos);
        } else {
            dto.setCompassState(CompassState.SPINNING);
        }
    }

    private static CompassFindResult findCompass(class_1657 player) {
        ArrayList<class_1799> stacksToCheck = new ArrayList<class_1799>();
        stacksToCheck.add(player.method_6047());
        stacksToCheck.add(player.method_6079());
        for (int i = 0; i < 36; ++i) {
            stacksToCheck.add(player.field_7514.method_5438(i));
        }
        for (class_1799 stack : stacksToCheck) {
            if (stack.method_7909() != class_1802.field_8251) continue;
            return new CompassFindResult(stack, CompassType.STANDARD);
        }
        return null;
    }

    private static class_2338 getCompassTargetPos(class_1799 stack, class_1657 holder, class_638 world) {
        class_2487 tag;
        if (stack.method_7909() == class_1802.field_8251 && stack.method_7985() && (tag = stack.method_7969()) != null && tag.method_10545("LodestonePos")) {
            class_2487 posTag = tag.method_10562("LodestonePos");
            return new class_2338(posTag.method_10550("X"), posTag.method_10550("Y"), posTag.method_10550("Z"));
        }
        return world.method_8395();
    }

    private static void setCompassTarget(PlayerDto dto, class_746 player, class_2338 target) {
        double relativeYaw;
        class_243 playerPos = player.method_19538();
        class_243 targetPos = new class_243((double)target.method_10263() + 0.5, (double)target.method_10264() + 0.5, (double)target.method_10260() + 0.5);
        double deltaX = targetPos.field_1352 - playerPos.field_1352;
        double deltaZ = targetPos.field_1350 - playerPos.field_1350;
        double targetYaw = Math.toDegrees(Math.atan2(-deltaX, deltaZ));
        for (relativeYaw = targetYaw - (double)player.field_6031; relativeYaw <= -180.0; relativeYaw += 360.0) {
        }
        while (relativeYaw > 180.0) {
            relativeYaw -= 360.0;
        }
        dto.setCompassState(CompassState.POINTING);
        dto.setCompassRelativeYaw(relativeYaw);
        dto.setCompassDistance(Math.sqrt(deltaX * deltaX + deltaZ * deltaZ));
    }

    private static class CompassFindResult {
        final class_1799 stack;
        final CompassType type;

        CompassFindResult(class_1799 stack, CompassType type) {
            this.stack = stack;
            this.type = type;
        }
    }
}

