/*
 * Decompiled with CFR 0.152.
 */
package megabytesme.minelights.config;

import io.github.prospector.modmenu.api.ModMenuApi;
import java.util.Comparator;
import java.util.function.Function;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import megabytesme.minelights.CommandClient;
import megabytesme.minelights.MineLightsClient;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_437;

public class ModMenuIntegration
implements ModMenuApi {
    public String getModId() {
        return "mine-lights";
    }

    public Function<class_437, class_437> getConfigScreenFactory() {
        return parent -> {
            ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle(new class_2588("title.mine-lights.config", new Object[0]).getString());
            builder.setSavingRunnable(() -> {
                MineLightsClient.saveConfig();
                boolean needsRefresh = false;
                if (MineLightsClient.CONFIG.refreshDevices) {
                    MineLightsClient.CONFIG.refreshDevices = false;
                    needsRefresh = true;
                }
                if (MineLightsClient.CONFIG.restartProxy) {
                    CommandClient.sendCommand("restart");
                    MineLightsClient.CONFIG.restartProxy = false;
                    needsRefresh = true;
                }
                if (MineLightsClient.CONFIG.restartProxyAsAdmin) {
                    CommandClient.sendCommand("restart_admin");
                    MineLightsClient.CONFIG.restartProxyAsAdmin = false;
                    needsRefresh = true;
                }
                if (MineLightsClient.CONFIG.clearDisabledDevices) {
                    MineLightsClient.CONFIG.disabledDevices.clear();
                    MineLightsClient.saveConfig();
                    MineLightsClient.CONFIG.clearDisabledDevices = false;
                    needsRefresh = true;
                }
                if (needsRefresh) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    MineLightsClient.refreshLightingManager();
                }
            });
            ConfigEntryBuilder entryBuilder = builder.entryBuilder();
            ConfigCategory general = builder.getOrCreateCategory(new class_2588("category.mine-lights.general", new Object[0]).getString());
            general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(new class_2588("option.mine-lights.enableMod", new Object[0]).getString(), MineLightsClient.CONFIG.enableMod).setDefaultValue(true).setTooltip(new String[]{new class_2588("option.mine-lights.enableMod.tooltip", new Object[0]).getString()}).setSaveConsumer(newValue -> {
                MineLightsClient.CONFIG.enableMod = newValue;
            }).build());
            if (MineLightsClient.IS_WINDOWS) {
                general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(new class_2588("option.mine-lights.autoStartServer", new Object[0]).getString(), MineLightsClient.CONFIG.autoStartServer).setDefaultValue(true).setTooltip(new String[]{new class_2588("option.mine-lights.autoStartServer.tooltip", new Object[0]).getString()}).setSaveConsumer(newValue -> {
                    MineLightsClient.CONFIG.autoStartServer = newValue;
                }).build());
            }
            general.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription(new class_2585("").getString()).build());
            general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(new class_2588("option.mine-lights.refresh_devices.label", new Object[0]).getString(), MineLightsClient.CONFIG.refreshDevices).setDefaultValue(false).setTooltip(new String[]{new class_2588("option.mine-lights.refresh_devices.tooltip", new Object[0]).getString()}).setSaveConsumer(newValue -> {
                MineLightsClient.CONFIG.refreshDevices = newValue;
            }).build());
            general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(new class_2588("option.mine-lights.restart.label", new Object[0]).getString(), MineLightsClient.CONFIG.restartProxy).setDefaultValue(false).setTooltip(new String[]{new class_2588("option.mine-lights.restart.tooltip", new Object[0]).getString()}).setSaveConsumer(newValue -> {
                MineLightsClient.CONFIG.restartProxy = newValue;
            }).build());
            general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(new class_2588("option.mine-lights.restart_admin.label", new Object[0]).getString(), MineLightsClient.CONFIG.restartProxyAsAdmin).setDefaultValue(false).setTooltip(new String[]{new class_2588("option.mine-lights.restart_admin.tooltip", new Object[0]).getString()}).setSaveConsumer(newValue -> {
                MineLightsClient.CONFIG.restartProxyAsAdmin = newValue;
            }).build());
            ConfigCategory integrations = builder.getOrCreateCategory(new class_2588("category.mine-lights.integrations", new Object[0]).getString());
            integrations.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(new class_2588("integration.mine-lights.corsair", new Object[0]).getString(), MineLightsClient.CONFIG.enableCorsair).setDefaultValue(true).setSaveConsumer(newValue -> {
                MineLightsClient.CONFIG.enableCorsair = newValue;
            }).build());
            integrations.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(new class_2588("integration.mine-lights.asus", new Object[0]).getString(), MineLightsClient.CONFIG.enableAsus).setDefaultValue(true).setSaveConsumer(newValue -> {
                MineLightsClient.CONFIG.enableAsus = newValue;
            }).build());
            integrations.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(new class_2588("integration.mine-lights.logitech", new Object[0]).getString(), MineLightsClient.CONFIG.enableLogitech).setDefaultValue(true).setSaveConsumer(newValue -> {
                MineLightsClient.CONFIG.enableLogitech = newValue;
            }).build());
            integrations.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(new class_2588("integration.mine-lights.razer", new Object[0]).getString(), MineLightsClient.CONFIG.enableRazer).setDefaultValue(true).setSaveConsumer(newValue -> {
                MineLightsClient.CONFIG.enableRazer = newValue;
            }).build());
            integrations.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(new class_2588("integration.mine-lights.wooting", new Object[0]).getString(), MineLightsClient.CONFIG.enableWooting).setDefaultValue(true).setSaveConsumer(newValue -> {
                MineLightsClient.CONFIG.enableWooting = newValue;
            }).build());
            integrations.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(new class_2588("integration.mine-lights.steelseries", new Object[0]).getString(), MineLightsClient.CONFIG.enableSteelSeries).setDefaultValue(true).setSaveConsumer(newValue -> {
                MineLightsClient.CONFIG.enableSteelSeries = newValue;
            }).build());
            integrations.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(new class_2588("integration.mine-lights.msi", new Object[0]).getString(), MineLightsClient.CONFIG.enableMsi).setDefaultValue(true).setSaveConsumer(newValue -> {
                MineLightsClient.CONFIG.enableMsi = newValue;
            }).build());
            integrations.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(new class_2588("integration.mine-lights.novation", new Object[0]).getString(), MineLightsClient.CONFIG.enableNovation).setDefaultValue(true).setSaveConsumer(newValue -> {
                MineLightsClient.CONFIG.enableNovation = newValue;
            }).build());
            integrations.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(new class_2588("integration.mine-lights.picopi", new Object[0]).getString(), MineLightsClient.CONFIG.enablePicoPi).setDefaultValue(true).setSaveConsumer(newValue -> {
                MineLightsClient.CONFIG.enablePicoPi = newValue;
            }).build());
            integrations.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(new class_2588("integration.mine-lights.openrgb", new Object[0]).getString(), MineLightsClient.CONFIG.enableOpenRgb).setDefaultValue(true).setSaveConsumer(newValue -> {
                MineLightsClient.CONFIG.enableOpenRgb = newValue;
            }).build());
            integrations.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(new class_2588("integration.mine-lights.yeelight", new Object[0]).getString(), MineLightsClient.CONFIG.enableYeelight).setDefaultValue(true).setSaveConsumer(newValue -> {
                MineLightsClient.CONFIG.enableYeelight = newValue;
            }).build());
            ConfigCategory devices = builder.getOrCreateCategory(new class_2588("category.mine-lights.devices", new Object[0]).getString());
            devices.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription(new class_2588("option.mine-lights.device.header", new Object[0]).getString()).build());
            MineLightsClient.discoveredDevices.stream().sorted(Comparator.naturalOrder()).forEach(uniqueId -> {
                boolean isEnabled = !MineLightsClient.CONFIG.disabledDevices.contains(uniqueId);
                String[] parts = uniqueId.split("\\|", 2);
                String deviceSdk = parts.length > 1 ? parts[0] : "Unknown";
                String deviceName = parts.length > 1 ? parts[1] : uniqueId;
                class_2561 label = new class_2585(deviceName).method_10852(new class_2585(" (" + deviceSdk + ")").method_10854(class_124.field_1080));
                devices.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(label.getString(), isEnabled).setDefaultValue(true).setSaveConsumer(newValue -> {
                    if (newValue.booleanValue()) {
                        MineLightsClient.CONFIG.disabledDevices.remove(uniqueId);
                    } else if (!MineLightsClient.CONFIG.disabledDevices.contains(uniqueId)) {
                        MineLightsClient.CONFIG.disabledDevices.add((String)uniqueId);
                    }
                }).build());
            });
            if (!MineLightsClient.CONFIG.disabledDevices.isEmpty()) {
                devices.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription(new class_2585("").getString()).build());
                devices.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(new class_2588("option.mine-lights.clear_disabled.label", new Object[0]).getString(), MineLightsClient.CONFIG.clearDisabledDevices).setDefaultValue(false).setTooltip(new String[]{new class_2588("option.mine-lights.clear_disabled.tooltip", new Object[0]).getString()}).setSaveConsumer(newValue -> {
                    MineLightsClient.CONFIG.clearDisabledDevices = newValue;
                }).build());
            }
            ConfigCategory playerStatus = builder.getOrCreateCategory(new class_2588("category.mine-lights.player_status", new Object[0]).getString());
            playerStatus.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(new class_2588("option.mine-lights.enableHealthBar", new Object[0]).getString(), MineLightsClient.CONFIG.enableHealthBar).setDefaultValue(true).setSaveConsumer(newValue -> {
                MineLightsClient.CONFIG.enableHealthBar = newValue;
            }).build());
            playerStatus.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(new class_2588("option.mine-lights.enableHungerBar", new Object[0]).getString(), MineLightsClient.CONFIG.enableHungerBar).setDefaultValue(true).setSaveConsumer(newValue -> {
                MineLightsClient.CONFIG.enableHungerBar = newValue;
            }).build());
            playerStatus.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(new class_2588("option.mine-lights.enableSaturationBar", new Object[0]).getString(), MineLightsClient.CONFIG.enableSaturationBar).setDefaultValue(true).setTooltip(new String[]{new class_2588("option.mine-lights.enableSaturationBar.tooltip", new Object[0]).getString()}).setSaveConsumer(newValue -> {
                MineLightsClient.CONFIG.enableSaturationBar = newValue;
            }).build());
            playerStatus.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(new class_2588("option.mine-lights.enableExperienceBar", new Object[0]).getString(), MineLightsClient.CONFIG.enableExperienceBar).setDefaultValue(true).setTooltip(new String[]{new class_2588("option.mine-lights.enableExperienceBar.tooltip", new Object[0]).getString()}).setSaveConsumer(newValue -> {
                MineLightsClient.CONFIG.enableExperienceBar = newValue;
            }).build());
            playerStatus.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(new class_2588("option.mine-lights.enableCompassEffect", new Object[0]).getString(), MineLightsClient.CONFIG.enableCompassEffect).setDefaultValue(true).setSaveConsumer(newValue -> {
                MineLightsClient.CONFIG.enableCompassEffect = newValue;
            }).build());
            playerStatus.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(new class_2588("option.mine-lights.alwaysShowCompass", new Object[0]).getString(), MineLightsClient.CONFIG.alwaysShowCompass).setDefaultValue(false).setTooltip(new String[]{new class_2588("option.mine-lights.alwaysShowCompass.tooltip", new Object[0]).getString()}).setSaveConsumer(newValue -> {
                MineLightsClient.CONFIG.alwaysShowCompass = newValue;
            }).build());
            playerStatus.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(new class_2588("option.mine-lights.enableLowHealthWarning", new Object[0]).getString(), MineLightsClient.CONFIG.enableLowHealthWarning).setDefaultValue(true).setSaveConsumer(newValue -> {
                MineLightsClient.CONFIG.enableLowHealthWarning = newValue;
            }).build());
            playerStatus.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(new class_2588("option.mine-lights.highlightMovementKeys", new Object[0]).getString(), MineLightsClient.CONFIG.highlightMovementKeys).setDefaultValue(true).setTooltip(new String[]{new class_2588("option.mine-lights.highlightMovementKeys.tooltip", new Object[0]).getString()}).setSaveConsumer(newValue -> {
                MineLightsClient.CONFIG.highlightMovementKeys = newValue;
            }).build());
            ConfigCategory environment = builder.getOrCreateCategory(new class_2588("category.mine-lights.environment", new Object[0]).getString());
            environment.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(new class_2588("option.mine-lights.enableBiomeEffects", new Object[0]).getString(), MineLightsClient.CONFIG.enableBiomeEffects).setDefaultValue(true).setTooltip(new String[]{new class_2588("option.mine-lights.enableBiomeEffects.tooltip", new Object[0]).getString()}).setSaveConsumer(newValue -> {
                MineLightsClient.CONFIG.enableBiomeEffects = newValue;
            }).build());
            environment.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(new class_2588("option.mine-lights.enableWeatherEffects", new Object[0]).getString(), MineLightsClient.CONFIG.enableWeatherEffects).setDefaultValue(true).setTooltip(new String[]{new class_2588("option.mine-lights.enableWeatherEffects.tooltip", new Object[0]).getString()}).setSaveConsumer(newValue -> {
                MineLightsClient.CONFIG.enableWeatherEffects = newValue;
            }).build());
            environment.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(new class_2588("option.mine-lights.enableOnFireEffect", new Object[0]).getString(), MineLightsClient.CONFIG.enableOnFireEffect).setDefaultValue(true).setSaveConsumer(newValue -> {
                MineLightsClient.CONFIG.enableOnFireEffect = newValue;
            }).build());
            environment.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(new class_2588("option.mine-lights.enableInWaterEffect", new Object[0]).getString(), MineLightsClient.CONFIG.enableInWaterEffect).setDefaultValue(true).setTooltip(new String[]{new class_2588("option.mine-lights.enableInWaterEffect.tooltip", new Object[0]).getString()}).setSaveConsumer(newValue -> {
                MineLightsClient.CONFIG.enableInWaterEffect = newValue;
            }).build());
            environment.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(new class_2588("option.mine-lights.enablePortalEffects", new Object[0]).getString(), MineLightsClient.CONFIG.enablePortalEffects).setDefaultValue(true).setSaveConsumer(newValue -> {
                MineLightsClient.CONFIG.enablePortalEffects = newValue;
            }).build());
            ConfigCategory aboutCategory = builder.getOrCreateCategory(new class_2588("category.mine-lights.about", new Object[0]).getString());
            aboutCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription(new class_2588("text.mine-lights.about.title", new Object[0]).getString()).build());
            aboutCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription(new class_2588("text.mine-lights.about.version", new Object[]{"2.2.1"}).getString()).build());
            aboutCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription(new class_2588("text.mine-lights.about.copyright", new Object[0]).getString()).build());
            aboutCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription("").build());
            aboutCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextField(new class_2588("text.mine-lights.about.source_code", new Object[0]).getString(), "https://github.com/megabytesme/MineLights").build());
            aboutCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextField(new class_2588("text.mine-lights.about.issues", new Object[0]).getString(), "https://github.com/megabytesme/MineLights/issues").build());
            aboutCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription("").build());
            aboutCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription(new class_2588("text.mine-lights.about.support_intro", new Object[0]).getString()).build());
            aboutCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextField(new class_2588("text.mine-lights.about.kofi", new Object[0]).getString(), "https://ko-fi.com/megabytesme").build());
            aboutCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription("").build());
            aboutCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription(new class_2588("text.mine-lights.about.description", new Object[0]).getString()).build());
            return builder.build();
        };
    }
}

