/*
 * Decompiled with CFR 0.152.
 */
package megabytesme.minelights;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import megabytesme.minelights.MineLightsClient;
import megabytesme.minelights.PlayerDataCollector;
import megabytesme.minelights.PlayerDto;
import megabytesme.minelights.UDPClient;
import megabytesme.minelights.effects.EffectPainter;
import megabytesme.minelights.effects.FrameStateDto;
import megabytesme.minelights.effects.KeyColorDto;
import megabytesme.minelights.effects.RGBColorDto;
import megabytesme.minelights.rgb.OpenRGBController;
import megabytesme.minelights.rgb.YeelightController;
import net.minecraft.class_310;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LightingManager
implements Runnable {
    public static final Logger LOGGER = LogManager.getLogger((String)"MineLights-LightingManager");
    private EffectPainter effectPainter;
    private final Gson gson = new Gson();
    private static final int FRAME_DURATION_MS = 33;
    private volatile boolean isInitialized = false;
    private FrameStateDto lastSentFrame = null;
    private final OpenRGBController openRgbController = new OpenRGBController();
    private final Map<Integer, Integer> openRgbLedToDeviceMap = new HashMap<Integer, Integer>();
    private final YeelightController yeelightController = new YeelightController();
    private final Map<Integer, Integer> yeelightLedToDeviceMap = new HashMap<Integer, Integer>();
    private final List<Integer> masterLedList = Collections.synchronizedList(new ArrayList());
    private final Map<String, Integer> masterKeyMap = Collections.synchronizedMap(new HashMap());
    private final AtomicInteger proxyLedCount = new AtomicInteger(0);
    private final AtomicInteger openRgbLedCount = new AtomicInteger(0);
    private final AtomicInteger yeelightLedCount = new AtomicInteger(0);

    public LightingManager() {
        this.performHandshakes();
    }

    private void performHandshakes() {
        Thread serverHandshakeThread = new Thread(() -> {
            try (Socket clientSocket = new Socket();){
                clientSocket.connect(new InetSocketAddress("127.0.0.1", 63211), 2000);
                MineLightsClient.isProxyConnected = true;
                DataOutputStream dos = new DataOutputStream(clientSocket.getOutputStream());
                DataInputStream dis = new DataInputStream(clientSocket.getInputStream());
                JsonObject configPayload = new JsonObject();
                JsonArray enabledIntegrations = new JsonArray();
                if (MineLightsClient.CONFIG.enableCorsair) {
                    enabledIntegrations.add("Corsair");
                }
                if (MineLightsClient.CONFIG.enableAsus) {
                    enabledIntegrations.add("Asus");
                }
                if (MineLightsClient.CONFIG.enableLogitech) {
                    enabledIntegrations.add("Logitech");
                }
                if (MineLightsClient.CONFIG.enableRazer) {
                    enabledIntegrations.add("Razer");
                }
                if (MineLightsClient.CONFIG.enableWooting) {
                    enabledIntegrations.add("Wooting");
                }
                if (MineLightsClient.CONFIG.enableSteelSeries) {
                    enabledIntegrations.add("SteelSeries");
                }
                if (MineLightsClient.CONFIG.enableMsi) {
                    enabledIntegrations.add("Msi");
                }
                if (MineLightsClient.CONFIG.enableNovation) {
                    enabledIntegrations.add("Novation");
                }
                if (MineLightsClient.CONFIG.enablePicoPi) {
                    enabledIntegrations.add("PicoPi");
                }
                configPayload.add("enabled_integrations", (JsonElement)enabledIntegrations);
                configPayload.add("disabled_devices", new Gson().toJsonTree(MineLightsClient.CONFIG.disabledDevices));
                byte[] configBytes = configPayload.toString().getBytes(StandardCharsets.UTF_8);
                dos.writeInt(configBytes.length);
                dos.write(configBytes);
                dos.flush();
                int length = dis.readInt();
                if (length > 0) {
                    byte[] jsonBytes = new byte[length];
                    dis.readFully(jsonBytes);
                    String jsonString = new String(jsonBytes, StandardCharsets.UTF_8);
                    LOGGER.info("Successfully received handshake data of length: {}", (Object)jsonString.length());
                    JsonObject handshakeData = new JsonParser().parse(jsonString).getAsJsonObject();
                    this.parseHandshakeData(handshakeData);
                } else {
                    LOGGER.warn("Server sent a handshake with zero length. No devices loaded from proxy.");
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed during handshake with MineLights Server. Is it running? Details: {}", (Object)e.getMessage());
                MineLightsClient.isProxyConnected = false;
            }
        });
        serverHandshakeThread.setName("MineLights-Server-Handshake");
        Thread openRgbThread = new Thread(() -> {
            if (!MineLightsClient.CONFIG.enableOpenRgb) {
                return;
            }
            if (this.openRgbController.connect()) {
                List<OpenRGBController.OpenRGBDevice> devices = this.openRgbController.getDevices();
                int openRgbLedOffset = 2000;
                for (int i = 0; i < devices.size(); ++i) {
                    OpenRGBController.OpenRGBDevice device = devices.get(i);
                    String uniqueId = "OpenRGB|" + device.name;
                    if (MineLightsClient.CONFIG.disabledDevices.contains(uniqueId)) continue;
                    MineLightsClient.discoveredDevices.add(uniqueId);
                    this.openRgbLedCount.addAndGet(device.ledCount);
                    for (int j = 0; j < device.ledCount; ++j) {
                        int globalLedId = openRgbLedOffset + j;
                        this.masterLedList.add(globalLedId);
                        this.openRgbLedToDeviceMap.put(globalLedId, i);
                    }
                    openRgbLedOffset += device.ledCount;
                }
            }
        });
        openRgbThread.setName("MineLights-OpenRGB-Handshake");
        Thread yeelightThread = new Thread(() -> {
            if (!MineLightsClient.CONFIG.enableYeelight) {
                return;
            }
            if (this.yeelightController.discover()) {
                List<YeelightController.YeelightDevice> devices = this.yeelightController.getDevices();
                int yeelightLedOffset = 3000;
                for (int i = 0; i < devices.size(); ++i) {
                    YeelightController.YeelightDevice device = devices.get(i);
                    String uniqueId = "Yeelight|" + (device.name != null && !device.name.isEmpty() ? device.name : device.id);
                    if (MineLightsClient.CONFIG.disabledDevices.contains(uniqueId)) continue;
                    MineLightsClient.discoveredDevices.add(uniqueId);
                    int globalLedId = yeelightLedOffset + i;
                    this.masterLedList.add(globalLedId);
                    this.yeelightLedToDeviceMap.put(globalLedId, i);
                    this.yeelightLedCount.incrementAndGet();
                }
            }
        });
        yeelightThread.setName("MineLights-Yeelight-Discovery");
        Thread initializerThread = new Thread(() -> {
            try {
                serverHandshakeThread.start();
                openRgbThread.start();
                yeelightThread.start();
                serverHandshakeThread.join(5000L);
                openRgbThread.join(5000L);
                yeelightThread.join(5000L);
                this.effectPainter = new EffectPainter(this.masterLedList, this.masterKeyMap);
                this.isInitialized = true;
                LOGGER.info("Initialization complete. Found {} LEDs from MineLights Server, {} from OpenRGB, and {} from Yeelight. Total: {}", (Object)this.proxyLedCount.get(), (Object)this.openRgbLedCount.get(), (Object)this.yeelightLedCount.get(), (Object)this.masterLedList.size());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        });
        initializerThread.setName("MineLights-Initializer");
        initializerThread.start();
    }

    private void parseHandshakeData(JsonObject handshakeData) {
        if (handshakeData.has("devices")) {
            for (JsonElement deviceElement : handshakeData.getAsJsonArray("devices")) {
                JsonObject deviceObject = deviceElement.getAsJsonObject();
                String uniqueId = deviceObject.get("sdk").getAsString() + "|" + deviceObject.get("name").getAsString();
                MineLightsClient.discoveredDevices.add(uniqueId);
                if (!deviceObject.has("leds")) continue;
                for (JsonElement id : deviceObject.getAsJsonArray("leds")) {
                    this.masterLedList.add(id.getAsInt());
                    this.proxyLedCount.incrementAndGet();
                }
            }
        }
        if (handshakeData.has("key_map")) {
            JsonObject mapObject = handshakeData.getAsJsonObject("key_map");
            for (Map.Entry entry : mapObject.entrySet()) {
                this.masterKeyMap.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsInt());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.isInitialized) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
        try {
            while (!Thread.currentThread().isInterrupted()) {
                long frameEnd;
                long sleepTime;
                PlayerDto playerState;
                long frameStart = System.currentTimeMillis();
                class_310 client = class_310.method_1551();
                if (client.field_1724 == null || !MineLightsClient.CONFIG.enableMod) {
                    playerState = new PlayerDto();
                    playerState.setInGame(false);
                } else {
                    playerState = PlayerDataCollector.getCurrentState(client);
                }
                FrameStateDto frameState = this.effectPainter.paint(playerState);
                if (frameState.equals(this.lastSentFrame)) {
                    long frameEnd2 = System.currentTimeMillis();
                    long sleepTime2 = 33L - (frameEnd2 - frameStart);
                    if (sleepTime2 <= 0L) continue;
                    Thread.sleep(sleepTime2);
                    continue;
                }
                this.lastSentFrame = frameState;
                ArrayList<KeyColorDto> proxyUpdateList = new ArrayList<KeyColorDto>();
                HashMap<Integer, List> openRgbUpdates = new HashMap<Integer, List>();
                for (Map.Entry<Integer, RGBColorDto> entry : frameState.keys.entrySet()) {
                    int deviceIndex;
                    int globalLedId = entry.getKey();
                    RGBColorDto color = entry.getValue();
                    if (this.openRgbLedToDeviceMap.containsKey(globalLedId)) {
                        deviceIndex = this.openRgbLedToDeviceMap.get(globalLedId);
                        openRgbUpdates.computeIfAbsent(deviceIndex, k -> new ArrayList()).add(new KeyColorDto(globalLedId, color));
                        continue;
                    }
                    if (this.yeelightLedToDeviceMap.containsKey(globalLedId)) {
                        deviceIndex = this.yeelightLedToDeviceMap.get(globalLedId);
                        this.yeelightController.updateLed(deviceIndex, color);
                        continue;
                    }
                    proxyUpdateList.add(new KeyColorDto(globalLedId, color));
                }
                if (!proxyUpdateList.isEmpty()) {
                    JsonObject proxyPayload = new JsonObject();
                    proxyPayload.add("led_colors", this.gson.toJsonTree(proxyUpdateList));
                    UDPClient.sendFrameData(this.gson.toJson((JsonElement)proxyPayload));
                }
                if (!openRgbUpdates.isEmpty()) {
                    for (Map.Entry entry : openRgbUpdates.entrySet()) {
                        this.openRgbController.updateLeds((Integer)entry.getKey(), (List)entry.getValue());
                    }
                }
                if ((sleepTime = 33L - ((frameEnd = System.currentTimeMillis()) - frameStart)) <= 0L) continue;
                Thread.sleep(sleepTime);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOGGER.error("Error in lighting loop", (Throwable)e);
        }
        finally {
            this.openRgbController.disconnect();
            this.yeelightController.disconnect();
        }
    }
}

