/*
 * Decompiled with CFR 0.152.
 */
package megabytesme.minelights;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import megabytesme.minelights.CommandClient;
import megabytesme.minelights.DiscoveryListener;
import megabytesme.minelights.DownloadProgressScreen;
import megabytesme.minelights.LightingManager;
import megabytesme.minelights.UDPClient;
import megabytesme.minelights.config.MineLightsConfig;
import megabytesme.minelights.config.SimpleJsonConfig;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_410;
import net.minecraft.class_437;
import net.minecraft.class_442;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MineLightsClient
implements ClientModInitializer {
    public static final Logger LOGGER = LogManager.getLogger((String)"MineLights");
    public static MineLightsConfig CONFIG;
    private static SimpleJsonConfig CONFIG_MANAGER;
    private static LightingManager lightingManager;
    private static Thread lightingManagerThread;
    private static Thread discoveryThread;
    public static Thread serverMonitorThread;
    public static final List<String> discoveredDevices;
    public static final boolean IS_WINDOWS;
    public static volatile boolean isProxyConnected;
    public static CountDownLatch proxyDiscoveredLatch;
    private static final AtomicBoolean hasPerformedServerCheck;
    private static final String GITHUB_API_URL = "https://api.github.com/repos/megabytesme/MineLights/releases/tags/v2-server";
    private boolean titleScreenHooked = false;
    private static final char[] HEX_ARRAY;

    public void onInitializeClient() {
        CONFIG_MANAGER = new SimpleJsonConfig("mine-lights");
        CONFIG = CONFIG_MANAGER.load(MineLightsConfig.class, new MineLightsConfig());
        if (IS_WINDOWS) {
            this.initializeServerConnection();
            ClientTickEvents.END_CLIENT_TICK.register(client -> {
                if (client.field_1755 instanceof class_442 && !this.titleScreenHooked) {
                    this.titleScreenHooked = true;
                    if (!hasPerformedServerCheck.getAndSet(true)) {
                        new Thread(() -> MineLightsClient.checkForServerUpdate(client.field_1755), "MineLights-Update-Check").start();
                    }
                }
            });
        }
        new Thread(() -> {
            try {
                if (proxyDiscoveredLatch.await(3L, TimeUnit.SECONDS)) {
                    LOGGER.info("MineLights Server discovered via broadcast! Initializing connection.");
                } else if (!IS_WINDOWS) {
                    LOGGER.warn("MineLights Server not discovered via broadcast on non-Windows OS.");
                }
                MineLightsClient.refreshLightingManager();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }, "MineLights-Initializer-Waiter").start();
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> {
            if (lightingManagerThread != null) {
                lightingManagerThread.interrupt();
            }
            if (discoveryThread != null) {
                discoveryThread.interrupt();
            }
            if (serverMonitorThread != null) {
                serverMonitorThread.interrupt();
            }
            UDPClient.close();
            if (IS_WINDOWS) {
                CommandClient.sendCommand("shutdown");
            }
        });
    }

    private static String readAllBytes(InputStream inputStream) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[4096];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        return new String(buffer.toByteArray());
    }

    private static void checkForServerUpdate(class_437 parentScreen) {
        try {
            String json;
            Path serverExePath = class_310.method_1551().field_1697.toPath().resolve("mods").resolve("MineLights").resolve("MineLights.exe");
            URI apiUri = URI.create(GITHUB_API_URL);
            HttpURLConnection conn = (HttpURLConnection)apiUri.toURL().openConnection();
            conn.setRequestProperty("Accept", "application/vnd.github+json");
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            try (InputStream in = conn.getInputStream();){
                json = MineLightsClient.readAllBytes(in);
            }
            JsonObject root = new JsonParser().parse(json).getAsJsonObject();
            JsonArray assets = root.getAsJsonArray("assets");
            if (assets.size() == 0) {
                return;
            }
            JsonObject asset = assets.get(0).getAsJsonObject();
            String expectedHash = "";
            if (!asset.has("digest")) {
                LOGGER.warn("GitHub release asset is missing 'digest' field for hash verification.");
                return;
            }
            expectedHash = asset.get("digest").getAsString().replace("sha256:", "");
            if (!Files.exists(serverExePath, new LinkOption[0])) {
                LOGGER.info("MineLights.exe not found. Prompting for initial download.");
                MineLightsClient.showDownloadPrompt(parentScreen, serverExePath, true);
                return;
            }
            String localHash = MineLightsClient.sha256(serverExePath);
            if (!localHash.equalsIgnoreCase(expectedHash)) {
                LOGGER.info("MineLights.exe is outdated or corrupted. Local hash: {}, Expected hash: {}", (Object)localHash, (Object)expectedHash);
                MineLightsClient.showUpdatePrompt(parentScreen, serverExePath);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to check for server update", (Throwable)e);
        }
    }

    private static void showUpdatePrompt(class_437 parentScreen, Path destination) {
        class_310.method_1551().execute(() -> {
            class_410 confirmScreen = new class_410(result -> {
                if (result) {
                    class_310.method_1551().method_1507((class_437)new DownloadProgressScreen(parentScreen, destination));
                } else {
                    class_310.method_1551().method_1507(parentScreen);
                }
            }, (class_2561)new class_2588("minelights.gui.update.title", new Object[0]), (class_2561)new class_2588("minelights.gui.update.info", new Object[0]));
            class_310.method_1551().method_1507((class_437)confirmScreen);
        });
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    private static String sha256(Path file) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        try (InputStream fis = Files.newInputStream(file, new OpenOption[0]);){
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = fis.read(buffer)) != -1) {
                digest.update(buffer, 0, bytesRead);
            }
        }
        return MineLightsClient.bytesToHex(digest.digest());
    }

    private void initializeServerConnection() {
        discoveryThread = new Thread((Runnable)new DiscoveryListener(), "MineLights-Discovery");
        discoveryThread.setDaemon(true);
        discoveryThread.start();
        if (MineLightsClient.CONFIG.autoStartServer) {
            serverMonitorThread = new Thread(MineLightsClient::serverMonitorLoop, "MineLights-Server-Monitor");
            serverMonitorThread.setDaemon(true);
            serverMonitorThread.start();
        } else {
            new Thread(() -> {
                Path serverExePath;
                if (!MineLightsClient.isServerRunning() && !Files.exists(serverExePath = class_310.method_1551().field_1697.toPath().resolve("mods").resolve("MineLights").resolve("MineLights.exe"), new LinkOption[0])) {
                    ClientTickEvents.END_CLIENT_TICK.register(client -> {
                        if (client.field_1755 instanceof class_442 && !this.titleScreenHooked) {
                            this.titleScreenHooked = true;
                            if (!hasPerformedServerCheck.getAndSet(true)) {
                                MineLightsClient.showDownloadPrompt(client.field_1755, serverExePath, true);
                            }
                        }
                    });
                }
            }).start();
        }
    }

    private static void serverMonitorLoop() {
        LOGGER.info("Starting MineLights Server monitor.");
        while (!Thread.currentThread().isInterrupted()) {
            try {
                if (!MineLightsClient.isServerRunning()) {
                    LOGGER.info("Server is not running. Attempting to launch MineLights.exe...");
                    MineLightsClient.startServerProcess();
                }
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                LOGGER.info("Server monitor shutting down.");
                break;
            }
        }
    }

    public static boolean isServerRunning() {
        boolean bl;
        Socket ignored = new Socket("127.0.0.1", 63213);
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        ignored.close();
        return bl;
    }

    private static void startServerProcess() {
        Path serverExePath = class_310.method_1551().field_1697.toPath().resolve("mods").resolve("MineLights").resolve("MineLights.exe");
        if (!Files.exists(serverExePath, new LinkOption[0])) {
            LOGGER.error("MineLights.exe not found.");
            if (serverMonitorThread != null) {
                serverMonitorThread.interrupt();
            }
            ClientTickEvents.END_CLIENT_TICK.register(client -> {
                if (client.field_1755 instanceof class_442 && !hasPerformedServerCheck.getAndSet(true)) {
                    MineLightsClient.showDownloadPrompt(client.field_1755, serverExePath, true);
                }
            });
            return;
        }
        try {
            LOGGER.info("Launching server from: {}", (Object)serverExePath.toAbsolutePath());
            ProcessBuilder pb = new ProcessBuilder(serverExePath.toAbsolutePath().toString());
            pb.directory(serverExePath.getParent().toFile());
            pb.start();
        }
        catch (IOException e) {
            LOGGER.error("Failed to start MineLights.exe process.", (Throwable)e);
        }
    }

    private static void showDownloadPrompt(class_437 parentScreen, Path destination, boolean isMissingFile) {
        class_310 client = class_310.method_1551();
        client.execute(() -> {
            class_2588 title = new class_2588("minelights.gui.download.title", new Object[0]);
            class_2588 message = isMissingFile ? new class_2588("minelights.gui.download.prompt_missing", new Object[0]) : new class_2588("minelights.gui.download.prompt_not_running", new Object[0]);
            class_410 confirmScreen = new class_410(result -> {
                if (result) {
                    client.method_1507((class_437)new DownloadProgressScreen(parentScreen, destination));
                } else {
                    client.method_1507(parentScreen);
                }
            }, (class_2561)title, (class_2561)message);
            client.method_1507((class_437)confirmScreen);
        });
    }

    public static void refreshLightingManager() {
        LOGGER.info("Attempting to establish lighting connections...");
        isProxyConnected = false;
        if (lightingManagerThread != null && lightingManagerThread.isAlive()) {
            lightingManagerThread.interrupt();
            try {
                lightingManagerThread.join(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        discoveredDevices.clear();
        proxyDiscoveredLatch = new CountDownLatch(1);
        lightingManager = new LightingManager();
        lightingManagerThread = new Thread((Runnable)lightingManager, "MineLights-LightingManager");
        lightingManagerThread.start();
    }

    public static void saveConfig() {
        CONFIG_MANAGER.save(CONFIG);
    }

    static {
        discoveredDevices = Collections.synchronizedList(new ArrayList());
        IS_WINDOWS = System.getProperty("os.name").toLowerCase().contains("win");
        isProxyConnected = false;
        proxyDiscoveredLatch = new CountDownLatch(1);
        hasPerformedServerCheck = new AtomicBoolean(false);
        HEX_ARRAY = "0123456789abcdef".toCharArray();
    }
}

