/*
 * Decompiled with CFR 0.152.
 */
package megabytesme.minelights.effects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import megabytesme.minelights.CompassState;
import megabytesme.minelights.CompassType;
import megabytesme.minelights.MineLightsClient;
import megabytesme.minelights.PlayerDto;
import megabytesme.minelights.effects.BiomeData;
import megabytesme.minelights.effects.FrameStateDto;
import megabytesme.minelights.effects.KeyMap;
import megabytesme.minelights.effects.RGBColorDto;
import net.minecraft.class_310;
import net.minecraft.class_315;

public class EffectPainter {
    private final Random random = new Random();
    private final List<Integer> allLedIds;
    private final Map<String, Integer> namedKeyMap;
    private boolean rainPhase = false;
    private long lastRainStep = 0L;
    private boolean isFlashing = false;
    private long flashStartTime = 0L;
    private long lastFireCrackleUpdate = 0L;
    private final List<Integer> cracklingKeys = new ArrayList<Integer>();
    private long lastPortalTwinkleUpdate = 0L;
    private final List<Integer> twinklingKeys = new ArrayList<Integer>();
    private RGBColorDto currentSmoothBiomeColor = new RGBColorDto(0, 0, 0);
    private RGBColorDto transitionStartColor = new RGBColorDto(0, 0, 0);
    private RGBColorDto targetBiomeColor = new RGBColorDto(0, 0, 0);
    private String lastKnownBiome = "";
    private long transitionStartTime = 0L;
    private static final int TRANSITION_DURATION_MS = 750;
    private long lastInWaterTime = 0L;
    private static final int AIR_BAR_VISIBLE_DURATION_MS = 2500;
    private boolean wasTakingDamageLastFrame = false;
    private boolean isDamageFlashActive = false;
    private long damageFlashStartTime = 0L;
    private boolean wasLowHealthLastFrame = false;
    private float heartbeatBrightness = 0.1f;
    private boolean isHeartBeatingUp = true;
    private long lastHeartbeatStep = 0L;
    private long lastCompassSpinTime = 0L;
    private int compassSpinIndex = 0;

    public EffectPainter(List<Integer> allLedIds, Map<String, Integer> namedKeyMap) {
        this.allLedIds = allLedIds;
        this.namedKeyMap = namedKeyMap;
    }

    private Integer getMappedId(String keyName) {
        return this.namedKeyMap.get(keyName);
    }

    public FrameStateDto paint(PlayerDto player) {
        FrameStateDto state = new FrameStateDto();
        if (!MineLightsClient.CONFIG.enableMod || this.allLedIds.isEmpty()) {
            return state;
        }
        if (!player.getInGame()) {
            for (Integer ledId : this.allLedIds) {
                state.keys.put(ledId, new RGBColorDto(255, 0, 0));
            }
            return state;
        }
        for (Integer ledId : this.allLedIds) {
            state.keys.put(ledId, new RGBColorDto(255, 0, 0));
        }
        this.paintEnvironmentalBase(state, player);
        if (MineLightsClient.CONFIG.enableExperienceBar) {
            this.paintExperienceBar(state, player);
        }
        this.paintPlayerBars(state, player);
        if (MineLightsClient.CONFIG.enableSaturationBar) {
            this.paintSaturationAndAirBar(state, player);
        }
        if (MineLightsClient.CONFIG.enableCompassEffect) {
            this.paintCompass(state, player);
        }
        if (MineLightsClient.CONFIG.enableLowHealthWarning) {
            this.paintHealthEffects(state, player);
        }
        this.paintPlayerEffects(state, player);
        return state;
    }

    private void paintEnvironmentalBase(FrameStateDto state, PlayerDto player) {
        long now = System.currentTimeMillis();
        RGBColorDto baseColor = new RGBColorDto(0, 0, 0);
        if (MineLightsClient.CONFIG.enableBiomeEffects) {
            if (!player.getCurrentBiome().equals(this.lastKnownBiome) && !player.getCurrentBiome().isEmpty()) {
                this.transitionStartColor = this.currentSmoothBiomeColor;
                this.targetBiomeColor = BiomeData.getBiomeColor(player.getCurrentBiome());
                this.lastKnownBiome = player.getCurrentBiome();
                this.transitionStartTime = now;
            }
            long elapsedMs = now - this.transitionStartTime;
            float t = Math.min(1.0f, (float)elapsedMs / 750.0f);
            baseColor = this.currentSmoothBiomeColor = this.lerpColor(this.transitionStartColor, this.targetBiomeColor, t);
        }
        if (MineLightsClient.CONFIG.enableOnFireEffect && player.getIsOnFire()) {
            baseColor = new RGBColorDto(255, 69, 0);
        } else if (MineLightsClient.CONFIG.enablePortalEffects && player.getCurrentBlock().equals("block.minecraft.nether_portal")) {
            baseColor = new RGBColorDto(128, 0, 128);
        } else if (MineLightsClient.CONFIG.enablePortalEffects && player.getCurrentBlock().equals("block.minecraft.end_portal")) {
            baseColor = new RGBColorDto(0, 0, 50);
        }
        for (Integer ledId : this.allLedIds) {
            state.keys.put(ledId, baseColor);
        }
        this.paintSpecialWorldEffects(state, player, now);
    }

    private void paintSpecialWorldEffects(FrameStateDto state, PlayerDto player, long now) {
        block13: {
            block15: {
                block14: {
                    block12: {
                        if (MineLightsClient.CONFIG.enableWeatherEffects && player.getWeather().equals("Thunderstorm") && !this.isFlashing && this.random.nextInt(200) < 1) {
                            this.isFlashing = true;
                            this.flashStartTime = now;
                        }
                        if (this.isFlashing) {
                            if (now - this.flashStartTime < 150L) {
                                for (Integer ledId : this.allLedIds) {
                                    state.keys.put(ledId, new RGBColorDto(255, 255, 255));
                                }
                                return;
                            }
                            this.isFlashing = false;
                        }
                        if (!MineLightsClient.CONFIG.enableOnFireEffect || !player.getIsOnFire()) break block12;
                        if (now - this.lastFireCrackleUpdate > 100L) {
                            this.updateRandomKeys(this.cracklingKeys, 0.2f);
                            this.lastFireCrackleUpdate = now;
                        }
                        for (Integer keyId : this.cracklingKeys) {
                            state.keys.put(keyId, new RGBColorDto(200, 0, 0));
                        }
                        break block13;
                    }
                    if (!MineLightsClient.CONFIG.enablePortalEffects || !player.getCurrentBlock().equals("block.minecraft.nether_portal")) break block14;
                    if (now - this.lastPortalTwinkleUpdate > 500L) {
                        this.updateRandomKeys(this.twinklingKeys, 0.2f);
                        this.lastPortalTwinkleUpdate = now;
                    }
                    for (Integer keyId : this.twinklingKeys) {
                        state.keys.put(keyId, new RGBColorDto(50, 0, 100));
                    }
                    break block13;
                }
                if (!MineLightsClient.CONFIG.enablePortalEffects || !player.getCurrentBlock().equals("block.minecraft.end_portal")) break block15;
                if (now - this.lastPortalTwinkleUpdate > 500L) {
                    this.updateRandomKeys(this.twinklingKeys, 0.2f);
                    this.lastPortalTwinkleUpdate = now;
                }
                for (Integer keyId : this.twinklingKeys) {
                    state.keys.put(keyId, new RGBColorDto(50, 50, 50));
                }
                break block13;
            }
            if (!MineLightsClient.CONFIG.enableWeatherEffects || !player.getWeather().equals("Rain") && !player.getWeather().equals("Thunderstorm") || !BiomeData.isBiomeRainy(player.getCurrentBiome())) break block13;
            if (now - this.lastRainStep > 500L) {
                this.rainPhase = !this.rainPhase;
                this.lastRainStep = now;
            }
            RGBColorDto rainColor = BiomeData.getBiomeRainColor(player.getCurrentBiome());
            for (int i = 0; i < this.allLedIds.size(); ++i) {
                if (i % 2 != (this.rainPhase ? 0 : 1)) continue;
                state.keys.put(this.allLedIds.get(i), rainColor);
            }
        }
    }

    private void paintExperienceBar(FrameStateDto state, PlayerDto player) {
        List<String> logicalKeys = KeyMap.getExperienceBar();
        int ledsToLight = (int)(player.getExperience() * (float)logicalKeys.size());
        for (int i = 0; i < logicalKeys.size(); ++i) {
            Integer ledId = this.getMappedId(logicalKeys.get(i));
            if (ledId == null) continue;
            if (i < ledsToLight) {
                state.keys.put(ledId, new RGBColorDto(0, 255, 0));
                continue;
            }
            state.keys.put(ledId, new RGBColorDto(10, 30, 10));
        }
    }

    private void paintPlayerBars(FrameStateDto state, PlayerDto player) {
        Integer ledId;
        int i;
        if (player.getIsTakingDamage() && !this.wasTakingDamageLastFrame) {
            this.isDamageFlashActive = true;
            this.damageFlashStartTime = System.currentTimeMillis();
        }
        this.wasTakingDamageLastFrame = player.getIsTakingDamage();
        if (this.isDamageFlashActive && System.currentTimeMillis() - this.damageFlashStartTime >= 120L) {
            this.isDamageFlashActive = false;
        }
        if (MineLightsClient.CONFIG.enableHealthBar) {
            RGBColorDto healthDim = new RGBColorDto(30, 0, 0);
            RGBColorDto healthFull = new RGBColorDto(255, 0, 0);
            List<String> healthKeys = KeyMap.getHealthBar();
            for (i = 0; i < healthKeys.size(); ++i) {
                RGBColorDto finalColor;
                ledId = this.getMappedId(healthKeys.get(i));
                if (ledId == null) continue;
                if (this.isDamageFlashActive) {
                    finalColor = new RGBColorDto(255, 255, 255);
                } else if (player.getIsWithering()) {
                    finalColor = new RGBColorDto(43, 43, 43);
                } else if (player.getIsPoisoned()) {
                    finalColor = new RGBColorDto(148, 120, 24);
                } else {
                    float t = (player.getHealth() - (float)i * 5.0f) / 5.0f;
                    finalColor = this.lerpColor(healthDim, healthFull, t);
                }
                state.keys.put(ledId, finalColor);
            }
        }
        if (MineLightsClient.CONFIG.enableHungerBar) {
            RGBColorDto hungerDim = new RGBColorDto(30, 15, 0);
            RGBColorDto hungerFull = new RGBColorDto(255, 165, 0);
            List<String> hungerKeys = KeyMap.getHungerBar();
            for (i = 0; i < hungerKeys.size(); ++i) {
                ledId = this.getMappedId(hungerKeys.get(i));
                if (ledId == null) continue;
                float t = ((float)player.getHunger() - (float)i * 5.0f) / 5.0f;
                state.keys.put(ledId, this.lerpColor(hungerDim, hungerFull, t));
            }
        }
    }

    private void paintSaturationAndAirBar(FrameStateDto state, PlayerDto player) {
        RGBColorDto dimColor;
        RGBColorDto fullColor;
        float maxValue;
        float value;
        boolean showAirBar;
        List<String> barKeys = KeyMap.getSaturationBar();
        boolean isInWaterNow = player.getCurrentBlock().equals("block.minecraft.water");
        if (isInWaterNow) {
            this.lastInWaterTime = System.currentTimeMillis();
        }
        boolean bl = showAirBar = isInWaterNow || System.currentTimeMillis() - this.lastInWaterTime < 2500L;
        if (showAirBar) {
            value = player.getAir();
            maxValue = 300.0f;
            fullColor = new RGBColorDto(173, 216, 230);
            dimColor = new RGBColorDto(0, 0, 50);
        } else {
            value = player.getSaturation();
            maxValue = 20.0f;
            fullColor = new RGBColorDto(200, 255, 0);
            dimColor = new RGBColorDto(40, 50, 0);
        }
        float valuePerKey = maxValue / (float)barKeys.size();
        for (int i = 0; i < barKeys.size(); ++i) {
            Integer ledId = this.getMappedId(barKeys.get(i));
            if (ledId == null) continue;
            float t = (value - (float)i * valuePerKey) / valuePerKey;
            state.keys.put(ledId, this.lerpColor(dimColor, fullColor, t));
        }
    }

    private void paintHealthEffects(FrameStateDto state, PlayerDto player) {
        Integer ledId;
        boolean isLowHealthNow;
        boolean bl = isLowHealthNow = player.getHealth() < 10.0f;
        if (isLowHealthNow && !this.wasLowHealthLastFrame) {
            this.heartbeatBrightness = 0.1f;
            this.isHeartBeatingUp = true;
            this.lastHeartbeatStep = System.currentTimeMillis();
        }
        this.wasLowHealthLastFrame = isLowHealthNow;
        if (!isLowHealthNow) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastHeartbeatStep > 40L) {
            if (this.isHeartBeatingUp) {
                this.heartbeatBrightness += 0.1f;
                if (this.heartbeatBrightness >= 1.0f) {
                    this.heartbeatBrightness = 1.0f;
                    this.isHeartBeatingUp = false;
                }
            } else {
                this.heartbeatBrightness -= 0.1f;
                if (this.heartbeatBrightness <= 0.1f) {
                    this.heartbeatBrightness = 0.1f;
                    this.isHeartBeatingUp = true;
                }
            }
            this.lastHeartbeatStep = now;
        }
        int r = (int)(255.0f * this.heartbeatBrightness);
        for (String keyName : KeyMap.getHeartbeatRed()) {
            ledId = this.getMappedId(keyName);
            if (ledId == null) continue;
            state.keys.put(ledId, new RGBColorDto(r, 0, 0));
        }
        for (String keyName : KeyMap.getHeartbeatWhite()) {
            ledId = this.getMappedId(keyName);
            if (ledId == null) continue;
            state.keys.put(ledId, new RGBColorDto(r, r, r));
        }
    }

    private void paintCompass(FrameStateDto state, PlayerDto player) {
        RGBColorDto backgroundColor;
        RGBColorDto compassColor;
        if (player.getCompassType() == CompassType.NONE) {
            return;
        }
        switch (player.getCompassType()) {
            case RECOVERY: {
                compassColor = new RGBColorDto(0, 191, 255);
                backgroundColor = new RGBColorDto(0, 20, 35);
                break;
            }
            default: {
                compassColor = new RGBColorDto(255, 0, 0);
                backgroundColor = new RGBColorDto(35, 0, 0);
            }
        }
        for (String keyName : KeyMap.getNumpadDirectional()) {
            Integer ledId = this.getMappedId(keyName);
            if (ledId == null) continue;
            state.keys.put(ledId, backgroundColor);
        }
        Integer centerLedId = this.getMappedId(KeyMap.getNumpadCenter());
        if (centerLedId != null) {
            state.keys.put(centerLedId, compassColor);
        }
        if (player.getCompassState() == CompassState.SPINNING || player.getCurrentWorld().equals("the_nether") || player.getCurrentWorld().equals("the_end")) {
            String keyToLight;
            Integer ledId;
            long now = System.currentTimeMillis();
            if (now - this.lastCompassSpinTime > 75L) {
                this.compassSpinIndex = (this.compassSpinIndex + 1) % KeyMap.getNumpadDirectional().size();
                this.lastCompassSpinTime = now;
            }
            if ((ledId = this.getMappedId(keyToLight = KeyMap.getNumpadDirectional().get(this.compassSpinIndex))) != null) {
                state.keys.put(ledId, compassColor);
            }
        } else if (player.getCompassState() == CompassState.POINTING) {
            if (player.getCompassDistance() != null && player.getCompassDistance() < 8.0) {
                if (centerLedId != null) {
                    long now = System.currentTimeMillis();
                    double pulseWave = (Math.sin((double)now / 318.3098861837907) + 1.0) / 2.0;
                    float brightness = (float)(0.6 + pulseWave * 0.4);
                    RGBColorDto pulsedColor = new RGBColorDto((int)((float)compassColor.r * brightness), (int)((float)compassColor.g * brightness), (int)((float)compassColor.b * brightness));
                    state.keys.put(centerLedId, pulsedColor);
                }
            } else {
                Double relativeYaw = player.getCompassRelativeYaw();
                if (relativeYaw == null) {
                    return;
                }
                String keyToLight = relativeYaw >= -22.5 && relativeYaw < 22.5 ? "NUMPAD8" : (relativeYaw >= 22.5 && relativeYaw < 67.5 ? "NUMPAD9" : (relativeYaw >= 67.5 && relativeYaw < 112.5 ? "NUMPAD6" : (relativeYaw >= 112.5 && relativeYaw < 157.5 ? "NUMPAD3" : (relativeYaw >= 157.5 || relativeYaw < -157.5 ? "NUMPAD2" : (relativeYaw >= -157.5 && relativeYaw < -112.5 ? "NUMPAD1" : (relativeYaw >= -112.5 && relativeYaw < -67.5 ? "NUMPAD4" : "NUMPAD7"))))));
                Integer ledId = this.getMappedId(keyToLight);
                if (ledId != null) {
                    state.keys.put(ledId, compassColor);
                }
            }
        }
    }

    private void paintPlayerEffects(FrameStateDto state, PlayerDto player) {
        RGBColorDto keyColor = null;
        if (MineLightsClient.CONFIG.enableInWaterEffect && player.getCurrentBlock().equals("block.minecraft.water")) {
            keyColor = new RGBColorDto(0, 100, 255);
        } else if (MineLightsClient.CONFIG.enableOnFireEffect && (player.getCurrentBlock().equals("block.minecraft.lava") || player.getCurrentBlock().equals("block.minecraft.fire"))) {
            keyColor = new RGBColorDto(255, 0, 0);
        } else if (MineLightsClient.CONFIG.highlightMovementKeys) {
            keyColor = new RGBColorDto(255, 255, 255);
        }
        if (keyColor != null) {
            for (String keyName : this.getMovementKeyNames()) {
                Integer ledId = this.getMappedId(keyName);
                if (ledId == null) continue;
                state.keys.put(ledId, keyColor);
            }
        }
    }

    private List<String> getMovementKeyNames() {
        ArrayList<String> friendlyNames = new ArrayList<String>();
        class_315 options = class_310.method_1551().field_1690;
        List<String> keybindsToFetch = Arrays.asList(options.field_1894.method_1429().toString(), options.field_1881.method_1429().toString(), options.field_1913.method_1429().toString(), options.field_1849.method_1429().toString(), options.field_1903.method_1429().toString(), options.field_1832.method_1429().toString(), options.field_1867.method_1429().toString());
        for (String key : keybindsToFetch) {
            if (key == null || !key.startsWith("key.keyboard.")) continue;
            String[] parts = key.split("\\.");
            String friendlyName = "";
            if (parts.length == 4) {
                friendlyName = (parts[2].substring(0, 1) + parts[3]).toUpperCase();
            } else if (parts.length == 3) {
                friendlyName = parts[2].toUpperCase();
            }
            if (friendlyName.isEmpty()) continue;
            friendlyNames.add(friendlyName);
        }
        return friendlyNames;
    }

    private void updateRandomKeys(List<Integer> keyList, float density) {
        keyList.clear();
        if (this.allLedIds.isEmpty()) {
            return;
        }
        int count = (int)((float)this.allLedIds.size() * density);
        for (int i = 0; i < count; ++i) {
            keyList.add(this.allLedIds.get(this.random.nextInt(this.allLedIds.size())));
        }
    }

    private RGBColorDto lerpColor(RGBColorDto start, RGBColorDto end, float t) {
        return new RGBColorDto(this.lerp(start.r, end.r, t), this.lerp(start.g, end.g, t), this.lerp(start.b, end.b, t));
    }

    private int lerp(int start, int end, float t) {
        t = Math.max(0.0f, Math.min(1.0f, t));
        return (int)((float)start + (float)(end - start) * t);
    }
}

