package megabytesme.minelights.config;

import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_6379;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class LiveLogEntry extends AbstractConfigListEntry<String> {
    private final List<String> logLines;
    private int scrollY = 0;
    private int lastEntryWidth = 0;
    private List<String> wrappedLinesCache = new ArrayList<>();

    public LiveLogEntry(String fieldName, List<String> logLines) {
        //? if >=1.19 {
        super(class_2561.method_43470(fieldName), false);
        //?} else if >=1.16 {
        /*super(new LiteralText(fieldName), false);
        *///?} else {
        /*
        super(fieldName, false);
        */
        //?}
        this.logLines = logLines;
    }
    
    //? if >=1.20.5 {
    /*@Override
    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int maxScroll = Math.max(0, (wrappedLinesCache.size() * 10) - getItemHeight());
        scrollY -= (int) (verticalAmount * 10);
        scrollY = MathHelper.clamp(scrollY, 0, maxScroll);
        return true;
    }
    *///?} else if <1.20.5 {
     @Override
    public boolean method_25401(double mouseX, double mouseY, double amount) {
        int maxScroll = Math.max(0, (wrappedLinesCache.size() * 10) - getItemHeight());
        scrollY -= (int) (amount * 10);
        scrollY = class_3532.method_15340(scrollY, 0, maxScroll);
        return true;
    }
    //?}

    @Override
    public String getValue() { return ""; }

    @Override
    public Optional<String> getDefaultValue() { return Optional.empty(); }

    @Override
    public void save() {}

    @Override
    public boolean isRequiresRestart() { return false; }

    @Override
    public void setRequiresRestart(boolean requiresRestart) {}

    @Override
    public int getItemHeight() { return 120; }

    @Override
    public List<? extends class_364> method_25396() { return Collections.emptyList(); }

    //? if >=1.16.3 {
    @Override
    public List<? extends class_6379> narratables() {
        return Collections.emptyList();
    }
    //?}

    //? if >=1.20 {
    /*@Override
    public void render(DrawContext context, int index, int y, int x,
                       int entryWidth, int entryHeight,
                       int mouseX, int mouseY,
                       boolean isHovered, float delta) {
        renderLog(context, x, y, entryWidth, entryHeight);
    }
    *///?} else if >=1.16 {
    
    @Override
    public void render(class_4587 matrices, int index, int y, int x,
                       int entryWidth, int entryHeight,
                       int mouseX, int mouseY,
                       boolean isHovered, float delta) {
        renderLog(matrices, x, y, entryWidth, entryHeight);
    }
    //?} else {
    /*
    @Override
    public void render(int index, int y, int x,
                       int entryWidth, int entryHeight,
                       int mouseX, int mouseY,
                       boolean isHovered, float delta) {
        renderLog(null, x, y, entryWidth, entryHeight);
    }
    */
    //?}

    private void renderLog(Object contextOrMatrices, int x, int y, int entryWidth, int entryHeight) {
        if (entryWidth != lastEntryWidth) {
            lastEntryWidth = entryWidth;
            wrappedLinesCache.clear();
            synchronized (logLines) {
                for (String raw : logLines) {
                    wrappedLinesCache.addAll(wrapString(raw, entryWidth - 15));
                }
            }
        }

        class_327 textRenderer = class_310.method_1551().field_1772;
        int maxScroll = Math.max(0, (wrappedLinesCache.size() * 10) - entryHeight);
        scrollY = class_3532.method_15340(scrollY, 0, maxScroll);

        int startX = x + 2;
        for (int i = 0; i < wrappedLinesCache.size(); i++) {
            int lineY = y + 2 + (i * 10) - scrollY;
            if (lineY >= y && lineY < y + entryHeight - 5) {
                String part = wrappedLinesCache.get(i);
                //? if >=1.20 {
                /*((DrawContext) contextOrMatrices).drawText(textRenderer, part, startX, lineY, 0xFFFFFF, false);
                *///?} else if >=1.16 {
                
                textRenderer.method_1729((class_4587) contextOrMatrices, part, startX, lineY, 0xFFFFFF);
                //?} else {
                /*
                textRenderer.draw(part, (float) startX, (float) lineY, 0xFFFFFF);
                */
                //?}
            }
        }

        if (maxScroll > 0) {
            int scrollbarX = x + entryWidth - 6;
            int scrollbarHeight = entryHeight;
            int thumbHeight = Math.max(10, (int) ((scrollbarHeight / (float) (wrappedLinesCache.size() * 10)) * scrollbarHeight));
            int thumbY = y + (int) (((float) scrollY / maxScroll) * (scrollbarHeight - thumbHeight));

            //? if >=1.20 {
            /*DrawContext context = (DrawContext) contextOrMatrices;
            context.fill(scrollbarX, y, scrollbarX + 5, y + scrollbarHeight, 0xFF000000);
            context.fill(scrollbarX, thumbY, scrollbarX + 5, thumbY + thumbHeight, 0xFF888888);
            *///?} else if >=1.16 {
            
            class_4587 matrices = (class_4587) contextOrMatrices;
            class_332.method_25294(matrices, scrollbarX, y, scrollbarX + 5, y + scrollbarHeight, 0xFF000000);
            class_332.method_25294(matrices, scrollbarX, thumbY, scrollbarX + 5, thumbY + thumbHeight, 0xFF888888);
            //?} else {
            /*
            DrawableHelper.fill(scrollbarX, y, scrollbarX + 5, y + scrollbarHeight, 0xFF000000);
            DrawableHelper.fill(scrollbarX, thumbY, scrollbarX + 5, thumbY + thumbHeight, 0xFF888888);
            */
            //?}
        }
    }

    private List<String> wrapString(String text, int maxWidth) {
        class_327 tr = class_310.method_1551().field_1772;
        List<String> lines = new ArrayList<>();
        if (maxWidth <= 10 || text.isEmpty()) {
            lines.add(text);
            return lines;
        }

        StringBuilder currentLine = new StringBuilder();
        String[] words = text.split(" ");
        for (String word : words) {
            String potentialLine = currentLine.length() == 0 ? word : currentLine + " " + word;
            
            //? if >=1.16 {
            int width = tr.method_1727(potentialLine);
            //?} else {
            /*
            int width = tr.getStringWidth(potentialLine);
            */
            //?}

            if (width > maxWidth && currentLine.length() > 0) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder(word);
            } else {
                currentLine = new StringBuilder(potentialLine);
            }
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }

        return lines;
    }
}