/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.additionsmoneycounts.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.mcreator.additionsmoneycounts.MoneyCountsMod;
import net.mcreator.additionsmoneycounts.procedures.CalculatedNumberProcedure;
import net.mcreator.additionsmoneycounts.procedures.ClearProcedure;
import net.mcreator.additionsmoneycounts.procedures.DividideProcedure;
import net.mcreator.additionsmoneycounts.procedures.MinusProcedure;
import net.mcreator.additionsmoneycounts.procedures.PlusProcedure;
import net.mcreator.additionsmoneycounts.procedures.RunSelectedProcedure;
import net.mcreator.additionsmoneycounts.procedures.SelectedCalculator1Procedure;
import net.mcreator.additionsmoneycounts.procedures.SelectedCalculator2Procedure;
import net.mcreator.additionsmoneycounts.procedures.SelectedCalculator3Procedure;
import net.mcreator.additionsmoneycounts.procedures.TimesProcedure;
import net.mcreator.additionsmoneycounts.world.inventory.CalculatorGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CalculatorGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;
    private HashMap<String, String> textstate;

    public CalculatorGUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.textstate = CalculatorGUIButtonMessage.readTextState(buffer);
    }

    public CalculatorGUIButtonMessage(int buttonID, int x, int y, int z, HashMap<String, String> textstate) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
        this.textstate = textstate;
    }

    public static void buffer(CalculatorGUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        CalculatorGUIButtonMessage.writeTextState(message.textstate, buffer);
    }

    public static void handler(CalculatorGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            HashMap<String, String> textstate = message.textstate;
            CalculatorGUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z, textstate);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z, HashMap<String, String> textstate) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = CalculatorGUIMenu.guistate;
        for (Map.Entry<String, String> entry : textstate.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            guistate.put(key, value);
        }
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            PlusProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            MinusProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            DividideProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            TimesProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            SelectedCalculator1Procedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            SelectedCalculator2Procedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            SelectedCalculator3Procedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            CalculatedNumberProcedure.execute((Entity)entity);
        }
        if (buttonID == 8) {
            ClearProcedure.execute((Entity)entity);
        }
        if (buttonID == 9) {
            RunSelectedProcedure.execute((Entity)entity, guistate);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        MoneyCountsMod.addNetworkMessage(CalculatorGUIButtonMessage.class, CalculatorGUIButtonMessage::buffer, CalculatorGUIButtonMessage::new, CalculatorGUIButtonMessage::handler);
    }

    public static void writeTextState(HashMap<String, String> map, FriendlyByteBuf buffer) {
        buffer.writeInt(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            buffer.m_130083_((Component)Component.m_237113_((String)entry.getKey()));
            buffer.m_130083_((Component)Component.m_237113_((String)entry.getValue()));
        }
    }

    public static HashMap<String, String> readTextState(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < size; ++i) {
            String key = buffer.m_130238_().getString();
            String value = buffer.m_130238_().getString();
            map.put(key, value);
        }
        return map;
    }
}

