/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.additionsmoneycounts.network;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.mcreator.additionsmoneycounts.MoneyCountsMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MoneyCountsModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        MoneyCountsMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        MoneyCountsMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        MoneyCountsMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final int target;
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
            this.target = buffer.readInt();
        }

        public PlayerVariablesSyncMessage(PlayerVariables data, int entityid) {
            this.data = data;
            this.target = entityid;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
            buffer.writeInt(message.target);
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.m_9236_().m_6815_(message.target).getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.Streamer_Mode = message.data.Streamer_Mode;
                    variables.show_salary = message.data.show_salary;
                    variables.Players_Job = message.data.Players_Job;
                    variables.players_high_winstreak = message.data.players_high_winstreak;
                    variables.player_winstreak = message.data.player_winstreak;
                    variables.player_money_new = message.data.player_money_new;
                    variables.player_money = message.data.player_money;
                    variables.Player_Gender_Visible = message.data.Player_Gender_Visible;
                    variables.player_gender = message.data.player_gender;
                    variables.player_foundable_apps = message.data.player_foundable_apps;
                    variables.player_file_name = message.data.player_file_name;
                    variables.player_age = message.data.player_age;
                    variables.Outsert_Automatic_Card = message.data.Outsert_Automatic_Card;
                    variables.new_money = message.data.new_money;
                    variables.money_salary = message.data.money_salary;
                    variables.lost_money = message.data.lost_money;
                    variables.hunting_entity_price = message.data.hunting_entity_price;
                    variables.hunting_entity_percent = message.data.hunting_entity_percent;
                    variables.hunting_entity_ka = message.data.hunting_entity_ka;
                    variables.hunting_entity_id = message.data.hunting_entity_id;
                    variables.hunting_entity_before_salary = message.data.hunting_entity_before_salary;
                    variables.hunting_entity = message.data.hunting_entity;
                    variables.current_location_folder = message.data.current_location_folder;
                    variables.bills = message.data.bills;
                    variables.Backgrounds = message.data.Backgrounds;
                    variables.trade_01 = message.data.trade_01;
                    variables.trade_01_require_a = message.data.trade_01_require_a;
                    variables.trade_01_require_b = message.data.trade_01_require_b;
                    variables.trade_02 = message.data.trade_02;
                    variables.trade_02_require_a = message.data.trade_02_require_a;
                    variables.trade_02_require_b = message.data.trade_02_require_b;
                    variables.trade_03 = message.data.trade_03;
                    variables.trade_03_require_a = message.data.trade_03_require_a;
                    variables.trade_03_require_b = message.data.trade_03_require_b;
                    variables.player_trading_cp = message.data.player_trading_cp;
                    variables.player_trading_level = message.data.player_trading_level;
                    variables.rerolls = message.data.rerolls;
                    variables.RadialMenuButton00 = message.data.RadialMenuButton00;
                    variables.RadialMenuButton01 = message.data.RadialMenuButton01;
                    variables.RadialMenuButton02 = message.data.RadialMenuButton02;
                    variables.RadialMenuButton03 = message.data.RadialMenuButton03;
                    variables.RadialMenuButton04 = message.data.RadialMenuButton04;
                    variables.RadialMenuButton05 = message.data.RadialMenuButton05;
                    variables.RadialMenuButton06 = message.data.RadialMenuButton06;
                    variables.RadialMenuButton07 = message.data.RadialMenuButton07;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean Streamer_Mode = false;
        public boolean show_salary = false;
        public String Players_Job = "";
        public double players_high_winstreak = 0.0;
        public double player_winstreak = 0.0;
        public boolean player_money_new = false;
        public double player_money = 0.0;
        public String Player_Gender_Visible = "";
        public String player_gender = "";
        public String player_foundable_apps = "";
        public String player_file_name = "";
        public double player_age = 0.0;
        public boolean Outsert_Automatic_Card = false;
        public double new_money = 0.0;
        public double money_salary = 0.0;
        public double lost_money = 0.0;
        public double hunting_entity_price = 0.0;
        public double hunting_entity_percent = 0.0;
        public String hunting_entity_ka = "";
        public String hunting_entity_id = "";
        public double hunting_entity_before_salary = 0.0;
        public String hunting_entity = "";
        public String current_location_folder = "";
        public double bills = 0.0;
        public String Backgrounds = "";
        public String trade_01 = "";
        public String trade_01_require_a = "";
        public String trade_01_require_b = "";
        public String trade_02 = "";
        public String trade_02_require_a = "";
        public String trade_02_require_b = "";
        public String trade_03 = "";
        public String trade_03_require_a = "";
        public String trade_03_require_b = "";
        public double player_trading_cp = 0.0;
        public double player_trading_level = 0.0;
        public double rerolls = 0.0;
        public String RadialMenuButton00 = "";
        public String RadialMenuButton01 = "";
        public String RadialMenuButton02 = "";
        public String RadialMenuButton03 = "";
        public String RadialMenuButton04 = "";
        public String RadialMenuButton05 = "";
        public String RadialMenuButton06 = "";
        public String RadialMenuButton07 = "";

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                MoneyCountsMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)entity.m_9236_()).m_46472_()), (Object)new PlayerVariablesSyncMessage(this, entity.m_19879_()));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("Streamer_Mode", this.Streamer_Mode);
            nbt.m_128379_("show_salary", this.show_salary);
            nbt.m_128359_("Players_Job", this.Players_Job);
            nbt.m_128347_("players_high_winstreak", this.players_high_winstreak);
            nbt.m_128347_("player_winstreak", this.player_winstreak);
            nbt.m_128379_("player_money_new", this.player_money_new);
            nbt.m_128347_("player_money", this.player_money);
            nbt.m_128359_("Player_Gender_Visible", this.Player_Gender_Visible);
            nbt.m_128359_("player_gender", this.player_gender);
            nbt.m_128359_("player_foundable_apps", this.player_foundable_apps);
            nbt.m_128359_("player_file_name", this.player_file_name);
            nbt.m_128347_("player_age", this.player_age);
            nbt.m_128379_("Outsert_Automatic_Card", this.Outsert_Automatic_Card);
            nbt.m_128347_("new_money", this.new_money);
            nbt.m_128347_("money_salary", this.money_salary);
            nbt.m_128347_("lost_money", this.lost_money);
            nbt.m_128347_("hunting_entity_price", this.hunting_entity_price);
            nbt.m_128347_("hunting_entity_percent", this.hunting_entity_percent);
            nbt.m_128359_("hunting_entity_ka", this.hunting_entity_ka);
            nbt.m_128359_("hunting_entity_id", this.hunting_entity_id);
            nbt.m_128347_("hunting_entity_before_salary", this.hunting_entity_before_salary);
            nbt.m_128359_("hunting_entity", this.hunting_entity);
            nbt.m_128359_("current_location_folder", this.current_location_folder);
            nbt.m_128347_("bills", this.bills);
            nbt.m_128359_("Backgrounds", this.Backgrounds);
            nbt.m_128359_("trade_01", this.trade_01);
            nbt.m_128359_("trade_01_require_a", this.trade_01_require_a);
            nbt.m_128359_("trade_01_require_b", this.trade_01_require_b);
            nbt.m_128359_("trade_02", this.trade_02);
            nbt.m_128359_("trade_02_require_a", this.trade_02_require_a);
            nbt.m_128359_("trade_02_require_b", this.trade_02_require_b);
            nbt.m_128359_("trade_03", this.trade_03);
            nbt.m_128359_("trade_03_require_a", this.trade_03_require_a);
            nbt.m_128359_("trade_03_require_b", this.trade_03_require_b);
            nbt.m_128347_("player_trading_cp", this.player_trading_cp);
            nbt.m_128347_("player_trading_level", this.player_trading_level);
            nbt.m_128347_("rerolls", this.rerolls);
            nbt.m_128359_("RadialMenuButton00", this.RadialMenuButton00);
            nbt.m_128359_("RadialMenuButton01", this.RadialMenuButton01);
            nbt.m_128359_("RadialMenuButton02", this.RadialMenuButton02);
            nbt.m_128359_("RadialMenuButton03", this.RadialMenuButton03);
            nbt.m_128359_("RadialMenuButton04", this.RadialMenuButton04);
            nbt.m_128359_("RadialMenuButton05", this.RadialMenuButton05);
            nbt.m_128359_("RadialMenuButton06", this.RadialMenuButton06);
            nbt.m_128359_("RadialMenuButton07", this.RadialMenuButton07);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt;
            if (tag == null) {
                tag = this.writeNBT();
            }
            if ((nbt = (CompoundTag)tag) == null) {
                nbt = (CompoundTag)this.writeNBT();
            }
            this.Streamer_Mode = nbt.m_128471_("Streamer_Mode");
            this.show_salary = nbt.m_128471_("show_salary");
            this.Players_Job = nbt.m_128461_("Players_Job");
            this.players_high_winstreak = nbt.m_128459_("players_high_winstreak");
            this.player_winstreak = nbt.m_128459_("player_winstreak");
            this.player_money_new = nbt.m_128471_("player_money_new");
            this.player_money = nbt.m_128459_("player_money");
            this.Player_Gender_Visible = nbt.m_128461_("Player_Gender_Visible");
            this.player_gender = nbt.m_128461_("player_gender");
            this.player_foundable_apps = nbt.m_128461_("player_foundable_apps");
            this.player_file_name = nbt.m_128461_("player_file_name");
            this.player_age = nbt.m_128459_("player_age");
            this.Outsert_Automatic_Card = nbt.m_128471_("Outsert_Automatic_Card");
            this.new_money = nbt.m_128459_("new_money");
            this.money_salary = nbt.m_128459_("money_salary");
            this.lost_money = nbt.m_128459_("lost_money");
            this.hunting_entity_price = nbt.m_128459_("hunting_entity_price");
            this.hunting_entity_percent = nbt.m_128459_("hunting_entity_percent");
            this.hunting_entity_ka = nbt.m_128461_("hunting_entity_ka");
            this.hunting_entity_id = nbt.m_128461_("hunting_entity_id");
            this.hunting_entity_before_salary = nbt.m_128459_("hunting_entity_before_salary");
            this.hunting_entity = nbt.m_128461_("hunting_entity");
            this.current_location_folder = nbt.m_128461_("current_location_folder");
            this.bills = nbt.m_128459_("bills");
            this.Backgrounds = nbt.m_128461_("Backgrounds");
            this.trade_01 = nbt.m_128461_("trade_01");
            this.trade_01_require_a = nbt.m_128461_("trade_01_require_a");
            this.trade_01_require_b = nbt.m_128461_("trade_01_require_b");
            this.trade_02 = nbt.m_128461_("trade_02");
            this.trade_02_require_a = nbt.m_128461_("trade_02_require_a");
            this.trade_02_require_b = nbt.m_128461_("trade_02_require_b");
            this.trade_03 = nbt.m_128461_("trade_03");
            this.trade_03_require_a = nbt.m_128461_("trade_03_require_a");
            this.trade_03_require_b = nbt.m_128461_("trade_03_require_b");
            this.player_trading_cp = nbt.m_128459_("player_trading_cp");
            this.player_trading_level = nbt.m_128459_("player_trading_level");
            this.rerolls = nbt.m_128459_("rerolls");
            this.RadialMenuButton00 = nbt.m_128461_("RadialMenuButton00");
            this.RadialMenuButton01 = nbt.m_128461_("RadialMenuButton01");
            this.RadialMenuButton02 = nbt.m_128461_("RadialMenuButton02");
            this.RadialMenuButton03 = nbt.m_128461_("RadialMenuButton03");
            this.RadialMenuButton04 = nbt.m_128461_("RadialMenuButton04");
            this.RadialMenuButton05 = nbt.m_128461_("RadialMenuButton05");
            this.RadialMenuButton06 = nbt.m_128461_("RadialMenuButton06");
            this.RadialMenuButton07 = nbt.m_128461_("RadialMenuButton07");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("money_counts", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "money_counts_mapvars";
        public String Jobs = "";
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            if (nbt == null) {
                nbt = this.m_7176_(new CompoundTag());
            }
            this.Jobs = nbt.m_128461_("Jobs");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128359_("Jobs", this.Jobs);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                MoneyCountsMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "money_counts_worldvars";
        public double Day = 0.0;
        public double Current_making_Description = 0.0;
        public String Available_Apps = "Calculator, Job, Clock, Notes, Remote, ";
        public String radial_menu = "Quests, Universal Pad, Trading, Credits, ";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.Day = nbt.m_128459_("Day");
            this.Current_making_Description = nbt.m_128459_("Current_making_Description");
            this.Available_Apps = nbt.m_128461_("Available_Apps");
            this.radial_menu = nbt.m_128461_("radial_menu");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("Day", this.Day);
            nbt.m_128347_("Current_making_Description", this.Current_making_Description);
            nbt.m_128359_("Available_Apps", this.Available_Apps);
            nbt.m_128359_("radial_menu", this.radial_menu);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                MoneyCountsMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.Streamer_Mode = original.Streamer_Mode;
            clone.show_salary = original.show_salary;
            clone.Players_Job = original.Players_Job;
            clone.players_high_winstreak = original.players_high_winstreak;
            clone.player_winstreak = original.player_winstreak;
            clone.player_money_new = original.player_money_new;
            clone.player_money = original.player_money;
            clone.Player_Gender_Visible = original.Player_Gender_Visible;
            clone.player_gender = original.player_gender;
            clone.player_foundable_apps = original.player_foundable_apps;
            clone.player_file_name = original.player_file_name;
            clone.player_age = original.player_age;
            clone.Outsert_Automatic_Card = original.Outsert_Automatic_Card;
            clone.new_money = original.new_money;
            clone.money_salary = original.money_salary;
            clone.lost_money = original.lost_money;
            clone.hunting_entity_price = original.hunting_entity_price;
            clone.hunting_entity_percent = original.hunting_entity_percent;
            clone.hunting_entity_ka = original.hunting_entity_ka;
            clone.hunting_entity_id = original.hunting_entity_id;
            clone.hunting_entity_before_salary = original.hunting_entity_before_salary;
            clone.hunting_entity = original.hunting_entity;
            clone.current_location_folder = original.current_location_folder;
            clone.bills = original.bills;
            clone.Backgrounds = original.Backgrounds;
            clone.trade_01 = original.trade_01;
            clone.trade_01_require_a = original.trade_01_require_a;
            clone.trade_01_require_b = original.trade_01_require_b;
            clone.trade_02 = original.trade_02;
            clone.trade_02_require_a = original.trade_02_require_a;
            clone.trade_02_require_b = original.trade_02_require_b;
            clone.trade_03 = original.trade_03;
            clone.trade_03_require_a = original.trade_03_require_a;
            clone.trade_03_require_b = original.trade_03_require_b;
            clone.player_trading_cp = original.player_trading_cp;
            clone.player_trading_level = original.player_trading_level;
            clone.rerolls = original.rerolls;
            clone.RadialMenuButton00 = original.RadialMenuButton00;
            clone.RadialMenuButton01 = original.RadialMenuButton01;
            clone.RadialMenuButton02 = original.RadialMenuButton02;
            clone.RadialMenuButton03 = original.RadialMenuButton03;
            clone.RadialMenuButton04 = original.RadialMenuButton04;
            clone.RadialMenuButton05 = original.RadialMenuButton05;
            clone.RadialMenuButton06 = original.RadialMenuButton06;
            clone.RadialMenuButton07 = original.RadialMenuButton07;
            if (!event.isWasDeath()) {
                // empty if block
            }
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    MoneyCountsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    MoneyCountsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                MoneyCountsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

