/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.additionsmoneycounts.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.mcreator.additionsmoneycounts.MoneyCountsMod;
import net.mcreator.additionsmoneycounts.procedures.ClaimSellNBuyProcedure;
import net.mcreator.additionsmoneycounts.procedures.LockUnlockProcedure;
import net.mcreator.additionsmoneycounts.procedures.RunBuysSelfProcedure;
import net.mcreator.additionsmoneycounts.procedures.Selected1Procedure;
import net.mcreator.additionsmoneycounts.procedures.Selected2Procedure;
import net.mcreator.additionsmoneycounts.procedures.Selected3Procedure;
import net.mcreator.additionsmoneycounts.procedures.SetPriceForSlotProcedure;
import net.mcreator.additionsmoneycounts.procedures.TakeCashbackProcedure;
import net.mcreator.additionsmoneycounts.world.inventory.SellNBuyMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SellNBuyButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;
    private HashMap<String, String> textstate;

    public SellNBuyButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.textstate = SellNBuyButtonMessage.readTextState(buffer);
    }

    public SellNBuyButtonMessage(int buttonID, int x, int y, int z, HashMap<String, String> textstate) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
        this.textstate = textstate;
    }

    public static void buffer(SellNBuyButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        SellNBuyButtonMessage.writeTextState(message.textstate, buffer);
    }

    public static void handler(SellNBuyButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            HashMap<String, String> textstate = message.textstate;
            SellNBuyButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z, textstate);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z, HashMap<String, String> textstate) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = SellNBuyMenu.guistate;
        for (Map.Entry<String, String> entry : textstate.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            guistate.put(key, value);
        }
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            Selected1Procedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 1) {
            Selected2Procedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 2) {
            Selected3Procedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 3) {
            ClaimSellNBuyProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            LockUnlockProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 5) {
            SetPriceForSlotProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, guistate);
        }
        if (buttonID == 6) {
            RunBuysSelfProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 7) {
            TakeCashbackProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        MoneyCountsMod.addNetworkMessage(SellNBuyButtonMessage.class, SellNBuyButtonMessage::buffer, SellNBuyButtonMessage::new, SellNBuyButtonMessage::handler);
    }

    public static void writeTextState(HashMap<String, String> map, FriendlyByteBuf buffer) {
        buffer.writeInt(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            buffer.m_130083_((Component)Component.m_237113_((String)entry.getKey()));
            buffer.m_130083_((Component)Component.m_237113_((String)entry.getValue()));
        }
    }

    public static HashMap<String, String> readTextState(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < size; ++i) {
            String key = buffer.m_130238_().getString();
            String value = buffer.m_130238_().getString();
            map.put(key, value);
        }
        return map;
    }
}

