/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.additionsmoneycounts.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.mcreator.additionsmoneycounts.MoneyCountsMod;
import net.mcreator.additionsmoneycounts.procedures.GetCredit1Procedure;
import net.mcreator.additionsmoneycounts.procedures.GetCredit2Procedure;
import net.mcreator.additionsmoneycounts.procedures.GetCredit3Procedure;
import net.mcreator.additionsmoneycounts.procedures.PayCredit1Procedure;
import net.mcreator.additionsmoneycounts.procedures.PayCredit2Procedure;
import net.mcreator.additionsmoneycounts.procedures.PayCredit3Procedure;
import net.mcreator.additionsmoneycounts.world.inventory.CreditGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CreditGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;
    private HashMap<String, String> textstate;

    public CreditGUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.textstate = CreditGUIButtonMessage.readTextState(buffer);
    }

    public CreditGUIButtonMessage(int buttonID, int x, int y, int z, HashMap<String, String> textstate) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
        this.textstate = textstate;
    }

    public static void buffer(CreditGUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        CreditGUIButtonMessage.writeTextState(message.textstate, buffer);
    }

    public static void handler(CreditGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            HashMap<String, String> textstate = message.textstate;
            CreditGUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z, textstate);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z, HashMap<String, String> textstate) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = CreditGUIMenu.guistate;
        for (Map.Entry<String, String> entry : textstate.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            guistate.put(key, value);
        }
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            GetCredit1Procedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            GetCredit2Procedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            GetCredit3Procedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            PayCredit1Procedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            PayCredit2Procedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            PayCredit3Procedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        MoneyCountsMod.addNetworkMessage(CreditGUIButtonMessage.class, CreditGUIButtonMessage::buffer, CreditGUIButtonMessage::new, CreditGUIButtonMessage::handler);
    }

    public static void writeTextState(HashMap<String, String> map, FriendlyByteBuf buffer) {
        buffer.writeInt(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            buffer.m_130083_((Component)Component.m_237113_((String)entry.getKey()));
            buffer.m_130083_((Component)Component.m_237113_((String)entry.getValue()));
        }
    }

    public static HashMap<String, String> readTextState(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < size; ++i) {
            String key = buffer.m_130238_().getString();
            String value = buffer.m_130238_().getString();
            map.put(key, value);
        }
        return map;
    }
}

