package in.northwestw.shortcircuit.client;

import in.northwestw.shortcircuit.ShortCircuitCommon;
import in.northwestw.shortcircuit.registries.Items;
import in.northwestw.shortcircuit.registries.menus.TruthAssignerMenu;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_7842;
import net.minecraft.class_7919;

public class TruthAssignerScreen extends class_465<TruthAssignerMenu> implements class_1712 {
    private static final class_2960 BASE_BACKGROUND = new class_2960(ShortCircuitCommon.MOD_ID, "textures/gui/container/truth_assigner.png");
    private static final class_2960 BURN_PROGRESS_SPRITE = new class_2960("textures/gui/container/furnace.png");
    private class_342 maxDelay;
    private class_4185 wait, start, bits;
    private class_7842 error, currentInput;

    public TruthAssignerScreen(TruthAssignerMenu menu, class_1661 inventory, class_2561 title) {
        super(menu, inventory, title);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int i = (this.field_22789 - this.field_2792) / 2;
        int j = (this.field_22790 - this.field_2779) / 2;
        this.maxDelay = new class_342(this.field_22793, i + 103, j + 14, 30, 16, class_2561.method_43471("container.short_circuit.truth_assigner.max_delay"));
        this.maxDelay.method_47400(class_7919.method_47407(class_2561.method_43471("container.short_circuit.truth_assigner.max_delay.desc")));
        this.maxDelay.method_1863(this::onMaxDelayChange);
        this.maxDelay.method_1852(Integer.toString(this.field_2797.getMaxDelay()));

        this.bits = class_4185.method_46430(this.bitsTranslatable(), this::onBitsPress).method_46433(i + 133, j + 14).method_46437(30, 16).method_46431();
        this.updateBits();
        this.wait = class_4185.method_46430(this.waitTranslatable(), this::onWaitPress).method_46433(i + 103, j + 35).method_46437(60, 16).method_46431();
        this.updateWait();
        this.start = class_4185.method_46430(class_2561.method_43471("container.short_circuit.truth_assigner.start"), this::onStartPress).method_46433(i + 103, j + 56).method_46437(60, 16).method_46436(class_7919.method_47407(class_2561.method_43471("container.short_circuit.truth_assigner.start.desc"))).method_46431();

        this.error = new class_7842(i, j - 24, this.field_2792, 16, class_2561.method_43473(), this.field_22793);
        this.currentInput = new class_7842(i + 37, j + 34, 24, 16, class_2561.method_43473(), this.field_22793);
        this.updateCurrentInput();

        this.updateFields();

        this.method_37063(this.maxDelay);
        this.method_37063(this.bits);
        this.method_37063(this.wait);
        this.method_37063(this.start);
        this.method_37063(this.error);
        this.method_37063(this.currentInput);

        this.field_2797.method_7596(this);
    }

    @Override
    public void method_25432() {
        super.method_25432();
        this.field_2797.method_7603(this);
    }

    @Override
    protected void method_2389(class_332 graphics, float partialTick, int mouseX, int mouseY) {
        graphics.method_25290(BASE_BACKGROUND, this.field_2776, this.field_2800, 0, 0, this.field_2792, this.field_2779, 256, 256);
        if (this.field_2797.isWorking()) {
            // if we are working, color the arrow
            graphics.method_25302(BURN_PROGRESS_SPRITE, this.field_2776 + 37, this.field_2800 + 34, 176, 14, 25, 16);
        }
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(graphics);
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        this.method_2380(graphics, mouseX, mouseY);
    }

    private void onMaxDelayChange(String changed) {
        try {
            if (!changed.isEmpty()) {
                int delay = Integer.parseInt(changed);
                if (this.field_2797.setMaxDelay(delay)) {
                    // modified, super cheesey, see TruthAssignerMenu#clickMenuButton
                    this.field_22787.field_1761.method_2900(this.field_2797.field_7763, delay);
                }
            }
        } catch (NumberFormatException e) {
            this.maxDelay.method_1852(Integer.toString(this.field_2797.getMaxDelay()));
        }
    }

    private void onBitsPress(class_4185  button) {
        this.field_2797.setNextBits();
        this.updateBits();
        this.field_22787.field_1761.method_2900(this.field_2797.field_7763, -3);
    }

    private void onWaitPress(class_4185 button) {
        this.field_2797.setWait(!this.field_2797.shouldWait());
        this.updateWait();
        this.field_22787.field_1761.method_2900(this.field_2797.field_7763, -1);
    }

    private void onStartPress(class_4185 button) {
        this.field_2797.start();
        this.field_22787.field_1761.method_2900(this.field_2797.field_7763, -2);
        this.updateFields();
    }

    private class_2561 bitsTranslatable() {
        return class_2561.method_43469("container.short_circuit.truth_assigner.bits", this.field_2797.getBits());
    }

    private String waitTranslationKey() {
        return "container.short_circuit.truth_assigner.wait" + (this.field_2797.shouldWait() ? ".on" : "");
    }

    private class_2561 waitTranslatable() {
        return class_2561.method_43471(this.waitTranslationKey());
    }

    private void updateFields() {
        this.start.field_22763 = !this.field_2797.isWorking() && !this.field_2797.isEmpty() && this.field_2797.getError() == 0;
        this.bits.field_22763 = !this.field_2797.isWorking();
        this.wait.field_22763 = !this.field_2797.isWorking();
        this.maxDelay.method_1888(!this.field_2797.isWorking());
        this.updateError();
        this.updateCurrentInput();
    }

    @Override
    public void method_7635(class_1703 menu, int index, class_1799 stack) {
        if (index == 0) {
            if (stack.method_7960() || !stack.method_31574(Items.CIRCUIT.get())) this.start.field_22763 = false;
            else this.updateFields();
        }
    }

    @Override
    public void method_7633(class_1703 menu, int index, int value) {
        if (index == 0 || index == 3) { // the "working" index
            this.updateFields();
        } else if (index == 1) {
            this.updateWait();
        } else if (index == 2) {
            this.maxDelay.method_1852(Integer.toString(value));
        } else if (index == 4) {
            this.updateCurrentInput();
        } else if (index == 5) {
            this.updateBits();
        }
    }

    private void updateBits() {
        this.bits.method_25355(this.bitsTranslatable());
        this.bits.method_47400(class_7919.method_47407(class_2561.method_43469("container.short_circuit.truth_assigner.bits.desc", (int) Math.pow(2, this.field_2797.getBits()))));
    }

    private void updateWait() {
        this.wait.method_25355(this.waitTranslatable());
        this.wait.method_47400(class_7919.method_47407(class_2561.method_43471(this.waitTranslationKey() + ".desc")));
    }

    private void updateError() {
        int errorCode = this.field_2797.getError();
        if (errorCode == 0) this.error.method_25355(class_2561.method_43473());
        else this.error.method_25355(class_2561.method_43471("container.short_circuit.truth_assigner.error." + errorCode).method_27696(class_2583.field_24360.method_36139(0xff0000)));
    }

    private void updateCurrentInput() {
        if (!this.field_2797.isWorking()) this.currentInput.method_47400(null);
        else this.currentInput.method_47400(class_7919.method_47407(class_2561.method_43469("container.short_circuit.truth_assigner.current_input.desc", this.field_2797.getCurrentInput())));
    }
}
