package in.northwestw.shortcircuit.data;

import com.google.common.collect.Maps;
import in.northwestw.shortcircuit.Constants;
import in.northwestw.shortcircuit.config.Config;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import java.util.Map;
import java.util.UUID;

public class CircuitLimitSavedData extends class_18 {
    public final Map<UUID, Long> placements;

    public CircuitLimitSavedData() {
        this.placements = Maps.newHashMap();
    }

    public static CircuitLimitSavedData load(class_2487 tag) {
        CircuitLimitSavedData data = new CircuitLimitSavedData();
        for (class_2520 tt : tag.method_10554("placements", class_2499.field_33260)) {
            class_2487 pair = (class_2487) tt;
            data.placements.put(pair.method_25926("uuid"), pair.method_10537("amount"));
        }
        return data;
    }

    @Override
    public class_2487 method_75(class_2487 tag) {
        class_2499 list = new class_2499();
        this.placements.forEach((uuid, amount) -> {
            class_2487 pair = new class_2487();
            pair.method_25927("uuid", uuid);
            pair.method_10544("amount", amount);
            list.add(pair);
        });
        tag.method_10566("placements", list);
        return tag;
    }

    public boolean canAdd(UUID uuid) {
        return Config.MAX_CIRCUITS_PER_PLAYER <= 0 || this.placements.getOrDefault(uuid, 0L) < Config.MAX_CIRCUITS_PER_PLAYER;
    }

    public void add(UUID uuid) {
        this.placements.put(uuid, this.placements.getOrDefault(uuid, 0L) + 1);
    }

    public void remove(UUID uuid) {
        long amount = this.placements.getOrDefault(uuid, 1L) - 1;
        if (amount <= 0) this.placements.remove(uuid);
        else this.placements.put(uuid, amount);
    }

    public static CircuitLimitSavedData getRuntimeData(class_3218 level) {
        return CircuitLimitSavedData.getRuntimeData(level.method_8503());
    }

    public static CircuitLimitSavedData getRuntimeData(MinecraftServer server) {
        class_3218 runtimeLevel = server.method_3847(Constants.RUNTIME_DIMENSION);
        class_26 storage = runtimeLevel.method_17983();
        return storage.method_17924(CircuitLimitSavedData::load, CircuitLimitSavedData::new, "circuit_limit");
    }
}
