package in.northwestw.shortcircuit.data;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import in.northwestw.shortcircuit.Constants;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_18;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_3218;

public class CircuitSavedData extends class_18 {
    private static final double LOG2 = Math.log(2);

    public final Map<Integer, Octolet> octolets;
    public final Set<Integer>[] octoletsBySize; // value order: 4, 8, 16, 32, 64, 128, 256
    public final Map<UUID, Integer> circuits;

    public CircuitSavedData() {
        this.octolets = Maps.newHashMap();
        this.octoletsBySize = new Set[7];
        for (int ii = 0; ii < 7; ii++) {
            this.octoletsBySize[ii] = Sets.newHashSet();
        }
        this.circuits = Maps.newHashMap();
    }

    public int octoletIndexForSize(short blockSize) {
        int sizeIndex = (int) (Math.log(blockSize) / LOG2) - 2;
        for (int octoIndex : this.octoletsBySize[sizeIndex]) {
            Octolet octo = this.octolets.get(octoIndex);
            if (!octo.isFull()) return octoIndex;
        }
        for (int ii = 0; ii < this.octolets.size(); ii++) {
            if (!this.octolets.containsKey(ii)) return ii;
        }
        return this.octolets.size();
    }

    public Octolet getParentOctolet(UUID uuid) {
        if (!this.circuits.containsKey(uuid)) return null;
        return this.octolets.get(this.circuits.get(uuid));
    }

    public class_2338 getCircuitStartingPos(UUID uuid) {
        if (!this.circuits.containsKey(uuid)) return null;
        int outerIndex = this.circuits.get(uuid);
        Octolet octolet = this.octolets.get(outerIndex);
        //ShortCircuit.LOGGER.debug("Octolet {} starts at {}", outerIndex, Octolet.getOctoletPos(outerIndex));
        return octolet.getStartingPos(outerIndex, uuid);
    }

    public void addOctolet(int index, Octolet octolet) {
        this.octolets.put(index, octolet);
        int sizeIndex = (int) (Math.log(octolet.blockSize) / LOG2) - 2;
        this.octoletsBySize[sizeIndex].add(index);
        this.method_80();
    }

    public void addCircuit(UUID uuid, int octoletIndex) {
        Octolet octolet = this.octolets.get(octoletIndex);
        octolet.insertNewBlock(uuid);
        this.circuits.put(uuid, octoletIndex);
        this.method_80();
    }

    public void removeCircuit(UUID uuid) {
        if (!this.circuits.containsKey(uuid)) return;
        int outerIndex = this.circuits.get(uuid);
        Octolet octolet = this.octolets.get(outerIndex);
        octolet.removeBlock(uuid);
        this.circuits.remove(uuid);
    }

    public static CircuitSavedData load(class_2487 tag) {
        CircuitSavedData data = new CircuitSavedData();
        for (class_2520 t : tag.method_10554("octolets", class_2520.field_33260)) {
            class_2487 tt = (class_2487) t;
            data.addOctolet(tt.method_10550("key"), Octolet.fromTag(tt.method_10562("value")));
        }
        for (class_2520 t : tag.method_10554("circuits", class_2520.field_33260)) {
            class_2487 tt = (class_2487) t;
            data.circuits.put(tt.method_25926("key"), tt.method_10550("value"));
        }
        return data;
    }

    @Override
    public class_2487 method_75(class_2487 tag) {
        class_2499 list = new class_2499();
        this.octolets.forEach((integer, octolet) -> {
            class_2487 pair = new class_2487();
            pair.method_10569("key", integer);
            class_2487 octoTag = new class_2487();
            pair.method_10566("value", octolet.save(octoTag));
            list.add(pair);
        });
        tag.method_10566("octolets", list);
        class_2499 circuitList = new class_2499();
        this.circuits.forEach((uuid, index) -> {
            class_2487 pair = new class_2487();
            pair.method_25927("key", uuid);
            pair.method_10569("value", index);
            circuitList.add(pair);
        });
        tag.method_10566("circuits", circuitList);
        return tag;
    }

    public static CircuitSavedData getCircuitBoardData(class_3218 level) {
        class_3218 circuitBoardLevel = level.method_8503().method_3847(Constants.CIRCUIT_BOARD_DIMENSION);
        class_26 storage = circuitBoardLevel.method_17983();
        return storage.method_17924(CircuitSavedData::load, CircuitSavedData::new, "circuit_pos");
    }

    public static CircuitSavedData getRuntimeData(class_3218 level) {
        class_3218 runtimeLevel = level.method_8503().method_3847(Constants.RUNTIME_DIMENSION);
        class_26 storage = runtimeLevel.method_17983();
        return storage.method_17924(CircuitSavedData::load, CircuitSavedData::new, "circuit_pos");
    }
}
