package in.northwestw.shortcircuit.data;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

// It's call Octolet because it is 2^8 for side
public class Octolet {
    public static final short MAX_SIZE = 256;

    public short blockSize;
    public Set<Integer> occupied;
    public Map<UUID, Integer> blocks;

    public Octolet() {
        this(MAX_SIZE);
    }

    public Octolet(short blockSize) {
        this.blockSize = blockSize;
        this.occupied = Sets.newHashSet();
        this.blocks = Maps.newHashMap();
    }

    public boolean isFull() {
        return occupied.size() == Math.pow(MAX_SIZE / this.blockSize, 3);
    }

    public static Octolet fromTag(class_2487 tag) {
        Octolet octo = new Octolet();
        octo.load(tag);
        return octo;
    }

    public Octolet load(class_2487 tag) {
        this.blockSize = tag.method_10568("value");
        for (class_2520 t : tag.method_10554("occupied", class_2520.field_33253))
            occupied.add(((class_2497) t).method_10701());
        for (class_2520 t : tag.method_10554("blocks", class_2520.field_33260)) {
            class_2487 pair = (class_2487) t;
            this.blocks.put(pair.method_25926("uuid"), pair.method_10550("id"));
        }
        return this;
    }

    public class_2487 save(class_2487 tag) {
        tag.method_10575("value", this.blockSize);
        class_2499 list = new class_2499();
        occupied.forEach(s -> list.add(class_2497.method_23247(s)));
        tag.method_10566("occupied", list);
        class_2499 blockList = new class_2499();
        this.blocks.forEach((uuid, id) -> {
            class_2487 pair = new class_2487();
            pair.method_25927("uuid", uuid);
            pair.method_10569("id", id);
            blockList.add(pair);
        });
        tag.method_10566("blocks", blockList);
        return tag;
    }

    public static class_2338 getOctoletPos(int outerIndex) {
        int quadrant = outerIndex % 4;
        outerIndex /= 4;
        int side = (int) Math.sqrt(outerIndex);
        int index = outerIndex - side * side;
        int ringSize = (side + 1) * (side + 1) - side * side; // must be odd
        int x, z;
        if (index < ringSize / 2) {
            x = index;
            z = side;
        } else if (index > ringSize / 2 + 1) {
            index -= ringSize / 2 + 1;
            x = side;
            z = index;
        } else {
            x = z = side;
        }

        return switch (quadrant) {
            case 0 -> new class_2338(x * MAX_SIZE, 0, z * MAX_SIZE);
            case 1 -> new class_2338(-(x + 1) * MAX_SIZE, 0, z * MAX_SIZE);
            case 2 -> new class_2338(-(x + 1) * MAX_SIZE, 0, -(z + 1) * MAX_SIZE);
            case 3 -> new class_2338(x * MAX_SIZE, 0, -(z + 1) * MAX_SIZE);
            default -> null;
        };
    }

    public class_2338 getStartingPos(int outerIndex, UUID uuid) {
        if (!this.blocks.containsKey(uuid)) return null;
        class_2338 octoletPos = Octolet.getOctoletPos(outerIndex);
        int index = this.blocks.get(uuid);
        int verticalBlocks = 256 / this.blockSize;
        if (this.blockSize > 16) {
            int chunkPerBlock = this.blockSize / 16;
            int chunkIndex = index / verticalBlocks;
            int sideLength = MAX_SIZE / 16;
            int chunkX = chunkIndex % sideLength;
            int chunkZ = (chunkIndex / sideLength) % sideLength;
            return octoletPos.method_10069(chunkX * chunkPerBlock * 16, (index % verticalBlocks) * this.blockSize, chunkZ * chunkPerBlock * 16);
        } else {
            int chunkBlocks = (16 / this.blockSize) * (16 / this.blockSize) * verticalBlocks;
            int blockPerChunk = 16 / this.blockSize;
            int chunkIndex = index / chunkBlocks;
            int sideLength = MAX_SIZE / 16;
            int chunkX = chunkIndex % sideLength;
            int chunkZ = (chunkIndex / sideLength) % sideLength;
            int innerIndex = index % chunkBlocks;
            int x = innerIndex % blockPerChunk;
            int z = (innerIndex / blockPerChunk) % blockPerChunk;
            int y = innerIndex / (blockPerChunk * blockPerChunk);
            return octoletPos.method_10069(chunkX * 16 + x * this.blockSize, y * this.blockSize, chunkZ * 16 + z * this.blockSize);
        }
    }

    public Set<class_1923> getLoadedChunks() {
        Set<class_1923> set = Sets.newHashSet();
        for (int index : this.occupied) set.addAll(this.getBlockChunk(index));
        return set;
    }

    public Set<class_1923> getBlockChunk(int index) {
        Set<class_1923> set = Sets.newHashSet();
        int sideLength = MAX_SIZE / 16;
        if (this.blockSize > 16) {
            int verticalBlocks = 256 / this.blockSize;
            int chunkPerBlock = this.blockSize / 16;
            index /= verticalBlocks;
            int x = index % sideLength;
            int z = (index / sideLength) % sideLength;
            for (int ii = 0; ii < this.blockSize / 16; ii++)
                for (int jj = 0; jj < this.blockSize / 16; jj++)
                    set.add(new class_1923(x * chunkPerBlock + ii, z * chunkPerBlock + jj));
        } else {
            int chunkBlocks = (16 / this.blockSize) * (16 / this.blockSize) * 256 / this.blockSize;
            index /= chunkBlocks;
            int x = index % sideLength;
            int z = (index / sideLength) % sideLength;
            set.add(new class_1923(x, z));
        }
        return set;
    }

    public void insertNewBlock(UUID uuid) {
        if (this.blocks.containsKey(uuid)) return;
        for (int ii = 0; ii < this.occupied.size(); ii++) {
            if (!this.occupied.contains(ii)) {
                this.blocks.put(uuid, ii);
                this.occupied.add(ii);
                return;
            }
        }
        int nextIndex = this.occupied.size();
        this.blocks.put(uuid, nextIndex);
        this.occupied.add(nextIndex);
    }

    public void removeBlock(UUID uuid) {
        if (!this.blocks.containsKey(uuid)) return;
        this.occupied.remove(this.blocks.get(uuid));
        this.blocks.remove(uuid);

    }
}
