package in.northwestw.shortcircuit.data;

import com.google.common.collect.Maps;
import in.northwestw.shortcircuit.Constants;
import in.northwestw.shortcircuit.properties.RelativeDirection;
import java.util.*;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_3218;

public class TruthTableSavedData extends class_18 {
    private final Map<UUID, TruthTable> truthTables;

    public TruthTableSavedData() {
        this.truthTables = Maps.newHashMap();
    }

    public static TruthTableSavedData load(class_2487 tag) {
        TruthTableSavedData data = new TruthTableSavedData();
        for (class_2520 tt : tag.method_10554("tables", class_2520.field_33260)) {
            class_2487 tuple = (class_2487) tt;
            UUID uuid = tuple.method_25926("uuid");
            data.truthTables.put(uuid, TruthTable.load(tuple));
        }
        return data;
    }

    @Override
    public class_2487 method_75(class_2487 tag) {
        class_2499 list = new class_2499();
        this.truthTables.forEach((uuid, table) -> {
            class_2487 tuple = new class_2487();
            tuple.method_25927("uuid", uuid);
            table.save(tuple);
            list.add(tuple);
        });
        tag.method_10566("tables", list);
        return tag;
    }

    public Map<RelativeDirection, Integer> getSignals(UUID uuid, Map<RelativeDirection, Integer> inputs) {
        Map<RelativeDirection, Integer> signals = Maps.newHashMap();
        if (!this.truthTables.containsKey(uuid)) return signals;
        TruthTable table = this.truthTables.get(uuid);
        int input = 0;
        for (RelativeDirection dir : table.inputs) {
            input <<= table.bits;
            // merge 4-bit into amount specified by table.bits
            // i haven't had time to look into the mathematical relationships yet
            int val = inputs.getOrDefault(dir, 0);
            if (table.bits == 4) input |= val;
            else if (table.bits == 2) input |= (((val >> 2) > 1 ? 1 : 0) << 1) | ((val & 0x3) > 1 ? 1 : 0);
            else input |= val > 0 ? 1 : 0;
        }
        int output = table.signals.getOrDefault(input, table.defaultValue);
        List<RelativeDirection> reversed = new ArrayList<>(table.outputs);
        Collections.reverse(reversed);
        for (RelativeDirection dir: reversed) {
            signals.put(dir, output & 0xF);
            output >>= 4;
        }
        return signals;
    }

    public UUID insertTruthTable(UUID uuid, List<RelativeDirection> inputs, List<RelativeDirection> outputs, Map<Integer, Integer> signals, int bits) {
        // optimization
        Map<Integer, Integer> reverseMapCount = Maps.newHashMap();
        for (int output: signals.values()) {
            int count = reverseMapCount.getOrDefault(output, 0);
            reverseMapCount.put(output, count + 1);
        }
        int defaultValue = reverseMapCount.entrySet().stream().max(Comparator.comparingInt(Map.Entry::getValue)).get().getKey();
        Map<Integer, Integer> optimizedMap = Maps.newHashMap();
        for (Map.Entry<Integer, Integer> entry : signals.entrySet())
            if (entry.getValue() != defaultValue)
                optimizedMap.put(entry.getKey(), entry.getValue());
        
        // find if the truth table repeats
        for (Map.Entry<UUID, TruthTable> entry : this.truthTables.entrySet()) {
            if (entry.getValue().isSame(inputs, outputs, optimizedMap, defaultValue, bits))
                return entry.getKey();
        }
        this.truthTables.put(uuid, new TruthTable(inputs, outputs, optimizedMap, defaultValue, bits));
        this.method_80();
        return uuid;
    }

    public static TruthTableSavedData getTruthTableData(class_3218 level) {
        class_3218 circuitBoardLevel = level.method_8503().method_3847(Constants.CIRCUIT_BOARD_DIMENSION);
        class_26 storage = circuitBoardLevel.method_17983();
        return storage.method_17924(TruthTableSavedData::load, TruthTableSavedData::new, "truth_table");
    }
}
