package in.northwestw.shortcircuit.platform;

import com.google.common.collect.Maps;
import in.northwestw.shortcircuit.ShortCircuitCommon;
import in.northwestw.shortcircuit.platform.services.IRegistryHelper;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.minecraft.class_1703;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3917;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7699;
import net.minecraft.class_7923;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public class FabricRegistryHelper implements IRegistryHelper {
    public static final Map<class_5321<class_1761>, List<class_1792>> CREATIVE_MODE_TAB_ITEMS = Maps.newHashMap();

    @Override
    public <T extends class_2586> Supplier<class_2591<T>> registerBlockEntityType(String name, BlockEntitySupplier<T> factory, Supplier<class_2248> ...blocks) {
        class_2960 id = ShortCircuitCommon.rl(name);
        class_2591<T> type = class_2591.method_11030(id.toString(), class_2591.class_2592.method_20528(factory::create, Arrays.stream(blocks).map(Supplier::get).toArray(class_2248[]::new)));
        return () -> type;
    }

    @Override
    public Supplier<class_2248> registerBlock(String name, Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 properties) {
        class_2960 id = ShortCircuitCommon.rl(name);
        class_2248 block = class_2378.method_10230(class_7923.field_41175, id, factory.apply(properties));
        return () -> block;
    }

    @Override
    public <T extends class_1792> Supplier<T> registerItem(String name, Function<class_1792.class_1793, T> function, class_1792.class_1793 properties) {
        class_2960 id = ShortCircuitCommon.rl(name);
        T item = class_2378.method_10230(class_7923.field_41178, id, function.apply(properties));
        return () -> item;
    }

    @Override
    public <T extends class_1703> Supplier<class_3917<T>> registerMenu(String name, MenuSupplier<T> constructor, class_7699 requiredFeatures) {
        class_2960 id = ShortCircuitCommon.rl(name);
        class_3917<T> type = class_2378.method_10230(class_7923.field_41187, id, new class_3917<>(constructor::create, requiredFeatures));
        return () -> type;
    }

    @Override
    public Supplier<class_3414> registerSound(String name) {
        class_2960 id = ShortCircuitCommon.rl(name);
        class_3414 sound = class_2378.method_10230(class_7923.field_41172, id, class_3414.method_47908(id));
        return () -> sound;
    }

    @Override
    public Supplier<class_1761> registerCreativeModeTab(String name, class_2561 title, Supplier<class_1799> icon, Supplier<? extends class_1792>... items) {
        class_5321<class_1761> groupKey = class_5321.method_29179(class_7923.field_44687.method_30517(), ShortCircuitCommon.rl(name));
        CREATIVE_MODE_TAB_ITEMS.put(groupKey, (List<class_1792>) Arrays.stream(items).map(Supplier::get).toList());
        class_1761 tab = FabricItemGroup.builder().method_47320(icon).method_47321(title).method_47324();
        class_2378.method_39197(class_7923.field_44687, groupKey, tab);
        return () -> tab;
    }
}
