package in.northwestw.shortcircuit.properties;

import net.minecraft.class_2350;

public class DirectionHelper {
    public static RelativeDirection directionToRelativeDirection(class_2350 facing, class_2350 direction) {
        if (direction == class_2350.field_11036) return RelativeDirection.UP;
        if (direction == class_2350.field_11033) return RelativeDirection.DOWN;
        // if they face the same way, it's front
        int offset = direction.method_10161() - facing.method_10161();
        if (offset < 0) offset += 4;
        return switch (offset) {
            case 0 -> RelativeDirection.FRONT;
            case 1 -> RelativeDirection.RIGHT;
            case 2 -> RelativeDirection.BACK;
            default ->  RelativeDirection.LEFT;
        };
    }

    public static class_2350 relativeDirectionToFacing(RelativeDirection direction, class_2350 facing) {
        return switch (direction) {
            case UP -> class_2350.field_11036;
            case DOWN -> class_2350.field_11033;
            case FRONT -> facing;
            case BACK -> facing.method_10153();
            case LEFT -> facing.method_10160();
            case RIGHT -> facing.method_10170();
        };
    }

    public static class_2350 circuitBoardFixedDirection(RelativeDirection direction) {
        return switch (direction) {
            case UP -> class_2350.field_11036;
            case DOWN -> class_2350.field_11033;
            case LEFT -> class_2350.field_11035;
            case RIGHT -> class_2350.field_11043;
            case FRONT -> class_2350.field_11039;
            case BACK -> class_2350.field_11034;
        };
    }
}
