package in.northwestw.shortcircuit.registries.blockentities;

import com.google.common.collect.Lists;
import in.northwestw.shortcircuit.properties.DirectionHelper;
import in.northwestw.shortcircuit.properties.RelativeDirection;
import in.northwestw.shortcircuit.registries.BlockEntities;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import java.util.UUID;

public class CircuitBoardBlockEntity extends class_2586 {
    private class_5321<class_1937> dimension;
    private class_2338 pos;
    private UUID runtimeUuid;

    public CircuitBoardBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntities.CIRCUIT_BOARD.get(), pos, state);
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        if (tag.method_10545("dim")) this.dimension = class_5321.method_29179(class_7924.field_41223, new class_2960(tag.method_10558("dim")));
        if (tag.method_10545("pos")) {
            int[] arr = tag.method_10561("pos");
            this.pos = new class_2338(arr[0], arr[1], arr[2]);
        }
        if (tag.method_10545("uuid")) this.runtimeUuid = tag.method_25926("uuid");
    }

    @Override
    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        if (this.dimension != null) tag.method_10582("dim", this.dimension.method_29177().toString());
        if (this.pos != null) tag.method_10572("pos", Lists.newArrayList(this.pos.method_10263(), this.pos.method_10264(), this.pos.method_10260()));
        if (this.runtimeUuid != null) tag.method_25927("uuid", this.runtimeUuid);
    }

    public void setConnection(class_5321<class_1937> dimension, class_2338 pos, UUID uuid) {
        this.dimension = dimension;
        this.pos = pos;
        this.runtimeUuid = uuid;
        this.method_5431();
    }

    public void updateCircuitBlock(int signal, RelativeDirection direction) {
        if (this.dimension == null || this.pos == null || this.runtimeUuid == null) return;
        MinecraftServer server = this.field_11863.method_8503();
        if (server == null) return;
        class_3218 level = server.method_3847(this.dimension);
        if (level == null) return;
        class_2586 be = level.method_8321(this.pos);
        if (!(be instanceof CircuitBlockEntity blockEntity) || !blockEntity.matchRuntimeUuid(this.runtimeUuid)) return;
        if (blockEntity.setPower(signal, direction)) {
            class_2680 circuitState = level.method_8320(this.pos);
            class_2350 circuitDirection = circuitState.method_11654(class_2383.field_11177);
            class_2338 updatePos = this.pos.method_10093(DirectionHelper.relativeDirectionToFacing(direction, circuitDirection));
            level.method_8492(updatePos, level.method_8320(updatePos).method_26204(), this.pos);
            level.method_8508(updatePos, circuitState.method_26204(), circuitDirection.method_10153());
        }
    }
}
