package in.northwestw.shortcircuit.registries.blockentities;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import in.northwestw.shortcircuit.data.TruthTableSavedData;
import in.northwestw.shortcircuit.properties.DirectionHelper;
import in.northwestw.shortcircuit.properties.RelativeDirection;
import in.northwestw.shortcircuit.registries.BlockEntities;
import in.northwestw.shortcircuit.registries.blockentities.common.CommonCircuitBlockEntity;
import in.northwestw.shortcircuit.registries.blocks.IntegratedCircuitBlock;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2288;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import net.minecraft.class_6677;

public class IntegratedCircuitBlockEntity extends CommonCircuitBlockEntity {
    private static final class_2248[] POSSIBLE_INNER_BLOCKS = new class_2248[] { class_2246.field_10525, class_2246.field_10395, class_2246.field_10263 };
    private final Map<RelativeDirection, Integer> inputs;
    private Map<RelativeDirection, Integer> outputs;
    private final boolean[] changed;
    // used for rendering
    public final List<class_2680> blocks;

    public IntegratedCircuitBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntities.INTEGRATED_CIRCUIT.get(), pos, state);
        this.inputs = Maps.newHashMap();
        this.outputs = Maps.newHashMap();
        this.changed = new boolean[6];
        this.hidden = true;
        this.blocks = Lists.newArrayList();
    }

    private void loadSignalMap(class_2487 tag, String key, Map<RelativeDirection, Integer> map) {
        if (tag.method_10573(key, class_2520.field_33259))
            for (class_2520 t : tag.method_10554(key, class_2520.field_33260)) {
                class_2487 pair = (class_2487) t;
                map.put(RelativeDirection.fromId(pair.method_10571("key")), (int) pair.method_10571("value"));
            }
    }

    private void saveSignalMap(class_2487 tag, String key, Map<RelativeDirection, Integer> map) {
        class_2499 list = new class_2499();
        for (Map.Entry<RelativeDirection, Integer> entry : map.entrySet()) {
            class_2487 pair = new class_2487();
            pair.method_10567("key", entry.getKey().getId());
            pair.method_10567("value", entry.getValue().byteValue());
            list.add(pair);
        }
        tag.method_10566(key, list);
    }

    @Override
    public void method_11014(class_2487 tag) {
        UUID oldUuid = this.uuid;
        super.method_11014(tag);
        this.loadSignalMap(tag, "inputs", this.inputs);
        this.loadSignalMap(tag, "outputs", this.outputs);
        // upgrade to v1.0.2, default hidden to true
        if (!tag.method_10545("hidden")) this.hidden = true;

        this.blocks.clear();
        if (oldUuid != this.uuid && this.uuid != null) {
            class_5819 random = new class_6677(this.uuid.getLeastSignificantBits(), this.uuid.getMostSignificantBits());
            class_2350[] directions = class_2350.values();
            for (int ii = 0; ii < 8; ii++)
                this.blocks.add(POSSIBLE_INNER_BLOCKS[random.method_43048(POSSIBLE_INNER_BLOCKS.length)].method_9564().method_11657(class_2288.field_10791, directions[random.method_43048(directions.length)]));
        }
    }

    @Override
    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        this.saveSignalMap(tag, "inputs", this.inputs);
        this.saveSignalMap(tag, "outputs", this.outputs);
    }

    public int getPower(class_2350 direction) {
        switch (direction) {
            // this is so stupid. why is the direction of signals flipped!?
            case field_11036: return this.outputs.getOrDefault(RelativeDirection.DOWN, 0);
            case field_11033: return this.outputs.getOrDefault(RelativeDirection.UP, 0);
        }
        int data2d = this.method_11010().method_11654(class_2383.field_11177).method_10161();
        int offset = direction.method_10161() - data2d;
        if (offset < 0) offset += 4;
        return switch (offset) {
            case 0 -> this.outputs.getOrDefault(RelativeDirection.BACK, 0);
            case 1 -> this.outputs.getOrDefault(RelativeDirection.LEFT, 0);
            case 2 -> this.outputs.getOrDefault(RelativeDirection.FRONT, 0);
            case 3 -> this.outputs.getOrDefault(RelativeDirection.RIGHT, 0);
            default -> 0;
        };
    }

    private void updateChangedNeighbors() {
        class_2680 state = this.method_11010();
        class_2350 direction = state.method_11654(class_2383.field_11177);
        for (int ii = 0; ii < this.changed.length; ii++)
            if (this.changed[ii]) {
                class_2338 pos = this.method_11016().method_10093(DirectionHelper.relativeDirectionToFacing(RelativeDirection.fromId((byte) ii), direction));
                this.field_11863.method_8492(pos, this.field_11863.method_8320(pos).method_26204(), this.method_11016());
                this.field_11863.method_8508(pos, state.method_26204(), direction.method_10153());
            }
    }

    private void updateOutput() {
        if (this.field_11863 instanceof class_3218 level) {
            TruthTableSavedData data = TruthTableSavedData.getTruthTableData(level);
            Map<RelativeDirection, Integer> oldOutputs = ImmutableMap.copyOf(this.outputs);
            this.outputs = data.getSignals(this.uuid, this.inputs);
            this.clearChanged();
            for (RelativeDirection key : oldOutputs.keySet()) {
                if (!this.outputs.containsKey(key) || !this.outputs.get(key).equals(oldOutputs.get(key))) // removed value or changed value
                    this.changed[key.getId()] = true;
            }
            for (RelativeDirection key : this.outputs.keySet()) {
                if (!oldOutputs.containsKey(key)) // new value
                    this.changed[key.getId()] = true;
            }
            this.field_11863.method_8652(this.method_11016(), this.method_11010().method_11657(IntegratedCircuitBlock.POWERED, this.outputs.values().stream().anyMatch(power -> power > 0)), class_2248.field_31028);
            this.updateChangedNeighbors();
        }
    }

    private void clearChanged() {
        Arrays.fill(this.changed, false);
    }

    @Override
    public void updateInputs() {
        // stop infinite updates when a side has ticked over n times
        if (this.maxUpdateReached()) return;
        class_2338 pos = this.method_11016();
        class_2680 state = this.method_11010();
        for (class_2350 direction : class_2350.values()) {
            RelativeDirection relDir = DirectionHelper.directionToRelativeDirection(state.method_11654(class_2383.field_11177), direction);
            int signal = field_11863.method_49808(pos.method_10093(direction), direction);
            if (this.inputs.getOrDefault(relDir, 0) != signal)
                this.sideUpdated(relDir);
            this.inputs.put(relDir, signal);
        }
        this.updateOutput();
    }
}
