package in.northwestw.shortcircuit.registries.blockentities;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import in.northwestw.shortcircuit.data.TruthTableSavedData;
import in.northwestw.shortcircuit.properties.RelativeDirection;
import in.northwestw.shortcircuit.registries.BlockEntities;
import in.northwestw.shortcircuit.registries.Blocks;
import in.northwestw.shortcircuit.registries.Items;
import in.northwestw.shortcircuit.registries.blocks.CircuitBoardBlock;
import in.northwestw.shortcircuit.registries.blocks.TruthAssignerBlock;
import in.northwestw.shortcircuit.registries.menus.TruthAssignerMenu;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3913;
import net.minecraft.class_3914;

public class TruthAssignerBlockEntity extends class_2624 implements class_1712 {
    public static final int SIZE = 2;
    private class_2371<class_1799> items = class_2371.method_10213(SIZE, class_1799.field_8037);
    private boolean working, wait;
    private int maxDelay, ticks, errorCode, bits;
    private final class_3913 containerData;
    // For assigning
    private final List<RelativeDirection> inputOrder, outputOrder;
    private int currentInput, lastOutput;
    private final Map<Integer, Integer> outputMap;
    private UUID workingUuid;

    public TruthAssignerBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntities.TRUTH_ASSIGNER.get(), pos, state);
        this.wait = true;
        this.maxDelay = 20;
        this.bits = 4;
        this.inputOrder = Lists.newArrayList();
        this.outputOrder = Lists.newArrayList();
        this.outputMap = Maps.newHashMap();
        this.containerData = new class_3913() {
            @Override
            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> TruthAssignerBlockEntity.this.working ? 1 : 0;
                    case 1 -> TruthAssignerBlockEntity.this.wait ? 1 : 0;
                    case 2 -> TruthAssignerBlockEntity.this.maxDelay;
                    case 3 -> TruthAssignerBlockEntity.this.errorCode;
                    case 4 -> TruthAssignerBlockEntity.this.currentInput;
                    case 5 -> TruthAssignerBlockEntity.this.bits;
                    default -> 0;
                };
            }

            @Override
            public void method_17391(int index, int value) {
                switch (index) {
                    case 0:
                        boolean oldWorking = TruthAssignerBlockEntity.this.working;
                        TruthAssignerBlockEntity.this.working = value != 0;
                        if (TruthAssignerBlockEntity.this.working && !oldWorking)
                            start();
                        break;
                    case 1:
                        TruthAssignerBlockEntity.this.wait = value != 0;
                        break;
                    case 2:
                        TruthAssignerBlockEntity.this.maxDelay = value;
                        break;
                    case 3:
                        TruthAssignerBlockEntity.this.errorCode = value;
                        break;
                    case 5:
                        if (value == 1 || value == 2 || value == 4)
                            TruthAssignerBlockEntity.this.bits = value;
                        break;
                }
                TruthAssignerBlockEntity.this.method_5431();
            }

            @Override
            public int method_17389() {
                return 6;
            }
        };
    }

    @Override
    public int method_5439() {
        return SIZE;
    }

    @Override
    public boolean method_5442() {
        for(class_1799 stack : this.items) {
            if (!stack.method_7960()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public class_1799 method_5438(int i) {
        return this.items.get(i);
    }

    @Override
    public class_1799 method_5434(int i, int i1) {
        return class_1262.method_5430(this.items, i, i1);
    }

    @Override
    public class_1799 method_5441(int i) {
        return class_1262.method_5428(this.items, i);
    }

    @Override
    public void method_5447(int i, class_1799 itemStack) {
        class_1799 stack = this.items.get(i);
        boolean $$3 = !itemStack.method_7960() && class_1799.method_31577(stack, itemStack);
        this.items.set(i, itemStack);
        if (itemStack.method_7947() > this.method_5444()) {
            itemStack.method_7939(this.method_5444());
        }
    }

    @Override
    public boolean method_5443(class_1657 player) {
        return class_1263.method_49105(this, player);
    }

    @Override
    protected class_2561 method_17823() {
        return class_2561.method_43471("container.short_circuit.truth_assigner");
    }

    @Override
    protected class_1703 method_5465(int containerId, class_1661 inventory) {
        return new TruthAssignerMenu(containerId, inventory, this.field_11863 == null ? class_3914.field_17304 : class_3914.method_17392(this.field_11863, this.method_11016()), this, this.containerData);
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        class_1262.method_5429(tag, this.items);
        this.working = tag.method_10577("working");
        this.wait = tag.method_10577("wait");
        this.maxDelay = tag.method_10550("maxDelay");
        this.bits = tag.method_10550("bits");
        if (this.bits == 0) this.bits = 4;
        this.ticks = tag.method_10550("ticks");
        this.errorCode = tag.method_10550("errorCode");
        if (tag.method_25928("workingUuid")) this.workingUuid = tag.method_25926("workingUuid");
        this.lastOutput = tag.method_10550("lastOutput");
    }

    @Override
    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        class_1262.method_5426(tag, this.items);
        tag.method_10556("working", this.working);
        tag.method_10556("wait", this.wait);
        tag.method_10569("maxDelay", this.maxDelay);
        tag.method_10569("bits", this.bits);
        tag.method_10569("ticks", this.ticks);
        tag.method_10569("errorCode", this.errorCode);
        if (this.workingUuid != null) tag.method_25927("workingUuid", this.workingUuid);
        tag.method_10569("lastOutput", lastOutput);
    }

    @Override
    public class_2487 method_16887() {
        class_2487 tag = new class_2487();
        this.method_11007(tag);
        return tag;
    }

    @Override
    public @Nullable class_2596<class_2602> method_38235() {
        return class_2622.method_38585(this);
    }

    public boolean isWorking() {
        return working;
    }

    private void start() {
        this.field_11863.method_8501(method_11016(), method_11010().method_11657(TruthAssignerBlock.LIT, this.working));
        this.field_11863.method_8501(this.method_11016().method_10084(), Blocks.CIRCUIT.get().method_9564());
        CircuitBlockEntity blockEntity = (CircuitBlockEntity) this.field_11863.method_8321(this.method_11016().method_10084());
        blockEntity.setFake(true);
        class_1799 input = this.method_5438(0);
        class_2487 tag = input.method_7948();
        if (tag.method_10545("uuid"))
            blockEntity.setUuid(tag.method_25926("uuid"));
        Pair<CircuitBlockEntity.RuntimeReloadResult, Map<RelativeDirection, CircuitBoardBlock.Mode>> pair = blockEntity.reloadRuntimeAndModeMap(Sets.newHashSet());
        CircuitBlockEntity.RuntimeReloadResult result = pair.getLeft();
        if (!result.isGood()) {
            this.setErrorCode(2, false);
            this.stop(false);
        }
        Map<RelativeDirection, CircuitBoardBlock.Mode> modeMap = pair.getRight();
        // compute them in sorted order
        for (Map.Entry<RelativeDirection, CircuitBoardBlock.Mode> entry : modeMap.entrySet().stream().sorted(Comparator.comparingInt(a -> a.getKey().getId())).toList()) {
            CircuitBoardBlock.Mode mode = entry.getValue();
            if (mode == CircuitBoardBlock.Mode.INPUT) this.inputOrder.add(entry.getKey());
            else if (mode == CircuitBoardBlock.Mode.OUTPUT) this.outputOrder.add(entry.getKey());
        }
        this.workingUuid = blockEntity.getRuntimeUuid();
        this.method_5431();
    }

    private void stop(boolean success) {
        if (!(this.field_11863 instanceof class_3218 serverLevel)) return;
        if (success) {
            // copy input output mapping to data
            TruthTableSavedData data = TruthTableSavedData.getTruthTableData(serverLevel);
            UUID uuid = UUID.randomUUID();
            uuid = data.insertTruthTable(uuid, this.inputOrder, this.outputOrder, this.outputMap, this.bits);

            // create integrated circuits by amount of circuits
            class_1799 input = this.method_5438(0);
            class_1799 outputs = new class_1799(Items.INTEGRATED_CIRCUIT.get(), input.method_7947());
            class_2487 tag = outputs.method_7948();
            tag.method_25927("uuid", uuid);
            outputs.method_7980(tag);
            this.method_5447(0, class_1799.field_8037);
            this.method_5447(1, outputs);
        }

        // clear working memory
        this.currentInput = 0;
        this.inputOrder.clear();
        this.outputOrder.clear();
        this.outputMap.clear();

        // set working to false
        this.containerData.method_17391(0, 0);
        this.field_11863.method_8501(method_11016(), method_11010().method_11657(TruthAssignerBlock.LIT, this.working));

        // remove the circuit
        if (this.field_11863.method_8321(this.method_11016().method_10084()) instanceof CircuitBlockEntity blockEntity) blockEntity.removeRuntime();
        this.field_11863.method_8501(this.method_11016().method_10084(), net.minecraft.class_2246.field_10124.method_9564());

        // ding!
        this.field_11863.method_8396(null, this.method_11016(), in.northwestw.shortcircuit.registries.SoundEvents.TRUTH_ASSIGNED.get(), class_3419.field_15245, 1, this.field_11863.field_9229.method_43057() * 0.2f + 0.95f);
    }

    public void tick() {
        if (!this.working) return;
        if (this.field_11863 != null && this.field_11863.field_9229.method_43058() < 0.1)
            this.field_11863.method_45446(this.method_11016(), class_3417.field_14962, class_3419.field_15245, 0.2f, this.field_11863.field_9229.method_43057() * 0.4f + 0.8f, false);
        if (!(this.field_11863.method_8321(this.method_11016().method_10084()) instanceof CircuitBlockEntity blockEntity)) {
            this.stop(false);
            return;
        }
        // on tick 0, setup input signals
        if (this.ticks == 0) {
            // input encoding is larger than all possible situation
            if (this.currentInput >= Math.pow(2, this.inputOrder.size() * this.bits)) {
                this.stop(true);
                return;
            }
            // update runtime block signals according to encoding
            for (int ii = 0; ii < this.inputOrder.size(); ii++) {
                int power = (this.expandInput(this.currentInput) >> (ii * 4)) & 0xF;
                blockEntity.updateRuntimeBlock(power, this.inputOrder.get(ii));
            }
        }
        if (++this.ticks >= this.maxDelay) this.recordOutput(true);
        this.method_5431();
    }

    private void recordOutput(boolean forced) {
        if (!this.working || (!forced && this.wait) || !(this.field_11863.method_8321(this.method_11016().method_10084()) instanceof CircuitBlockEntity blockEntity)) return;
        int signals = 0;
        for (RelativeDirection dir : this.outputOrder) {
            signals <<= 4;
            signals |= blockEntity.getRelativePower(dir);
        }
        if (signals != this.lastOutput || forced) {
            this.lastOutput = signals;
            this.ticks = 0;
            this.outputMap.put(this.currentInput, signals);
            this.currentInput++;
            this.method_5431();
        }
    }

    private int expandInput(int input) {
        if (this.bits == 4) return input;
        int result = 0;
        for (int ii = 0; ii < this.bits * this.inputOrder.size(); ii++) {
            for (int jj = 0; jj < 4 / this.bits; jj++) {
                result <<= 1;
                if (((input >> ii) & 0x1) == 1) result |= 1;
            }
        }
        return result;
    }

    public void checkAndRecord() {
        if (!(this.field_11863.method_8321(this.method_11016().method_10084()) instanceof CircuitBlockEntity)) {
            this.stop(false);
            this.setErrorCode(3, false);
            return;
        }
        this.recordOutput(false);
    }

    public void setErrorCode(int errorCode, boolean unset) {
        if (!unset) this.containerData.method_17391(3, errorCode);
        else if (this.errorCode == errorCode) this.containerData.method_17391(3, 0);
        this.method_5431();
    }

    @Override
    public void method_7635(class_1703 menu, int index, class_1799 stack) {
        if ((this.errorCode == 2 || this.errorCode == 3) && index == 0 && stack.method_7960())
            this.setErrorCode(this.errorCode, true);
    }

    @Override
    public void method_7633(class_1703 pContainerMenu, int pDataSlotIndex, int pValue) {}

    @Override
    public void method_5448() {

    }
}
