package in.northwestw.shortcircuit.registries.blockentities.common;

import in.northwestw.shortcircuit.config.Config;
import in.northwestw.shortcircuit.properties.RelativeDirection;
import in.northwestw.shortcircuit.registries.blockentities.CircuitBlockEntity;
import in.northwestw.shortcircuit.registries.blocks.CircuitBlock;
import in.northwestw.shortcircuit.registries.blocks.IntegratedCircuitBlock;
import org.jetbrains.annotations.Nullable;

import java.util.Arrays;
import java.util.UUID;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2746;

public class CommonCircuitBlockEntity extends class_2586 {
    protected UUID uuid;
    protected boolean hidden;
    protected class_2561 name;
    protected class_1767 color;
    private final int[] sameTickUpdates;

    public CommonCircuitBlockEntity(class_2591<?> type, class_2338 pos, class_2680 blockState) {
        super(type, pos, blockState);
        this.sameTickUpdates = new int[6];
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        if (tag.method_25928("uuid")) this.uuid = tag.method_25926("uuid");
        else this.uuid = null;
        this.hidden = tag.method_10577("hidden");
        if (tag.method_10573("customName", class_2520.field_33258)) this.name = class_2561.class_2562.method_10877(tag.method_10558("customName"));
        if (tag.method_10573("color", class_2520.field_33251)) this.color = class_1767.method_7791(tag.method_10571("color"));
    }

    @Override
    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        if (this.uuid != null) tag.method_25927("uuid", this.uuid);
        tag.method_10556("hidden", this.hidden);
        if (this.name != null) tag.method_10582("customName", class_2561.class_2562.method_10867(this.name));
        if (this.color != null) tag.method_10567("color", (byte) this.color.method_7789());
    }

    @Override
    public class_2487 method_16887() {
        class_2487 tag = new class_2487();
        this.method_11007(tag);
        return tag;
    }

    @Override
    public @Nullable class_2596<class_2602> method_38235() {
        return class_2622.method_38585(this);
    }

    @Override
    public void method_38240(class_1799 stack) {
        super.method_38240(stack);
        class_2487 tag = stack.method_7948();
        tag.method_25927("uuid", this.uuid);
        if (this.color != null) tag.method_10575("color", (short) this.color.method_7789());
        stack.method_7980(tag);
        if (this.name != null) stack.method_7977(this.name);
    }

    public boolean isValid() {
        return this.uuid != null;
    }

    public UUID getUuid() {
        return uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
        this.method_5431();
    }

    public boolean isHidden() {
        return hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
        this.method_5431();
        if (!this.hidden && !this.field_11863.field_9236) this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), class_2248.field_31028);
    }

    public void setName(class_2561 name) {
        this.name = name;
        this.method_5431();
    }

    private class_2746 colorBooleanProperty() {
        return this instanceof CircuitBlockEntity ? CircuitBlock.COLORED : IntegratedCircuitBlock.COLORED;
    }

    public void cycleColor(boolean backwards) {
        class_2746 property = this.colorBooleanProperty();
        if (this.color == null) {
            this.color = class_1767.method_7791(backwards ? 15 : 0);
            this.field_11863.method_8652(this.method_11016(), this.method_11010().method_11657(property, true), class_2248.field_31028);
        }
        else if (this.color.method_7789() < 15 && !backwards) this.color = class_1767.method_7791(this.color.method_7789() + 1);
        else if (this.color.method_7789() > 0 && backwards) this.color = class_1767.method_7791(this.color.method_7789() - 1);
        else {
            this.color = null;
            this.field_11863.method_8652(this.method_11016(), this.method_11010().method_11657(property, false), class_2248.field_31028);
        }
        this.method_5431();
    }

    public void setColor(class_1767 color) {
        this.color = color;
        this.field_11863.method_8652(this.method_11016(), this.method_11010().method_11657(this.colorBooleanProperty(), this.color != null), class_2248.field_31028);
        this.method_5431();
    }

    public class_1767 getColor() {
        return color;
    }

    public void tick() {
        boolean reTick = this.maxUpdateReached();
        Arrays.fill(this.sameTickUpdates, 0);
        if (reTick) {
            // couldn't finish update last tick due to limit, so we try again
            this.updateInputs();
        }
    }

    public void updateInputs() {

    }

    protected boolean maxUpdateReached() {
        return Config.SAME_SIDE_TICK_LIMIT > 0 && Arrays.stream(this.sameTickUpdates).anyMatch(t -> t >= Config.SAME_SIDE_TICK_LIMIT);
    }

    protected void sideUpdated(RelativeDirection direction) {
        this.sameTickUpdates[direction.getId()]++;
    }
}
