package in.northwestw.shortcircuit.registries.blockentityrenderers;

import in.northwestw.shortcircuit.properties.ColorHelper;
import in.northwestw.shortcircuit.registries.blockentities.IntegratedCircuitBlockEntity;
import net.minecraft.class_1767;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2383;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_776;
import net.minecraft.class_827;
import org.joml.Quaternionf;

public class IntegratedCircuitBlockEntityRenderer implements class_827<IntegratedCircuitBlockEntity> {
    private static final float HIDDEN_SCALE = 0.875f; // 14/16
    private static final float HIDDEN_TRANSLATE = 0.0625f; // 1/16
    private static final float HIDDEN_SCALE_CARPET = 0.9375f; // 30/32
    private static final float HIDDEN_TRANSLATE_CARPET = 0.03125f; // 1/16
    private final class_776 blockRenderDispatcher;

    public IntegratedCircuitBlockEntityRenderer(class_5614.class_5615 context) {
        this.blockRenderDispatcher = context.method_32141();
    }

    @Override
    public void render(IntegratedCircuitBlockEntity blockEntity, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay) {
        poseStack.method_22903();
        class_1767 color = blockEntity.getColor();
        if (color != null) {
            this.blockRenderDispatcher.method_3353(ColorHelper.colorToStainedGlass(color).method_9564(), poseStack, bufferSource, packedLight, packedOverlay);
        }
        // direction handling. move to the center and rotate, then move back
        poseStack.method_22904(0.5, 0.5, 0.5);
        switch (blockEntity.method_11010().method_11654(class_2383.field_11177)) {
            case field_11035 -> poseStack.method_22907(new Quaternionf(0, 0.7071068, 0, 0.7071068));
            case field_11034 -> poseStack.method_22907(new Quaternionf(0, 1, 0, 0));
            case field_11043 -> poseStack.method_22907(new Quaternionf(0, 0.7071068, 0, -0.7071068));
        }
        poseStack.method_22904(-0.5, -0.5, -0.5);

        poseStack.method_22905(HIDDEN_SCALE_CARPET, HIDDEN_SCALE_CARPET, HIDDEN_SCALE_CARPET);
        poseStack.method_46416(HIDDEN_TRANSLATE_CARPET, HIDDEN_TRANSLATE_CARPET, HIDDEN_TRANSLATE_CARPET);
        this.blockRenderDispatcher.method_3353(class_2246.field_10512.method_9564(), poseStack, bufferSource, packedLight, packedOverlay);
        poseStack.method_22904(0, 0.0625, 0);

        if (blockEntity.isHidden()) {
            this.blockRenderDispatcher.method_3353(
                    in.northwestw.shortcircuit.registries.Blocks.INNER_IC.get().method_9564().method_11657(class_2741.field_12484, blockEntity.method_11010().method_11654(class_2741.field_12484)),
                    poseStack, bufferSource, packedLight, packedOverlay
            );
        } else {
            // intentional repeated scaling so blocks don't clip out
            poseStack.method_22905(HIDDEN_SCALE, HIDDEN_SCALE, HIDDEN_SCALE);
            poseStack.method_46416(HIDDEN_TRANSLATE, 0, HIDDEN_TRANSLATE);
            float scale = 1f / 2;
            poseStack.method_22905(scale, scale, scale);
            int count = 0;
            for (class_2680 state : blockEntity.blocks) {
                class_2338 vec = new class_2338(count % 2, (count / 2) % 2, (count / 4) % 2);
                poseStack.method_46416(vec.method_10263(), vec.method_10264(), vec.method_10260());
                this.blockRenderDispatcher.method_3353(state, poseStack, bufferSource, packedLight, packedOverlay);
                poseStack.method_46416(-vec.method_10263(), -vec.method_10264(), -vec.method_10260());
                count++;
            }
        }

        poseStack.method_22909();
    }
}
