package in.northwestw.shortcircuit.registries.blocks;

import in.northwestw.shortcircuit.Constants;
import in.northwestw.shortcircuit.ShortCircuitCommon;
import in.northwestw.shortcircuit.data.CircuitLimitSavedData;
import in.northwestw.shortcircuit.registries.*;
import in.northwestw.shortcircuit.registries.blockentities.CircuitBlockEntity;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_3417;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.UUID;

public class CircuitBlock extends class_2383 implements class_2343 {
    public static final class_2746 POWERED = class_2741.field_12484;
    public static final class_2746 COLORED = class_2746.method_11825("colored");

    public CircuitBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590(this.field_10647.method_11664()
                .method_11657(field_11177, class_2350.field_11043)
                .method_11657(POWERED, false)
                .method_11657(COLORED, false));
    }

    @Override
    public class_2680 method_9605(class_1750 pContext) {
        return this.method_9564().method_11657(field_11177, pContext.method_8042());
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        //builder.add(FACING, UP_POWER, DOWN_POWER, LEFT_POWER, RIGHT_POWER, FRONT_POWER, BACK_POWER);
        builder.method_11667(field_11177, POWERED, COLORED);
    }

    @Override
    public void method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        class_2586 blockentity = level.method_8321(pos);
        if (blockentity instanceof CircuitBlockEntity circuitBlockEntity) {
            if (!player.method_7337() && circuitBlockEntity.isValid()) {
                class_1799 stack = new class_1799(Blocks.CIRCUIT.get());
                circuitBlockEntity.method_38240(stack);
                class_1542 itementity = new class_1542(
                        level, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, stack
                );
                itementity.method_6988();
                level.method_8649(itementity);
            }
            circuitBlockEntity.removeRuntime();

            UUID owner = circuitBlockEntity.getOwnerUuid();
            MinecraftServer server = player.method_5682();
            if (owner != null && server != null)
                CircuitLimitSavedData.getRuntimeData(server).remove(owner);
        }

        super.method_9576(level, pos, state, player);
    }

    @Override
    public void method_9586(class_1937 level, class_2338 pos, class_1927 explosion) {
        if (level.method_8321(pos) instanceof CircuitBlockEntity blockEntity) {
            blockEntity.removeRuntime();

            UUID owner = blockEntity.getOwnerUuid();
            MinecraftServer server = level.method_8503();
            if (owner != null && server != null)
                CircuitLimitSavedData.getRuntimeData(server).remove(owner);
        }
        super.method_9586(level, pos, explosion);
    }

    @Override
    public void method_9568(class_1799 stack, @Nullable class_1922 level, List<class_2561> components, class_1836 flag) {
        super.method_9568(stack, level, components, flag);
        class_2487 tag = stack.method_7948();
        if (tag.method_25928("uuid")) {
            components.add(class_2561.method_43469("tooltip.short_circuit.circuit", tag.method_25926("uuid").toString()).method_27696(class_2583.field_24360.method_36139(0x7f7f7f)));
        }
        if (tag.method_10573("color", class_2487.field_33252)) {
            class_1767 color = class_1767.method_7791(tag.method_10568("color"));
            components.add(class_2561.method_43469("tooltip.short_circuit.circuit.color", class_2561.method_43471("color.minecraft." + color.method_7792())).method_27696(class_2583.field_24360.method_36139(color.method_16357())));
        }
    }

    @Override
    public @Nullable class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new CircuitBlockEntity(pos, state);
    }

    @SuppressWarnings("unchecked")
    @Override
    public @Nullable <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        return type == BlockEntities.CIRCUIT.get() ? (pLevel, pPos, pState, blockEntity) -> ((CircuitBlockEntity) blockEntity).tick() : null;
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_7960()) return this.useWithoutItem(level, pos, player);
        else return this.useItemOn(stack, level, pos, player, hand);
    }

    protected class_1269 useWithoutItem(class_1937 level, class_2338 pos, class_1657 player) {
        if (level.method_8321(pos) instanceof CircuitBlockEntity blockEntity) {
            if (blockEntity.isFake()) return class_1269.field_5811;
            else {
                player.method_7353(class_2561.method_43471("action.circuit.reload"), true);
                CircuitBlockEntity.RuntimeReloadResult result = blockEntity.reloadRuntime();
                if (result != CircuitBlockEntity.RuntimeReloadResult.FAIL_NO_SERVER)
                    player.method_7353(class_2561.method_43471(result.getTranslationKey()).method_27696(class_2583.field_24360.method_36139(result.isGood() ? 0x00ff00 : 0xff0000)), true);
            }
        }
        return class_1269.method_29236(level.field_9236);
    }

    protected class_1269 useItemOn(class_1799 stack, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand) {
        if (stack.method_31574(Items.POKING_STICK.get()) || stack.method_31574(Items.LABELLING_STICK.get())) return class_1269.field_5811; // handled by item
        else if ((stack.method_31574(Items.CIRCUIT.get()) || stack.method_31574(Items.INTEGRATED_CIRCUIT.get())) && !player.method_18276() && !player.method_5715() && level.method_8321(pos) instanceof CircuitBlockEntity blockEntity && blockEntity.isValid()) {
            class_1799 newStack = new class_1799(Items.CIRCUIT.get(), stack.method_7947());
            if (stack.method_7985()) newStack.method_7980(stack.method_7969());
            class_2487 tag = newStack.method_7948();
            tag.method_25927("uuid", blockEntity.getUuid());
            if (blockEntity.getColor() != null)
                tag.method_10575("color", (short) blockEntity.getColor().method_7789());
            player.method_6122(hand, newStack);
            player.method_5783(class_3417.field_14703, 0.5f, 1);
            return class_1269.field_5812;
        } else return this.useWithoutItem(level, pos, player);
    }

    @Override
    public boolean method_9506(class_2680 pState) {
        return true;
    }

    @Override
    public int method_9524(class_2680 state, class_1922 level, class_2338 pos, class_2350 direction) {
        if (!(level.method_8321(pos) instanceof CircuitBlockEntity blockEntity)) return 0;
        return blockEntity.getPower(direction);
    }

    @Override
    public int method_9603(class_2680 pBlockState, class_1922 pBlockAccess, class_2338 pPos, class_2350 pSide) {
        return pBlockState.method_26195(pBlockAccess, pPos, pSide);
    }

    @Override
    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 neighborBlock, class_2338 neighborPos, boolean movedByPiston) {
        super.method_9612(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        if (level.method_8321(pos) instanceof CircuitBlockEntity blockEntity) {
            //ShortCircuitCommon.LOGGER.info("neighbor changed for circuit at {}", pos);
            blockEntity.updateInputs();
        }
    }

    @Override
    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        if (state.method_31709() && level.method_8321(pos) instanceof CircuitBlockEntity blockEntity) {
            boolean disallowed = false;
            MinecraftServer server = level.method_8503();
            if (server == null) return;
            if (placer instanceof class_1657 player) {
                blockEntity.setOwnerUuid(placer.method_5667());
                CircuitLimitSavedData data = CircuitLimitSavedData.getRuntimeData(server);
                if (!data.canAdd(placer.method_5667())) {
                    player.method_7353(class_2561.method_43471("warning.circuit.place.circuit_board.limit").method_27696(class_2583.field_24360.method_36139(0xffff00)), true);
                    disallowed = true;
                } else
                    data.add(placer.method_5667());
            }

            class_2487 tag = stack.method_7948();
            if (!disallowed && tag.method_25928("uuid")) {
                blockEntity.setUuid(tag.method_25926("uuid"));
                if (stack.method_7938())
                    blockEntity.setName(stack.method_7964());
                if (tag.method_10573("color", class_2520.field_33252))
                    blockEntity.setColor(class_1767.method_7791(tag.method_10568("color")));
                if (!level.method_27983().equals(Constants.CIRCUIT_BOARD_DIMENSION)) {
                    blockEntity.reloadRuntime();
                    blockEntity.updateInputs();
                } else if (placer instanceof class_1657 player)
                    player.method_7353(class_2561.method_43471("warning.circuit.place.circuit_board").method_27696(class_2583.field_24360.method_36139(0xffff00)), true);
            }
        }
        super.method_9567(level, pos, state, placer, stack);
    }
}
