package in.northwestw.shortcircuit.registries.blocks;

import in.northwestw.shortcircuit.properties.DirectionHelper;
import in.northwestw.shortcircuit.properties.RelativeDirection;
import in.northwestw.shortcircuit.registries.Blocks;
import in.northwestw.shortcircuit.registries.blockentities.CircuitBoardBlockEntity;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_3542;
import net.minecraft.class_4970;
import net.minecraft.class_5251;

public class CircuitBoardBlock extends class_2248 implements class_2343 {
    public static final class_2754<RelativeDirection> DIRECTION = RelativeDirection.REL_DIRECTION;
    public static final class_2746 ANNOTATED = class_2746.method_11825("annotated");
    public static final class_2754<Mode> MODE = class_2754.method_11850("mode", Mode.class);
    public static final class_2758 POWER = class_2741.field_12511;

    public CircuitBoardBlock(class_4970.class_2251 properties) {
        this(properties, RelativeDirection.FRONT, false);
    }

    public CircuitBoardBlock(class_4970.class_2251 properties, RelativeDirection direction, boolean annotated) {
        super(properties);
        this.method_9590(
                this.field_10647
                        .method_11664()
                        .method_11657(DIRECTION, direction)
                        .method_11657(ANNOTATED, annotated)
                        .method_11657(MODE, Mode.NONE)
                        .method_11657(POWER, 0)
        );
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(DIRECTION, ANNOTATED, MODE, POWER);
    }

    @Override
    public boolean method_9506(class_2680 state) {
        return state.method_11654(MODE) != Mode.NONE;
    }

    @Override
    public int method_9524(class_2680 state, class_1922 level, class_2338 pos, class_2350 direction) {
        return state.method_11654(MODE) == Mode.INPUT && direction == DirectionHelper.circuitBoardFixedDirection(state.method_11654(DIRECTION)) ? state.method_11654(POWER) : 0;
    }

    @Override
    public int method_9603(class_2680 state, class_1922 level, class_2338 pos, class_2350 direction) {
        return this.method_9524(state, level, pos, direction);
    }

    @Override
    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 neighborBlock, class_2338 neighborPos, boolean movedByPiston) {
        super.method_9612(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        if (state.method_11654(MODE) != Mode.OUTPUT || neighborBlock == Blocks.CIRCUIT_BOARD.get()) return;
        if (level.method_8321(pos) instanceof CircuitBoardBlockEntity blockEntity) {
            class_2350 direction = DirectionHelper.circuitBoardFixedDirection(state.method_11654(DIRECTION)).method_10153();
            class_2680 neighborState = level.method_8320(neighborPos);
            if (!neighborState.method_27852(Blocks.CIRCUIT_BOARD.get()) && !neighborState.method_26215()) {
                blockEntity.updateCircuitBlock(level.method_49808(neighborPos, direction), state.method_11654(DIRECTION));
            }
        }
    }

    @Override
    public void method_9568(class_1799 stack, class_1922 level, List<class_2561> components, class_1836 flag) {
        components.add(class_2561.method_43471("tooltip.short_circuit.circuit_board").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717(0x7f7f7f)).method_10978(true)));
        super.method_9568(stack, level, components, flag);
    }

    @Override
    public @Nullable class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new CircuitBoardBlockEntity(pos, state);
    }

    public enum Mode implements class_3542 {
        NONE("none"),
        INPUT("input"),
        OUTPUT("output");

        final String name;
        Mode(String name) {
            this.name = name;
        }

        @Override
        public String method_15434() {
            return this.name;
        }

        public Mode nextMode() {
            switch (this) {
                case NONE -> {
                    return INPUT;
                }
                case INPUT -> {
                    return OUTPUT;
                }
                default -> {
                    return NONE;
                }
            }
        }
    }
}
