package in.northwestw.shortcircuit.registries.blocks;

import in.northwestw.shortcircuit.registries.*;
import in.northwestw.shortcircuit.registries.blockentities.IntegratedCircuitBlockEntity;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2390;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_3417;
import net.minecraft.class_3965;
import net.minecraft.class_5558;
import net.minecraft.class_5819;

public class IntegratedCircuitBlock extends class_2383 implements class_2343 {
    public static final class_2746 POWERED = class_2741.field_12484;
    public static final class_2746 COLORED = class_2746.method_11825("colored");
    public static final class_2390 PARTICLE = new class_2390(class_243.method_24457(0xFFDD00).method_46409(), 1.0F);

    public IntegratedCircuitBlock(class_2251 pProperties) {
        super(pProperties);
        this.method_9590(this.field_10647.method_11664()
                .method_11657(field_11177, class_2350.field_11043)
                .method_11657(POWERED, false)
                .method_11657(COLORED, false));
    }

    @Override
    public class_2680 method_9605(class_1750 pContext) {
        return this.method_9564().method_11657(field_11177, pContext.method_8042());
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(field_11177, POWERED, COLORED);
    }

    @Override
    public void method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        if (level.method_8321(pos) instanceof IntegratedCircuitBlockEntity blockEntity) {
            if (!player.method_7337() && blockEntity.isValid()) {
                class_1799 stack = new class_1799(Blocks.INTEGRATED_CIRCUIT.get());
                blockEntity.method_38240(stack);
                class_1542 itementity = new class_1542(
                        level, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, stack
                );
                itementity.method_6988();
                level.method_8649(itementity);
            }
        }

        super.method_9576(level, pos, state, player);
    }

    @Override
    public void method_9568(class_1799 stack, class_1922 level, List<class_2561> components, class_1836 flag) {
        super.method_9568(stack, level, components, flag);
        class_2487 tag = stack.method_7948();
        if (tag.method_25928("uuid")) {
            components.add(class_2561.method_43469("tooltip.short_circuit.circuit", tag.method_25926("uuid").toString()).method_27696(class_2583.field_24360.method_36139(0x7f7f7f)));
        }
        if (tag.method_10573("color", class_2487.field_33252)) {
            class_1767 color = class_1767.method_7791(tag.method_10568("color"));
            components.add(class_2561.method_43469("tooltip.short_circuit.circuit.color", class_2561.method_43471("color.minecraft." + color.method_7792())).method_27696(class_2583.field_24360.method_36139(color.method_16357())));
        }
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        class_1799 stack = player.method_5998(hand);
        if (!stack.method_7960()) {
            class_1269 result = this.useItemOn(player.method_5998(hand), level, pos, player, hand);
            if (result != null) return result;
        }
        return super.method_9534(state, level, pos, player, hand, hitResult);
    }

    protected class_1269 useItemOn(class_1799 stack, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand) {
        if ((stack.method_31574(Items.CIRCUIT.get()) || stack.method_31574(Items.INTEGRATED_CIRCUIT.get())) && !player.method_18276() && level.method_8321(pos) instanceof IntegratedCircuitBlockEntity blockEntity && blockEntity.isValid()) {
            class_1799 newStack = new class_1799(Items.INTEGRATED_CIRCUIT.get(), stack.method_7947());
            if (stack.method_7985()) newStack.method_7980(stack.method_7969());
            class_2487 tag = newStack.method_7948();
            tag.method_25927("uuid", blockEntity.getUuid());
            if (blockEntity.getColor() != null)
                tag.method_10575("color", (short) blockEntity.getColor().method_7789());
            player.method_6122(hand, newStack);
            player.method_5783(class_3417.field_14703, 0.5f, 1);
            return class_1269.field_5812;
        }
        return null;
    }

    @Override
    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 neighborBlock, class_2338 neighborPos, boolean movedByPiston) {
        super.method_9612(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        if (level.method_8321(pos) instanceof IntegratedCircuitBlockEntity blockEntity)
            blockEntity.updateInputs();
    }

    @Override
    public boolean method_9506(class_2680 pState) {
        return true;
    }

    @Override
    public int method_9524(class_2680 state, class_1922 level, class_2338 pos, class_2350 direction) {
        return ((IntegratedCircuitBlockEntity) level.method_8321(pos)).getPower(direction);
    }

    @Override
    public int method_9603(class_2680 state, class_1922 level, class_2338 pos, class_2350 direction) {
        return state.method_26195(level, pos, direction);
    }

    @Override
    public @Nullable class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new IntegratedCircuitBlockEntity(pos, state);
    }

    @Override
    public @Nullable <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        return type == BlockEntities.INTEGRATED_CIRCUIT.get() ? (pLevel, pos, pState, blockEntity) -> ((IntegratedCircuitBlockEntity) pLevel.method_8321(pos)).tick() : null;
    }

    @Override
    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        if (state.method_31709() && level.method_8321(pos) instanceof IntegratedCircuitBlockEntity blockEntity) {
            class_2487 tag = stack.method_7948();
            if (tag.method_25928("uuid")) {
                blockEntity.setUuid(tag.method_25926("uuid"));
                if (stack.method_7938())
                    blockEntity.setName(stack.method_7964());
                if (tag.method_10573("color", class_2520.field_33252))
                    blockEntity.setColor(class_1767.method_7791(tag.method_10568("color")));
                blockEntity.updateInputs();
            }
        }
        super.method_9567(level, pos, state, placer, stack);
    }

    @Override
    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 random) {
        if (state.method_11654(POWERED) && (!(level.method_8321(pos) instanceof IntegratedCircuitBlockEntity blockEntity) || !blockEntity.isHidden())) {
            spawnParticles(level, pos);
        }
    }

    // copied from RedstoneOreBlock
    private static void spawnParticles(class_1937 level, class_2338 pos) {
        class_5819 randomsource = level.field_9229;
        for (class_2350 direction : class_2350.values()) {
            class_2338 blockpos = pos.method_10093(direction);
            if (!level.method_8320(blockpos).method_26216(level, pos)) {
                class_2350.class_2351 direction$axis = direction.method_10166();
                double d1 = direction$axis == class_2350.class_2351.field_11048 ? 0.5 + 0.5625 * (double)direction.method_10148() : (double)randomsource.method_43057();
                double d2 = direction$axis == class_2350.class_2351.field_11052 ? 0.5 + 0.5625 * (double)direction.method_10164() : (double)randomsource.method_43057();
                double d3 = direction$axis == class_2350.class_2351.field_11051 ? 0.5 + 0.5625 * (double)direction.method_10165() : (double)randomsource.method_43057();
                level.method_8406(
                        PARTICLE, (double)pos.method_10263() + d1, (double)pos.method_10264() + d2, (double)pos.method_10260() + d3, 0.0, 0.0, 0.0
                );
            }
        }
    }
}
