package in.northwestw.shortcircuit.registries.blocks;

import in.northwestw.shortcircuit.registries.BlockEntities;
import in.northwestw.shortcircuit.registries.Blocks;
import in.northwestw.shortcircuit.registries.blockentities.TruthAssignerBlockEntity;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2390;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class TruthAssignerBlock extends class_2383 implements class_2343 {
    public static final class_2746 LIT = class_2741.field_12548;

    public TruthAssignerBlock(class_2251 properties) {
        super(properties);
        this.method_9590(this.method_9595().method_11664()
                .method_11657(field_11177, class_2350.field_11043)
                .method_11657(LIT, false)
        );
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(field_11177, LIT);
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        return this.method_9564().method_11657(field_11177, context.method_8042().method_10153());
    }

    @Override
    public @Nullable class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new TruthAssignerBlockEntity(pos, state);
    }

    @Override
    public @Nullable <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        return type == BlockEntities.TRUTH_ASSIGNER.get() ? (pLevel, pPos, pState, blockEntity) -> ((TruthAssignerBlockEntity) blockEntity).tick() : null;
    }

    @Override
    public @Nullable class_3908 method_17454(class_2680 state, class_1937 level, class_2338 pos) {
        if (level.method_8321(pos) instanceof TruthAssignerBlockEntity blockEntity) return blockEntity;
        else return null;
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        if (!level.field_9236 && player instanceof class_3222 serverPlayer)
            serverPlayer.method_17355(state.method_26196(level, pos));
        return class_1269.field_5812;
    }

    @Override
    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 random) {
        if (state.method_11654(LIT)) {
            spawnParticles(level, pos);
        }
    }

    // copied from RedstoneOreBlock
    private static void spawnParticles(class_1937 level, class_2338 pos) {
        double d0 = 0.5625;
        class_5819 randomsource = level.field_9229;

        for (class_2350 direction : class_2350.values()) {
            class_2338 blockpos = pos.method_10093(direction);
            if (!level.method_8320(blockpos).method_26216(level, pos)) {
                class_2350.class_2351 direction$axis = direction.method_10166();
                double d1 = direction$axis == class_2350.class_2351.field_11048 ? 0.5 + 0.5625 * (double)direction.method_10148() : (double)randomsource.method_43057();
                double d2 = direction$axis == class_2350.class_2351.field_11052 ? 0.5 + 0.5625 * (double)direction.method_10164() : (double)randomsource.method_43057();
                double d3 = direction$axis == class_2350.class_2351.field_11051 ? 0.5 + 0.5625 * (double)direction.method_10165() : (double)randomsource.method_43057();
                level.method_8406(
                        class_2390.field_11188, (double)pos.method_10263() + d1, (double)pos.method_10264() + d2, (double)pos.method_10260() + d3, 0.0, 0.0, 0.0
                );
            }
        }
    }

    @Override
    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 neighborBlock, class_2338 neighborPos, boolean movedByPiston) {
        super.method_9612(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        if (pos.method_10084().equals(neighborPos) && level.method_8321(pos) instanceof TruthAssignerBlockEntity blockEntity) {
            if (!blockEntity.isWorking()) blockEntity.setErrorCode(1, level.method_8320(neighborPos).method_26215());
            else if (level.method_8320(neighborPos).method_27852(Blocks.CIRCUIT.get())) {
                blockEntity.checkAndRecord();
            }
        }
    }
}
