package in.northwestw.shortcircuit.registries.items;

import in.northwestw.shortcircuit.registries.Blocks;
import in.northwestw.shortcircuit.registries.blockentities.CircuitBlockEntity;
import in.northwestw.shortcircuit.registries.blockentities.IntegratedCircuitBlockEntity;
import in.northwestw.shortcircuit.registries.blocks.CircuitBoardBlock;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3959;

public class LabellingStickItem extends class_1792 {
    public LabellingStickItem(class_1793 properties) {
        super(properties);
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_239 hitresult = method_7872(level, player, class_3959.class_242.field_1348);
        if (hitresult.method_17783() == class_239.class_240.field_1333) return this.changeMode(player.method_5998(hand), player);
        return super.method_7836(level, player, hand);
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        class_2680 state = context.method_8045().method_8320(context.method_8037());
        class_1799 stack = context.method_8041();
        boolean copyPasteMode = stack.method_7985() && stack.method_7969().method_10577("copyMode");
        if (state.method_27852(Blocks.CIRCUIT.get()) || state.method_27852(Blocks.INTEGRATED_CIRCUIT.get()))
            return copyPasteMode ? this.copyOrPasteCircuitColor(context) : this.cycleCircuitColor(context);
        if (state.method_27852(Blocks.CIRCUIT_BOARD.get()))
            return this.toggleAnnotation(context);
        return super.method_7884(context);
    }

    private class_1269 cycleCircuitColor(class_1838 context) {
        class_1937 level = context.method_8045();
        class_2338 pos = context.method_8037();
        class_1657 player = context.method_8036();
        if (level.method_8321(pos) instanceof CircuitBlockEntity blockEntity) blockEntity.cycleColor(player != null && (player.method_18276() || player.method_5715()));
        else if (level.method_8321(pos) instanceof IntegratedCircuitBlockEntity blockEntity) blockEntity.cycleColor(player != null && (player.method_18276() || player.method_5715()));
        return class_1269.field_5812;
    }

    private class_1269 copyOrPasteCircuitColor(class_1838 context) {
        class_1937 level = context.method_8045();
        class_2338 pos = context.method_8037();
        class_1657 player = context.method_8036();
        class_1799 stack = context.method_8041();
        class_2487 tag = stack.method_7948();
        if (player.method_18276() || player.method_5715()) {
            // copy color
            class_1767 color = null;
            if (level.method_8321(pos) instanceof CircuitBlockEntity blockEntity) color = blockEntity.getColor();
            else if (level.method_8321(pos) instanceof IntegratedCircuitBlockEntity blockEntity) color = blockEntity.getColor();
            if (color == null) tag.method_10551("color");
            else tag.method_10575("color", (short) color.method_7789());
            stack.method_7980(tag);
            player.method_7353(class_2561.method_43471("action.labelling_stick.copy").method_27696(color == null ? class_2583.field_24360 : class_2583.field_24360.method_36139(color.method_16357())), true);
        } else {
            short id = tag.method_10573("color", class_2520.field_33252) ? tag.method_10568("color") : -1;
            class_1767 color = id < 0 ? null : class_1767.method_7791(id);
            if (level.method_8321(pos) instanceof CircuitBlockEntity blockEntity) blockEntity.setColor(color);
            else if (level.method_8321(pos) instanceof IntegratedCircuitBlockEntity blockEntity) blockEntity.setColor(color);
        }
        return class_1269.field_5812;
    }

    private class_1271<class_1799> changeMode(class_1799 stack, class_1657 player) {
        class_2487 tag = stack.method_7948();
        boolean copyPasteMode = tag.method_10577("copyMode");
        tag.method_10556("copyMode", !copyPasteMode);
        stack.method_7980(tag);
        player.method_7353(class_2561.method_43471("action.labelling_stick.change." + (!copyPasteMode ? "copy" : "cycle")), true);
        player.method_43077(class_3417.field_15219);
        return class_1271.method_22427(stack);
    }

    private class_1269 toggleAnnotation(class_1838 context) {
        class_1937 level = context.method_8045();
        class_2338 pos = context.method_8037();
        level.method_8501(pos, level.method_8320(pos).method_11657(CircuitBoardBlock.ANNOTATED, !level.method_8320(pos).method_11654(CircuitBoardBlock.ANNOTATED)));
        return class_1269.field_5812;
    }
}
