package in.northwestw.shortcircuit.registries.items;

import com.google.common.collect.Sets;
import in.northwestw.shortcircuit.Constants;
import in.northwestw.shortcircuit.config.Config;
import in.northwestw.shortcircuit.data.CircuitSavedData;
import in.northwestw.shortcircuit.data.Octolet;
import in.northwestw.shortcircuit.properties.RelativeDirection;
import in.northwestw.shortcircuit.registries.Blocks;
import in.northwestw.shortcircuit.registries.blockentities.CircuitBlockEntity;
import in.northwestw.shortcircuit.registries.blockentities.IntegratedCircuitBlockEntity;
import in.northwestw.shortcircuit.registries.blocks.CircuitBoardBlock;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3959;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import java.util.Collection;
import java.util.UUID;

public class PokingStickItem extends class_1792 {
    public PokingStickItem(class_1793 properties) {
        super(properties);
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_239 hitresult = method_7872(level, player, class_3959.class_242.field_1348);
        if (hitresult.method_17783() == class_239.class_240.field_1333) return this.cycleBlockSize(player.method_5998(hand), player);
        return super.method_7836(level, player, hand);
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        class_1937 level = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2680 state = level.method_8320(pos);
        class_1657 player = context.method_8036();
        class_1799 stack = context.method_8041();
        if (state.method_27852(Blocks.CIRCUIT_BOARD.get())) return this.useOnCircuitBoardBlock(context);
        if (state.method_27852(Blocks.CIRCUIT.get())) return this.useOnCircuitBlock(context);
        if (state.method_27852(Blocks.INTEGRATED_CIRCUIT.get())) return this.useOnIntegratedCircuitBlock(context);

        return this.cycleBlockSize(stack, player).method_5467();
    }

    private class_1269 useOnCircuitBlock(class_1838 context) {
        class_1937 level = context.method_8045();
        if (!(level.method_8321(context.method_8037()) instanceof CircuitBlockEntity blockEntity)) return class_1269.field_5814;
        class_1657 player = context.method_8036();
        class_1799 stack = context.method_8041();
        if (player.method_18276() || player.method_5715()) {
            blockEntity.setHidden(!blockEntity.isHidden());
        } else {
            DimensionTransition transition;
            UUID uuid = blockEntity.getUuid();
            class_2487 tag = stack.method_7948();
            tag.method_10582("lastPosDim", level.method_27983().method_29177().toString());
            tag.method_10566("lastPos", class_2512.method_10692(player.method_24515()));
            stack.method_7980(tag);
            if (uuid == null) {
                blockEntity.setBlockSize(this.getBlockSize(stack));
                transition = this.getNewDimensionTransition(this.getBlockSize(stack), level, blockEntity);
            } else {
                transition = this.getDimensionTransition(uuid, level);
            }

            if (transition != null) transition.teleportToDimension(player);
        }

        return class_1269.field_5812;
    }

    private class_1269 useOnCircuitBoardBlock(class_1838 context) {
        class_1657 player = context.method_8036();
        class_1937 level = context.method_8045();
        if (player.method_18276() || player.method_5715()) {
            class_2680 state = level.method_8320(context.method_8037());
            level.method_8501(context.method_8037(), state.method_11657(CircuitBoardBlock.MODE, state.method_11654(CircuitBoardBlock.MODE).nextMode()));
        } else {
            class_1799 stack = context.method_8041();
            class_2487 tag = stack.method_7948();
            MinecraftServer server = level.method_8503();
            if (server == null) return class_1269.field_21466;
            if (tag.method_10573("lastPosDim", class_2487.field_33258) && tag.method_10545("lastPos")) {
                class_3218 serverLevel = server.method_3847(class_5321.method_29179(class_7924.field_41223, new class_2960(tag.method_10558("lastPosDim"))));
                new DimensionTransition(serverLevel, class_2512.method_10691(tag.method_10562("lastPos")).method_46558()).teleportToDimension(player);
                tag.method_10551("lastPosDim");
                tag.method_10551("lastPos");
                stack.method_7980(tag);
            } else {
                class_3222 serverPlayer = (class_3222) player;
                class_3218 serverLevel = server.method_3847(serverPlayer.method_26281());
                class_2338 respawn = serverPlayer.method_26280();
                if (respawn == null) respawn = serverLevel.method_43126();
                new DimensionTransition(serverLevel, respawn.method_46558()).teleportToDimension(player);
            }
        }
        return class_1269.field_5812;
    }

    private class_1269 useOnIntegratedCircuitBlock(class_1838 context) {
        class_1937 level = context.method_8045();
        class_1657 player = context.method_8036();
        if (!(level.method_8321(context.method_8037()) instanceof IntegratedCircuitBlockEntity blockEntity)) return class_1269.field_5814;
        if (player.method_18276() || player.method_5715()) {
            blockEntity.setHidden(!blockEntity.isHidden());
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    private short getBlockSize(class_1799 stack) {
        short size = stack.method_7948().method_10568("size");
        return size < 4 ? 4 : size;
    }

    private class_1271<class_1799> cycleBlockSize(class_1799 stack, class_1657 player) {
        class_2487 tag = stack.method_7948();
        short old = tag.method_10573("size", class_2487.field_33252) ? tag.method_10568("size") : 4;
        short newVal = old == 256 ? 4 : (short) (old * 2);
        tag.method_10575("size", newVal);
        stack.method_7980(tag);
        player.method_7353(class_2561.method_43469("action.poking_stick.change", newVal), true);
        player.method_43077(class_3417.field_15219);
        return class_1271.method_22427(stack);
    }

    private DimensionTransition getDimensionTransition(UUID uuid, class_1937 level) {
        MinecraftServer server = level.method_8503();
        if (server == null) return null;
        class_3218 circuitBoardLevel = server.method_3847(Constants.CIRCUIT_BOARD_DIMENSION);
        if (circuitBoardLevel == null) return null;
        CircuitSavedData data = CircuitSavedData.getCircuitBoardData(circuitBoardLevel);
        return new DimensionTransition(circuitBoardLevel, data.getCircuitStartingPos(uuid).method_10069(1, 1, 1).method_46558());
    }

    private DimensionTransition getNewDimensionTransition(short blockSize, class_1937 level, CircuitBlockEntity blockEntity) {
        MinecraftServer server = level.method_8503();
        if (server == null) return null;
        class_3218 circuitBoardLevel = server.method_3847(Constants.CIRCUIT_BOARD_DIMENSION);
        if (circuitBoardLevel == null) return null;
        // add the circuit to the world
        CircuitSavedData data = CircuitSavedData.getCircuitBoardData(circuitBoardLevel);
        int octoletIndex = data.octoletIndexForSize(blockSize);
        if (!data.octolets.containsKey(octoletIndex)) data.addOctolet(octoletIndex, new Octolet(blockSize));
        UUID uuid = UUID.randomUUID();
        data.addCircuit(uuid, octoletIndex);
        blockEntity.setUuid(uuid);
        // create the space in circuit board
        class_2338 startingPos = data.getCircuitStartingPos(uuid);
        for (int ii = 0; ii < blockSize; ii++) {
            for (int jj = 0; jj < blockSize; jj++) {
                for (int kk = 0; kk < blockSize; kk++) {
                    if ((ii != 0 && ii != blockSize - 1) && (jj != 0 && jj != blockSize - 1) && (kk != 0 && kk != blockSize - 1)) continue;
                    class_2680 state = Blocks.CIRCUIT_BOARD.get().method_9564();
                    if (jj == 0) state = state.method_11657(CircuitBoardBlock.DIRECTION, RelativeDirection.DOWN);
                    else if (jj == blockSize - 1) state = state.method_11657(CircuitBoardBlock.DIRECTION, RelativeDirection.UP);
                    else if (ii == 0) state = state.method_11657(CircuitBoardBlock.DIRECTION, RelativeDirection.FRONT);
                    else if (ii == blockSize - 1) state = state.method_11657(CircuitBoardBlock.DIRECTION, RelativeDirection.BACK);
                    else if (kk == 0) state = state.method_11657(CircuitBoardBlock.DIRECTION, RelativeDirection.RIGHT);
                    else if (kk == blockSize - 1) state = state.method_11657(CircuitBoardBlock.DIRECTION, RelativeDirection.LEFT);
                    // annotate middle 4
                    if (this.isMiddleFour(ii, jj, kk, blockSize)) state = state.method_11657(CircuitBoardBlock.ANNOTATED, true);
                    circuitBoardLevel.method_8652(startingPos.method_10069(ii, jj, kk), state, 3);
                }
            }
        }
        return new DimensionTransition(circuitBoardLevel, startingPos.method_10069(1, 1, 1).method_46558());
    }

    private boolean isMiddleFour(int ii, int jj, int kk, short blockSize) {
        int halfBlockSize = blockSize / 2;
        boolean iiHalf = Math.abs((ii + 0.5) - halfBlockSize) == 0.5;
        boolean jjHalf = Math.abs((jj + 0.5) - halfBlockSize) == 0.5;
        boolean kkHalf = Math.abs((kk + 0.5) - halfBlockSize) == 0.5;
        return
                (iiHalf && jjHalf) && (kk == 0 || kk == blockSize - 1) ||
                (jjHalf && kkHalf) && (ii == 0 || ii == blockSize - 1) ||
                (kkHalf && iiHalf) && (jj == 0 || jj == blockSize - 1);
    }

    private record DimensionTransition(class_3218 level, class_243 pos) {
        private void teleportToDimension(class_1657 player) {
            // minecraft itself has broken effects on changing dimension. this is a workaround
            Collection<class_1293> effects = player.method_6026();
            player.method_48105(this.level, this.pos.field_1352, this.pos.field_1351, this.pos.field_1350, Sets.newHashSet(), 0, 0);
            class_1297 entity = this.level.method_14190(player.method_5667());
            if (entity instanceof class_1657 newPlayer)
                effects.forEach(effect -> newPlayer.method_26082(effect, null));
        }
    }
}
