package in.northwestw.shortcircuit.registries.menus;

import in.northwestw.shortcircuit.registries.Blocks;
import in.northwestw.shortcircuit.registries.Menus;
import in.northwestw.shortcircuit.registries.blockentities.TruthAssignerBlockEntity;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3913;
import net.minecraft.class_3914;
import net.minecraft.class_3919;
import net.minecraft.world.inventory.*;
import org.jetbrains.annotations.Nullable;

public class TruthAssignerMenu extends class_1703 {
    private final class_3914 access;
    private final class_1263 container;
    private final class_3913 containerData;

    // Client constructor
    public TruthAssignerMenu(int containerId, class_1661 inventory) {
        this(containerId, inventory, class_3914.field_17304, null, new class_3919(6));
    }

    // Server constructor
    public TruthAssignerMenu(int containerId, class_1661 inventory, class_3914 access, @Nullable class_1263 container, class_3913 containerData) {
        super(Menus.TRUTH_ASSIGNER.get(), containerId);
        this.access = access;
        if (container == null) this.container = this.createContainer(2);
        else this.container = container;
        this.containerData = containerData;
        method_17359(this.container, 2);
        method_17361(this.containerData, 6);

        // input
        this.method_7621(new class_1735(this.container, 0, 14, 34));
        // output
        this.method_7621(new class_1735(this.container, 1, 72, 34) {
            @Override
            public boolean method_7680(class_1799 stack) {
                return false;
            }
        });

        // hotbar goes from 2 to 10
        for (int k = 0; k < 9; k++) {
            this.method_7621(new class_1735(inventory, k, 8 + k * 18, 142));
        }

        // inventory goes from 11 to 37
        for (int i = 0; i < 3; i++) {
            for (int j = 0; j < 9; j++) {
                this.method_7621(new class_1735(inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }

        this.method_17360(this.containerData);

        if (this.container instanceof TruthAssignerBlockEntity blockEntity)
            this.method_7596(blockEntity);
    }

    // inventory has size 2
    // 0 = out, 1 = in, 2-28 = player inv, 29-37 = player hotbar
    @Override
    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 stack = class_1799.field_8037;
        class_1735 slot = this.field_7761.get(index);
        if (slot.method_7681()) {
            class_1799 rawStack = slot.method_7677();
            stack = rawStack.method_7972();

            // data output slot
            if (index == 1) {
                // move to inventory
                if (!this.method_7616(rawStack, 2, 38, true))
                    return class_1799.field_8037;
                slot.method_7670(rawStack, stack);
            }
            // inv or bar
            else if (index >= 2 && index < 38) {
                // move from inv/bar to in
                if (!this.method_7616(rawStack, 0, 1, false)) {
                    // move from inv to bar
                    if (index >= 11) {
                        if (!this.method_7616(rawStack, 2, 11, false))
                            return class_1799.field_8037;
                    }
                    // move from bar to inv
                    else if (!this.method_7616(rawStack, 11, 38, false))
                        return class_1799.field_8037;
                }
            }
            // from in to inv/bar
            else if (!this.method_7616(rawStack, 2, 38, false))
                return class_1799.field_8037;

            if (rawStack.method_7960())
                slot.method_7673(class_1799.field_8037);
            else
                slot.method_7668();

            if (rawStack.method_7947() == stack.method_7947())
                return class_1799.field_8037;
        }
        return stack;
    }

    @Override
    public boolean method_7597(class_1657 player) {
        return class_1703.method_17695(this.access, player, Blocks.TRUTH_ASSIGNER.get());
    }

    public boolean isEmpty() {
        return this.container.method_5442();
    }

    public boolean isWorking() {
        return this.containerData.method_17390(0) == 1;
    }

    public boolean shouldWait() {
        return this.containerData.method_17390(1) == 1;
    }

    public int getMaxDelay() {
        return this.containerData.method_17390(2);
    }

    public int getError() {
        return this.containerData.method_17390(3);
    }

    public int getCurrentInput() {
        return this.containerData.method_17390(4);
    }

    public int getBits() {
        return this.containerData.method_17390(5);
    }

    public void setWait(boolean val) {
        this.method_7606(1, val ? 1 : 0);
    }

    public boolean setMaxDelay(int maxDelay) {
        if (maxDelay != this.getMaxDelay()) {
            this.method_7606(2, maxDelay);
            return true;
        }
        return false;
    }

    public void setNextBits() {
        int newBits = this.getBits() * 2;
        if (newBits > 4) newBits = 1;
        this.method_7606(5, newBits);
    }

    public void start() {
        if (this.isWorking()) return;
        this.method_7606(0, 1);
    }

    // copied from ItemCombinerMenu
    private class_1277 createContainer(int size) {
        return new class_1277(size) {
            @Override
            public void method_5431() {
                super.method_5431();
                TruthAssignerMenu.this.method_7609(this);
            }
        };
    }

    @Override
    public void method_7606(int id, int data) {
        super.method_7606(id, data);
        this.method_7623();
    }

    // These are server-side
    @Override
    public boolean method_7604(class_1657 player, int id) {
        if (id == -1) {
            this.setWait(!this.shouldWait());
            return true;
        } else if (id == -2) {
            this.start();
            return true;
        } else if (id == -3) {
            this.setNextBits();
            return true;
        } else {
            // cheese-iest strat ever to transfer int without implementing my own packet
            this.setMaxDelay(id);
        }
        return super.method_7604(player, id);
    }
}
