/*
 * Decompiled with CFR 0.152.
 */
package com.staticlabs.quickequip;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="quickequip", value={Dist.CLIENT})
public class ToolEquipHandler {
    public static boolean autoEquipEnabled = true;
    public static final KeyMapping TOGGLE_KEY = new KeyMapping("key.quickequip.toggle", 82, "key.categories.gameplay");

    @SubscribeEvent
    public static void registerKeybinds(RegisterKeyMappingsEvent event) {
        event.register(TOGGLE_KEY);
    }

    @SubscribeEvent
    public static void onKeyPress(InputEvent.Key event) {
        if (TOGGLE_KEY.m_90859_()) {
            autoEquipEnabled = !autoEquipEnabled;
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null) {
                mc.f_91074_.m_5661_((Component)Component.m_237113_((String)("Auto-equip " + (autoEquipEnabled ? "enabled \u2705" : "disabled \u274c"))), true);
            }
        }
    }

    @SubscribeEvent
    public static void onItemBreak(PlayerDestroyItemEvent event) {
        if (!autoEquipEnabled) {
            return;
        }
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        ItemStack broken = event.getOriginal();
        if (broken.m_41619_()) {
            return;
        }
        ToolEquipHandler.tryEquipSimilarTool(player, InteractionHand.MAIN_HAND, broken);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!autoEquipEnabled) {
            return;
        }
        Player player = event.player;
        if (player.m_9236_().f_46443_ || player.f_19797_ % 10 != 0) {
            return;
        }
        if (player.m_21205_().m_41619_()) {
            // empty if block
        }
    }

    private static void tryEquipSimilarTool(Player player, InteractionHand hand, ItemStack referenceStack) {
        Class<?> toolClass = referenceStack != null ? referenceStack.m_41720_().getClass() : null;
        List candidates = player.m_150109_().f_35974_.stream().filter(stack -> !stack.m_41619_() && stack.m_41720_() instanceof TieredItem && (toolClass == null || stack.m_41720_().getClass() == toolClass)).sorted(Comparator.comparingInt(stack -> ((TieredItem)stack.m_41720_()).m_43314_().m_6604_()).reversed().thenComparingInt(stack -> stack.m_41776_() - stack.m_41773_()).thenComparingInt(ToolEquipHandler::enchantmentScore).reversed()).collect(Collectors.toList());
        if (!candidates.isEmpty()) {
            ItemStack best = ((ItemStack)candidates.get(0)).m_41777_();
            player.m_21008_(hand, best);
            for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                if (!ItemStack.m_150942_((ItemStack)((ItemStack)player.m_150109_().f_35974_.get(i)), (ItemStack)((ItemStack)candidates.get(0)))) continue;
                player.m_150109_().f_35974_.set(i, (Object)ItemStack.f_41583_);
                break;
            }
        }
    }

    private static int enchantmentScore(ItemStack stack) {
        int score = 0;
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
        for (Map.Entry entry : enchantments.entrySet()) {
            Enchantment ench = (Enchantment)entry.getKey();
            int level = (Integer)entry.getValue();
            if (ench == ToolEquipHandler.getEnchantment("unbreaking")) {
                score += 2 * level;
                continue;
            }
            if (ench == ToolEquipHandler.getEnchantment("efficiency")) {
                score += 3 * level;
                continue;
            }
            if (ench == ToolEquipHandler.getEnchantment("fortune")) {
                score += 5 * level;
                continue;
            }
            if (ench == ToolEquipHandler.getEnchantment("silk_touch")) {
                score += 6;
                continue;
            }
            score += level;
        }
        return score;
    }

    private static Enchantment getEnchantment(String name) {
        return (Enchantment)BuiltInRegistries.f_256876_.m_7745_(new ResourceLocation(name));
    }
}

