/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.giddypigs.entities;

import com.dragn0007.dragnlivestock.items.LOItems;
import com.dragn0007.dragnlivestock.util.LOTags;
import com.dragn0007.dragnlivestock.util.LivestockOverhaulCommonConfig;
import com.dragn0007.giddypigs.entities.GuineaPigEyeLayer;
import com.dragn0007.giddypigs.entities.GuineaPigMarkingLayer;
import com.dragn0007.giddypigs.entities.GuineaPigModel;
import com.dragn0007.giddypigs.entities.ai.GuineaPigFollowOwnerGoal;
import com.dragn0007.giddypigs.entities.ai.PiggieFollowLeaderGoal;
import com.dragn0007.giddypigs.entities.util.EntityTypes;
import com.dragn0007.giddypigs.items.GGPItems;
import com.dragn0007.giddypigs.util.GGPTags;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.event.ForgeEventFactory;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GuineaPig
extends TamableAnimal
implements GeoEntity {
    private GuineaPig leader;
    private int herdSize = 1;
    private static final Ingredient FOOD_ITEMS = Ingredient.m_204132_(GGPTags.Items.GUINEA_PIG_FOOD);
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public boolean toldToWander = false;
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(GuineaPig.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> OVERLAY = SynchedEntityData.m_135353_(GuineaPig.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> BREED = SynchedEntityData.m_135353_(GuineaPig.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> EYES = SynchedEntityData.m_135353_(GuineaPig.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> GENDER = SynchedEntityData.m_135353_(GuineaPig.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public GuineaPig(EntityType<? extends GuineaPig> type, Level level) {
        super(type, level);
        this.f_19811_ = true;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, (double)0.16f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, (double)1.8f));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(3, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(4, (Goal)new PiggieFollowLeaderGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new GuineaPigFollowOwnerGoal(this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 15.0f, (double)1.8f, (double)1.8f, livingEntity -> livingEntity.m_6095_().m_204039_(LOTags.Entity_Types.WOLVES) && livingEntity instanceof TamableAnimal && !((TamableAnimal)livingEntity).m_21824_() && !this.m_21824_()));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 15.0f, (double)1.8f, (double)1.8f, livingEntity -> livingEntity.m_6095_().m_204039_(LOTags.Entity_Types.CATS) && livingEntity instanceof TamableAnimal && !((TamableAnimal)livingEntity).m_21824_() && !this.m_21824_()));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 15.0f, (double)1.8f, (double)1.8f, livingEntity -> livingEntity.m_6095_().m_204039_(LOTags.Entity_Types.DOGS) && livingEntity instanceof TamableAnimal && !((TamableAnimal)livingEntity).m_21824_() && !this.m_21824_()));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 15.0f, (double)1.8f, (double)1.8f, livingEntity -> livingEntity.m_6095_().m_204039_(LOTags.Entity_Types.FOXES) && livingEntity instanceof TamableAnimal && !((TamableAnimal)livingEntity).m_21824_() && !this.m_21824_()));
    }

    public boolean isFollower() {
        return this.leader != null && this.leader.m_6084_();
    }

    public GuineaPig startFollowing(GuineaPig pig) {
        this.leader = pig;
        pig.addFollower();
        return pig;
    }

    public void stopFollowing() {
        this.leader.removeFollower();
        this.leader = null;
    }

    private void addFollower() {
        ++this.herdSize;
    }

    private void removeFollower() {
        --this.herdSize;
    }

    public boolean canBeFollowed() {
        return this.hasFollowers() && this.herdSize < this.getMaxHerdSize();
    }

    public int getMaxHerdSize() {
        return 4;
    }

    public boolean hasFollowers() {
        return this.herdSize > 1;
    }

    public boolean inRangeOfLeader() {
        return this.m_20280_((Entity)this.leader) <= 121.0;
    }

    public void pathToLeader() {
        if (this.isFollower()) {
            this.m_21573_().m_5624_((Entity)this.leader, 1.0);
        }
    }

    public void addFollowers(Stream<? extends GuineaPig> stream) {
        stream.limit(this.getMaxHerdSize() - this.herdSize).filter(pig -> pig != this).forEach(pig -> pig.startFollowing(this));
    }

    public void m_8119_() {
        List list;
        super.m_8119_();
        if (this.hasFollowers() && this.m_9236_().f_46441_.m_188503_(200) == 1 && (list = this.m_9236_().m_45976_(((Object)((Object)this)).getClass(), this.m_20191_().m_82377_(8.0, 8.0, 8.0))).size() <= 1) {
            this.herdSize = 1;
        }
    }

    public float getStepHeight() {
        return 1.0f;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        double currentSpeed = this.m_20184_().m_82556_();
        double speedThreshold = 0.01;
        AnimationController controller = tAnimationState.getController();
        if (tAnimationState.isMoving()) {
            if (currentSpeed > speedThreshold) {
                controller.setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
                controller.setAnimationSpeed(2.4);
            } else {
                controller.setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
                controller.setAnimationSpeed(1.4);
            }
        } else if (this.m_21825_()) {
            controller.setAnimation(RawAnimation.begin().then("sit", Animation.LoopType.LOOP));
            controller.setAnimationSpeed(1.0);
        } else {
            controller.setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            controller.setAnimationSpeed(1.0);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    protected SoundEvent m_7515_() {
        super.m_7515_();
        return SoundEvents.f_12297_;
    }

    protected SoundEvent m_5592_() {
        super.m_5592_();
        return SoundEvents.f_12352_;
    }

    protected SoundEvent m_7975_(DamageSource p_30720_) {
        super.m_7975_(p_30720_);
        return SoundEvents.f_12353_;
    }

    protected void m_7355_(BlockPos p_28254_, BlockState p_28255_) {
        this.m_5496_(SoundEvents.f_12354_, 0.15f, 1.0f);
    }

    public boolean m_6898_(ItemStack itemStack) {
        return FOOD_ITEMS.test(itemStack);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (itemstack.m_150930_((Item)LOItems.GENDER_TEST_STRIP.get()) && this.isFemale()) {
            player.m_5496_(SoundEvents.f_11696_, 1.0f, 1.0f);
            ItemStack itemstack1 = ItemUtils.m_41813_((ItemStack)itemstack, (Player)player, (ItemStack)((Item)LOItems.FEMALE_GENDER_TEST_STRIP.get()).m_7968_());
            player.m_21008_(hand, itemstack1);
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_150930_((Item)LOItems.GENDER_TEST_STRIP.get()) && this.isMale()) {
            player.m_5496_(SoundEvents.f_11696_, 1.0f, 1.0f);
            ItemStack itemstack1 = ItemUtils.m_41813_((ItemStack)itemstack, (Player)player, (ItemStack)((Item)LOItems.MALE_GENDER_TEST_STRIP.get()).m_7968_());
            player.m_21008_(hand, itemstack1);
            return InteractionResult.SUCCESS;
        }
        if (player.m_6144_() && !this.m_6898_(itemstack) && !this.m_21825_() && !this.wasToldToWander() && this.m_21830_((LivingEntity)player)) {
            this.setToldToWander(true);
            player.m_5661_((Component)Component.m_237115_((String)"tooltip.giddypigs.wandering.tooltip").m_130940_(ChatFormatting.GOLD), true);
            return InteractionResult.SUCCESS;
        }
        if (player.m_6144_() && !this.m_6898_(itemstack) && !this.m_21825_() && this.wasToldToWander() && this.m_21830_((LivingEntity)player)) {
            this.setToldToWander(false);
            player.m_5661_((Component)Component.m_237115_((String)"tooltip.giddypigs.following.tooltip").m_130940_(ChatFormatting.GOLD), true);
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_() && this.m_6898_(itemstack)) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(0.6), this.m_20187_(), this.m_20262_(0.6), 0.7, 0.7, 0.7);
            if (this.m_21223_() < this.m_21233_()) {
                this.m_5634_(2.0f);
            }
            int i = this.m_146764_();
            if (!this.m_9236_().f_46443_ && i == 0 && this.m_5957_()) {
                this.m_142075_(player, hand, itemstack);
                this.m_27595_(player);
                return InteractionResult.SUCCESS;
            }
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            this.m_146850_(GameEvent.f_223708_);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.m_9236_().f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)player) || this.m_21824_() || this.m_6898_(itemstack) && !this.m_21824_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            InteractionResult interactionresult;
            if (this.m_6898_(itemstack)) {
                if (this.m_21223_() < this.m_21233_()) {
                    this.m_5634_(2.0f);
                }
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                int i = this.m_146764_();
                if (!this.m_9236_().f_46443_ && i == 0 && this.m_5957_()) {
                    this.m_142075_(player, hand, itemstack);
                    this.m_27595_(player);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.SUCCESS;
            }
            if (!this.m_6898_(itemstack) && (!(interactionresult = super.m_6071_(player, hand)).m_19077_() || this.m_6162_()) && this.m_21830_((LivingEntity)player)) {
                if (!player.m_6144_()) {
                    this.m_21839_(!this.m_21827_());
                    this.f_20899_ = false;
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                    return InteractionResult.SUCCESS;
                }
                return interactionresult;
            }
        } else if (this.m_6898_(itemstack)) {
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                this.m_21828_(player);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21839_(true);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public boolean wasToldToWander() {
        return this.toldToWander;
    }

    public boolean getToldToWander() {
        return this.toldToWander;
    }

    public void setToldToWander(boolean toldToWander) {
        this.toldToWander = toldToWander;
    }

    public ResourceLocation getTextureLocation() {
        return GuineaPigModel.Variant.variantFromOrdinal((int)this.getVariant()).resourceLocation;
    }

    public ResourceLocation getOverlayLocation() {
        return GuineaPigMarkingLayer.Overlay.overlayFromOrdinal((int)this.getOverlayVariant()).resourceLocation;
    }

    public ResourceLocation getEyeLocation() {
        return GuineaPigEyeLayer.Overlay.eyeFromOrdinal((int)this.getEyeVariant()).resourceLocation;
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public int getOverlayVariant() {
        return (Integer)this.f_19804_.m_135370_(OVERLAY);
    }

    public int getEyeVariant() {
        return (Integer)this.f_19804_.m_135370_(EYES);
    }

    public int getBreed() {
        return (Integer)this.f_19804_.m_135370_(BREED);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public void setOverlayVariant(int overlayVariant) {
        this.f_19804_.m_135381_(OVERLAY, (Object)overlayVariant);
    }

    public void setEyeVariant(int eyeVariant) {
        this.f_19804_.m_135381_(EYES, (Object)eyeVariant);
    }

    public void setBreed(int breed) {
        this.f_19804_.m_135381_(BREED, (Object)breed);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Variant")) {
            this.setVariant(tag.m_128451_("Variant"));
        }
        if (tag.m_128441_("Overlay")) {
            this.setOverlayVariant(tag.m_128451_("Overlay"));
        }
        if (tag.m_128441_("Eyes")) {
            this.setEyeVariant(tag.m_128451_("Eyes"));
        }
        if (tag.m_128441_("Gender")) {
            this.setGender(tag.m_128451_("Gender"));
        }
        if (tag.m_128441_("Breed")) {
            this.setBreed(tag.m_128451_("Breed"));
        }
        if (tag.m_128441_("Wandering")) {
            this.setToldToWander(tag.m_128471_("Wandering"));
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant());
        tag.m_128405_("Overlay", this.getOverlayVariant());
        tag.m_128405_("Eyes", this.getEyeVariant());
        tag.m_128405_("Gender", this.getGender());
        tag.m_128405_("Breed", this.getBreed());
        tag.m_128379_("Wandering", this.getToldToWander());
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        if (data == null) {
            data = new AgeableMob.AgeableMobGroupData(0.2f);
        }
        Random random = new Random();
        this.setGender(random.nextInt(Gender.values().length));
        if (((Boolean)LivestockOverhaulCommonConfig.SPAWN_BY_BREED.get()).booleanValue()) {
            this.setColor();
            this.setMarking();
            this.setEyeColorByChance();
            this.setBreedChance();
        } else {
            this.setVariant(random.nextInt(GuineaPigModel.Variant.values().length - 1));
            this.setOverlayVariant(random.nextInt(GuineaPigMarkingLayer.Overlay.values().length));
            this.setOverlayVariant(random.nextInt(GuineaPigEyeLayer.Overlay.values().length));
            this.setBreed(random.nextInt(Breed.values().length));
        }
        if (this.getBreed() == 2) {
            this.setVariant(12);
        }
        return super.m_6518_(serverLevelAccessor, instance, spawnType, data, tag);
    }

    public void setColor() {
        if (this.f_19796_.m_188500_() <= 0.05) {
            int[] variants = new int[]{4, 5, 6, 9};
            int randomIndex = new Random().nextInt(variants.length);
            this.setVariant(variants[randomIndex]);
        } else if (this.f_19796_.m_188500_() > 0.05 && this.f_19796_.m_188500_() < 0.2) {
            int[] variants = new int[]{1, 8, 10, 11};
            int randomIndex = new Random().nextInt(variants.length);
            this.setVariant(variants[randomIndex]);
        } else if (this.f_19796_.m_188500_() > 0.2) {
            int[] variants = new int[]{0, 2, 3, 7};
            int randomIndex = new Random().nextInt(variants.length);
            this.setVariant(variants[randomIndex]);
        }
        if (this.getBreed() == 2) {
            this.setVariant(12);
        }
    }

    public void setMarking() {
        if (this.f_19796_.m_188500_() <= 0.03) {
            this.setOverlayVariant(this.f_19796_.m_188503_(GuineaPigMarkingLayer.Overlay.values().length));
        } else if (this.f_19796_.m_188500_() > 0.03) {
            this.setOverlayVariant(0);
        }
    }

    public void setEyeColorByChance() {
        if (this.getVariant() == 4 || this.getVariant() == 11 || this.getOverlayVariant() == 73) {
            if (this.f_19796_.m_188500_() < 0.1) {
                this.setEyeVariant(3);
            } else if (this.f_19796_.m_188500_() > 0.1) {
                this.setEyeVariant(this.m_217043_().m_188503_(2));
            } else {
                this.setEyeVariant(0);
            }
        } else if (this.f_19796_.m_188500_() < 0.02) {
            this.setEyeVariant(3);
        } else if (this.f_19796_.m_188500_() > 0.02) {
            this.setEyeVariant(this.m_217043_().m_188503_(2));
        } else {
            this.setEyeVariant(0);
        }
    }

    public void setBreedChance() {
        if (this.f_19796_.m_188500_() <= 0.02) {
            this.setBreed(this.m_217043_().m_188503_(Breed.values().length));
        } else if (this.f_19796_.m_188500_() > 0.02) {
            this.setBreed(0);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(OVERLAY, (Object)0);
        this.f_19804_.m_135372_(EYES, (Object)0);
        this.f_19804_.m_135372_(GENDER, (Object)0);
        this.f_19804_.m_135372_(BREED, (Object)0);
    }

    public boolean isFemale() {
        return this.getGender() == 0;
    }

    public boolean isMale() {
        return this.getGender() == 1;
    }

    public int getGender() {
        return (Integer)this.f_19804_.m_135370_(GENDER);
    }

    public void setGender(int gender) {
        this.f_19804_.m_135381_(GENDER, (Object)gender);
    }

    public boolean canParent() {
        return !this.m_6162_() && this.m_27593_();
    }

    public boolean m_7848_(Animal animal) {
        if (animal == this) {
            return false;
        }
        if (!(animal instanceof GuineaPig)) {
            return false;
        }
        if (!((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BREEDING.get()).booleanValue()) {
            return this.canParent() && ((GuineaPig)animal).canParent();
        }
        GuineaPig partner = (GuineaPig)animal;
        if (this.canParent() && partner.canParent() && this.getGender() != partner.getGender()) {
            return this.isFemale();
        }
        return false;
    }

    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        GuineaPig baby = (GuineaPig)ageableMob;
        if (ageableMob instanceof GuineaPig) {
            GuineaPig partner = (GuineaPig)ageableMob;
            baby = (GuineaPig)((EntityType)EntityTypes.GUINEA_PIG_ENTITY.get()).m_20615_((Level)serverLevel);
            int k = this.f_19796_.m_188503_(5);
            int breed = k < 2 ? this.getBreed() : (k < 4 ? partner.getBreed() : this.f_19796_.m_188503_(Breed.values().length));
            int i = this.f_19796_.m_188503_(9);
            int variant = 0;
            if (partner.getVariant() != 12 && this.getVariant() != 12) {
                variant = i < 4 ? this.getVariant() : (i < 8 ? partner.getVariant() : this.f_19796_.m_188503_(GuineaPigModel.Variant.values().length - 1));
            } else if (baby.getBreed() == 2) {
                baby.setVariant(12);
            } else {
                variant = this.f_19796_.m_188503_(GuineaPigModel.Variant.values().length - 1);
            }
            int j = this.f_19796_.m_188503_(5);
            int overlay = j < 2 ? this.getOverlayVariant() : (j < 4 ? partner.getOverlayVariant() : this.f_19796_.m_188503_(GuineaPigMarkingLayer.Overlay.values().length));
            int l = this.f_19796_.m_188503_(5);
            int eye = l < 2 ? this.getEyeVariant() : (l < 4 ? partner.getEyeVariant() : this.f_19796_.m_188503_(GuineaPigEyeLayer.Overlay.values().length));
            baby.setVariant(variant);
            baby.setOverlayVariant(overlay);
            baby.setEyeVariant(eye);
            baby.setBreed(breed);
            baby.setGender(this.f_19796_.m_188503_(Gender.values().length));
            if (baby.getBreed() == 2) {
                baby.setVariant(12);
            }
        }
        return baby;
    }

    public void m_7472_(DamageSource source, int i, boolean b) {
        super.m_7472_(source, i, b);
        Random random = new Random();
        if (this.getBreed() == 4) {
            if (random.nextDouble() < 0.4) {
                this.m_20000_((ItemLike)GGPItems.GUINEA_PIG.get(), 2);
                this.m_20000_((ItemLike)GGPItems.GUINEA_PIG_HIDE.get(), 2);
            } else if (random.nextDouble() > 0.4) {
                this.m_19998_((ItemLike)GGPItems.GUINEA_PIG.get());
                this.m_19998_((ItemLike)GGPItems.GUINEA_PIG_HIDE.get());
            }
        }
    }

    public static enum Gender {
        FEMALE,
        MALE;

    }

    public static enum Breed {
        DEFAULT(new ResourceLocation("giddypigs", "geo/guinea_pig.geo.json")),
        FLUFFY(new ResourceLocation("giddypigs", "geo/fluffy.geo.json")),
        BALDWIN(new ResourceLocation("giddypigs", "geo/guinea_pig.geo.json")),
        PERUVIAN(new ResourceLocation("giddypigs", "geo/peruvian.geo.json")),
        CUY(new ResourceLocation("giddypigs", "geo/cuy.geo.json"));

        public final ResourceLocation resourceLocation;

        private Breed(ResourceLocation resourceLocation) {
            this.resourceLocation = resourceLocation;
        }

        public static Breed breedFromOrdinal(int ordinal) {
            return Breed.values()[ordinal % Breed.values().length];
        }
    }
}

