/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.giddypigs.entities;

import com.dragn0007.giddypigs.entities.GuineaPig;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class GuineaPigModel
extends DefaultedEntityGeoModel<GuineaPig> {
    public static final ResourceLocation ANIMATION = new ResourceLocation("giddypigs", "animations/guinea_pig.animation.json");

    public GuineaPigModel() {
        super(new ResourceLocation("giddypigs", "guinea_pig"), true);
    }

    public void setCustomAnimations(GuineaPig animatable, long instanceId, AnimationState<GuineaPig> animationState) {
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        if (head != null) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(head.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            float maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            head.setRotY(head.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
    }

    public ResourceLocation getModelResource(GuineaPig object) {
        return GuineaPig.Breed.breedFromOrdinal((int)object.getBreed()).resourceLocation;
    }

    public ResourceLocation getTextureResource(GuineaPig object) {
        return object.getTextureLocation();
    }

    public ResourceLocation getAnimationResource(GuineaPig animatable) {
        return ANIMATION;
    }

    public static enum Variant {
        BLACK(new ResourceLocation("giddypigs", "textures/guinea_pig/black.png")),
        BLUE(new ResourceLocation("giddypigs", "textures/guinea_pig/blue.png")),
        BROWN(new ResourceLocation("giddypigs", "textures/guinea_pig/brown.png")),
        CHOCOLATE(new ResourceLocation("giddypigs", "textures/guinea_pig/chocolate.png")),
        CREAM(new ResourceLocation("giddypigs", "textures/guinea_pig/cream.png")),
        GOLD(new ResourceLocation("giddypigs", "textures/guinea_pig/gold.png")),
        LILAC(new ResourceLocation("giddypigs", "textures/guinea_pig/lilac.png")),
        MAHOGANY(new ResourceLocation("giddypigs", "textures/guinea_pig/mahogany.png")),
        RED(new ResourceLocation("giddypigs", "textures/guinea_pig/red.png")),
        SILVER(new ResourceLocation("giddypigs", "textures/guinea_pig/silver.png")),
        TAN(new ResourceLocation("giddypigs", "textures/guinea_pig/tan.png")),
        WHITE(new ResourceLocation("giddypigs", "textures/guinea_pig/white.png")),
        HAIRLESS(new ResourceLocation("giddypigs", "textures/guinea_pig/hairless.png"));

        public final ResourceLocation resourceLocation;

        private Variant(ResourceLocation resourceLocation) {
            this.resourceLocation = resourceLocation;
        }

        public static Variant variantFromOrdinal(int variant) {
            return Variant.values()[variant % Variant.values().length];
        }
    }
}

