/*
 * Decompiled with CFR 0.152.
 */
package net.blank.chest_transport_reloaded;

import com.mojang.logging.LogUtils;
import net.blank.chest_transport_reloaded.blocks.CustomBlocks;
import net.blank.chest_transport_reloaded.creativetab.CustomCreativeTab;
import net.blank.chest_transport_reloaded.items.CustomItems;
import net.minecraft.client.Minecraft;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="chest_transport_reloaded")
public class ChestTransportReloaded {
    public static final String MOD_ID = "chest_transport_reloaded";
    private static final Logger LOGGER = LogUtils.getLogger();

    public ChestTransportReloaded(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        CustomItems.register(modEventBus);
        CustomBlocks.register(modEventBus);
        CustomCreativeTab.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256968_) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @Mod.EventBusSubscriber(modid="chest_transport_reloaded", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public class ForgeClientEvents {
        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
            Player player = event.player;
            if (!player.m_9236_().f_46443_) {
                int chestTransporterCount = 0;
                for (ItemStack item : player.m_150109_().f_35974_) {
                    if (item.m_41784_().m_128469_("chest_nbt").m_128456_()) continue;
                    ++chestTransporterCount;
                }
                if (chestTransporterCount > 0) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 22, 1, false, true));
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 22, 1 + chestTransporterCount, false, true));
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 22, 1 + chestTransporterCount, false, true));
                }
            }
        }

        @SubscribeEvent
        public static void onLivingJump(LivingEvent.LivingJumpEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                if (!player.m_9236_().f_46443_) {
                    int chestTransporterCount = 0;
                    for (ItemStack item : player.m_150109_().f_35974_) {
                        if (item.m_41784_().m_128469_("chest_nbt").m_128456_()) continue;
                        ++chestTransporterCount;
                    }
                    System.out.print(chestTransporterCount);
                    if (chestTransporterCount > 0) {
                        player.m_20334_(player.m_20184_().f_82479_, player.m_20184_().f_82480_ * (1.0 - (double)chestTransporterCount * 0.1), player.m_20184_().f_82481_);
                    }
                }
            }
        }
    }

    @Mod.EventBusSubscriber(modid="chest_transport_reloaded", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("HELLO FROM CLIENT SETUP");
            LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.m_91087_().m_91094_().m_92546_());
        }
    }
}

