/*
 * Decompiled with CFR 0.152.
 */
package net.blank.chest_transport_reloaded.items.advancecdItems;

import net.blank.chest_transport_reloaded.items.advancecdItems.ChestTransporterMaterial;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ChestTransporter
extends Item {
    private final ChestTransporterMaterial transporterMaterial;

    public ChestTransporter(ChestTransporterMaterial material) {
        super(new Item.Properties().m_41503_(material.durability));
        this.transporterMaterial = material;
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return this.transporterMaterial.repairItem == Items.f_41852_ ? false : repair.m_150930_(this.transporterMaterial.repairItem);
    }

    public boolean m_5812_(ItemStack stack) {
        return stack.m_41783_() != null && stack.m_41783_().m_128441_("chest_nbt");
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        ItemStack stack = pContext.m_43722_();
        CompoundTag itemTag = stack.m_41784_();
        if (pContext.m_43725_().m_5776_()) {
            return InteractionResult.FAIL;
        }
        BlockPos pos = pContext.m_8083_();
        Direction face = pContext.m_43719_();
        Level level = pContext.m_43725_();
        Player player = pContext.m_43723_();
        InteractionHand iHand = pContext.m_43724_();
        CompoundTag chestTag = itemTag.m_128469_("chest_nbt");
        if (!chestTag.m_128456_()) {
            BlockPos newPos = null;
            switch (face) {
                case UP: {
                    newPos = pos.m_6630_(1);
                    break;
                }
                case DOWN: {
                    newPos = pos.m_6625_(1);
                    break;
                }
                case EAST: {
                    newPos = pos.m_122030_(1);
                    break;
                }
                case WEST: {
                    newPos = pos.m_122025_(1);
                    break;
                }
                case SOUTH: {
                    newPos = pos.m_122020_(1);
                    break;
                }
                case NORTH: {
                    newPos = pos.m_122013_(1);
                }
            }
            if (!level.m_8055_(newPos).m_60795_() && !level.m_8055_(newPos).m_247087_()) {
                return InteractionResult.FAIL;
            }
            chestTag.m_128405_("x", newPos.m_123341_());
            chestTag.m_128405_("y", newPos.m_123342_());
            chestTag.m_128405_("z", newPos.m_123343_());
            BlockState state = this.getBlockState(stack, level);
            BlockState newState = state.m_60734_().m_5573_(new BlockPlaceContext(pContext));
            level.m_7731_(newPos, newState, 3);
            BlockEntity newEntity = level.m_7702_(newPos);
            newEntity.m_142466_(chestTag);
            newEntity.m_6596_();
            itemTag.m_128473_("chest_nbt");
            itemTag.m_128473_("chest_state_nbt");
            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(iHand));
            return InteractionResult.SUCCESS;
        }
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        BlockEntity levelBlockEntity = level.m_7702_(pos);
        if (levelBlockEntity != null && (block == Blocks.f_50087_ || block == Blocks.f_50618_)) {
            CompoundTag newTag = levelBlockEntity.m_187480_();
            level.m_46747_(pos);
            level.m_7471_(pos, false);
            itemTag.m_128365_("chest_nbt", (Tag)newTag);
            itemTag.m_128365_("chest_state_nbt", (Tag)NbtUtils.m_129202_((BlockState)state));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public BlockState getBlockState(ItemStack stack, Level level) {
        CompoundTag tagItem = stack.m_41783_();
        if (tagItem != null && tagItem.m_128425_("chest_state_nbt", 10)) {
            CompoundTag stateTag = tagItem.m_128469_("chest_state_nbt");
            HolderLookup blockGetter = level.m_246945_(Registries.f_256747_);
            return NbtUtils.m_247651_((HolderGetter)blockGetter, (CompoundTag)stateTag);
        }
        return Blocks.f_50016_.m_49966_();
    }
}

