/*
 * Decompiled with CFR 0.152.
 */
package net.flare.mcMails.command;

import java.util.UUID;
import net.flare.mcMails.MCMails;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BlockCommand
implements CommandExecutor {
    private final MCMails plugin = MCMails.getInstance();

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("mcmails.use")) {
            player.sendMessage(this.plugin.getConfigUtil().getFormattedMessage("messages.no-permission"));
            return true;
        }
        if (args.length != 1) {
            player.sendMessage("Usage: /block <player>");
            return true;
        }
        String targetName = args[0];
        OfflinePlayer targetPlayer = Bukkit.getOfflinePlayerIfCached((String)targetName);
        if (targetPlayer == null) {
            targetPlayer = Bukkit.getOfflinePlayer((String)targetName);
        }
        if (targetPlayer == null || targetPlayer.getUniqueId() == null) {
            player.sendMessage(this.plugin.getConfigUtil().colorize("&cPlayer not found."));
            return true;
        }
        UUID blockerUUID = player.getUniqueId();
        UUID blockedUUID = targetPlayer.getUniqueId();
        boolean currentlyBlocked = this.plugin.getSqliteManager().isBlocked(blockerUUID, blockedUUID);
        if (currentlyBlocked) {
            this.plugin.getSqliteManager().unblockPlayer(blockerUUID, blockedUUID);
            player.sendMessage(this.plugin.getConfigUtil().colorize("&aYou have unblocked " + targetName));
        } else {
            this.plugin.getSqliteManager().blockPlayer(blockerUUID, blockedUUID);
            player.sendMessage(this.plugin.getConfigUtil().colorize("&cYou have blocked " + targetName));
        }
        return true;
    }
}

