/*
 * Decompiled with CFR 0.152.
 */
package net.flare.mcMails.command;

import java.util.UUID;
import net.flare.mcMails.MCMails;
import net.flare.mcMails.model.Mail;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MailCommand
implements CommandExecutor {
    private final MCMails plugin = MCMails.getInstance();

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("mcmails.use")) {
            player.sendMessage(this.plugin.getConfigUtil().getFormattedMessage("messages.no-permission"));
            return true;
        }
        if (args.length < 2) {
            player.sendMessage("Usage: /mail <player> <message>");
            return true;
        }
        String targetName = args[0];
        OfflinePlayer targetPlayer = Bukkit.getOfflinePlayerIfCached((String)targetName);
        if (targetPlayer == null) {
            targetPlayer = Bukkit.getOfflinePlayer((String)targetName);
        }
        if (targetPlayer == null || targetPlayer.getUniqueId() == null) {
            player.sendMessage(this.plugin.getConfigUtil().colorize("&cPlayer not found."));
            return true;
        }
        UUID senderUUID = player.getUniqueId();
        UUID receiverUUID = targetPlayer.getUniqueId();
        if (this.plugin.getSqliteManager().isBlocked(receiverUUID, senderUUID)) {
            player.sendMessage(this.plugin.getConfigUtil().getFormattedMessage("messages.mail-blocked"));
            return true;
        }
        String message = String.join((CharSequence)" ", args).substring(args[0].length()).trim();
        Mail mail = new Mail(senderUUID, receiverUUID, this.plugin.getConfigUtil().colorize(message), System.currentTimeMillis(), false);
        this.plugin.getSqliteManager().saveMail(mail);
        player.sendMessage(this.plugin.getConfigUtil().getFormattedMessage("messages.mail-sent"));
        return true;
    }
}

