/*
 * Decompiled with CFR 0.152.
 */
package net.flare.mcMails.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.flare.mcMails.MCMails;
import net.flare.mcMails.model.Mail;

public class SQLiteManager {
    private final MCMails plugin;
    private Connection connection;

    public SQLiteManager(MCMails plugin) {
        this.plugin = plugin;
    }

    public void connect() {
        try {
            String url = "jdbc:sqlite:" + String.valueOf(this.plugin.getDataFolder()) + "/mails.db";
            this.connection = DriverManager.getConnection(url);
            this.createTables();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void createTables() throws SQLException {
        String mailsTable = "CREATE TABLE IF NOT EXISTS mails (id INTEGER PRIMARY KEY AUTOINCREMENT,sender UUID NOT NULL,receiver UUID NOT NULL,message TEXT NOT NULL,timestamp INTEGER NOT NULL,delivered BOOLEAN NOT NULL DEFAULT 0);";
        String blocksTable = "CREATE TABLE IF NOT EXISTS blocks (blocker UUID NOT NULL,blocked UUID NOT NULL,PRIMARY KEY (blocker, blocked));";
        try (Statement stmt = this.connection.createStatement();){
            stmt.execute(mailsTable);
            stmt.execute(blocksTable);
        }
    }

    public void disconnect() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void saveMail(Mail mail) {
        String sql = "INSERT INTO mails(sender, receiver, message, timestamp, delivered) VALUES(?,?,?,?,0)";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, mail.getSender().toString());
            pstmt.setString(2, mail.getReceiver().toString());
            pstmt.setString(3, mail.getMessage());
            pstmt.setLong(4, mail.getTimestamp());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public List<Mail> getUndeliveredMails(UUID receiver) {
        ArrayList<Mail> mails = new ArrayList<Mail>();
        String sql = "SELECT * FROM mails WHERE receiver = ? AND delivered = 0 ORDER BY timestamp ASC";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, receiver.toString());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Mail mail = new Mail(UUID.fromString(rs.getString("sender")), UUID.fromString(rs.getString("receiver")), rs.getString("message"), rs.getLong("timestamp"), rs.getBoolean("delivered"));
                mails.add(mail);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return mails;
    }

    public void markMailDelivered(Mail mail) {
        String sql = "UPDATE mails SET delivered = 1 WHERE sender = ? AND receiver = ? AND timestamp = ?";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, mail.getSender().toString());
            pstmt.setString(2, mail.getReceiver().toString());
            pstmt.setLong(3, mail.getTimestamp());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void blockPlayer(UUID blocker, UUID blocked) {
        String sql = "INSERT OR IGNORE INTO blocks(blocker, blocked) VALUES(?,?)";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, blocker.toString());
            pstmt.setString(2, blocked.toString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void unblockPlayer(UUID blocker, UUID blocked) {
        String sql = "DELETE FROM blocks WHERE blocker = ? AND blocked = ?";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, blocker.toString());
            pstmt.setString(2, blocked.toString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public boolean isBlocked(UUID blocker, UUID blocked) {
        boolean bl;
        block8: {
            String sql = "SELECT 1 FROM blocks WHERE blocker = ? AND blocked = ? LIMIT 1";
            PreparedStatement pstmt = this.connection.prepareStatement(sql);
            try {
                pstmt.setString(1, blocker.toString());
                pstmt.setString(2, blocked.toString());
                ResultSet rs = pstmt.executeQuery();
                bl = rs.next();
                if (pstmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            pstmt.close();
        }
        return bl;
    }
}

