/*
 * Decompiled with CFR 0.152.
 */
package net.flare.mcMails.listener;

import java.util.List;
import java.util.UUID;
import net.flare.mcMails.MCMails;
import net.flare.mcMails.model.Mail;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

public class PlayerJoinListener
implements Listener {
    private final MCMails plugin = MCMails.getInstance();

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID receiverUUID = player.getUniqueId();
        List<Mail> mails = this.plugin.getSqliteManager().getUndeliveredMails(receiverUUID);
        if (mails.isEmpty()) {
            return;
        }
        String prefix = this.plugin.getConfigUtil().colorize(this.plugin.getConfigUtil().getLangString("messages.prefix"));
        for (Mail mail : mails) {
            String senderName = this.plugin.getServer().getOfflinePlayer(mail.getSender()).getName();
            if (senderName == null) {
                senderName = "Unknown";
            }
            String message = this.plugin.getConfigUtil().colorize(this.plugin.getConfigUtil().getLangString("messages.mail-received")).replace("{sender}", senderName).replace("{message}", mail.getMessage());
            player.sendMessage(prefix + message);
            this.plugin.getSqliteManager().markMailDelivered(mail);
        }
    }
}

