/*
 * Decompiled with CFR 0.152.
 */
package net.flare.mcMails.util;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.flare.mcMails.MCMails;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigUtil {
    private final MCMails plugin;
    private FileConfiguration config;
    private FileConfiguration lang;
    private static final Pattern HEX_PATTERN = Pattern.compile("&#([A-Fa-f0-9]{6})");

    public ConfigUtil(MCMails plugin) {
        this.plugin = plugin;
        this.reloadConfig();
    }

    public void reloadConfig() {
        this.config = this.plugin.getConfig();
        File langFile = new File(this.plugin.getDataFolder(), "lang.yml");
        this.lang = YamlConfiguration.loadConfiguration((File)langFile);
    }

    public String getConfigString(String path) {
        return this.config.getString(path, "");
    }

    public String getLangString(String path) {
        return this.lang.getString(path, "");
    }

    public String colorize(String input) {
        if (input == null) {
            return "";
        }
        Matcher matcher = HEX_PATTERN.matcher(input);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String hex = matcher.group(1);
            matcher.appendReplacement(buffer, net.md_5.bungee.api.ChatColor.of((String)("#" + hex)).toString());
        }
        matcher.appendTail(buffer);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)buffer.toString());
    }

    public String getFormattedMessage(String path) {
        String prefix = this.colorize(this.getLangString("messages.prefix"));
        String msg = this.colorize(this.getLangString(path));
        return prefix + msg;
    }
}

