/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.inventorysorter;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import net.kyrptonaught.inventorysorter.InventorySorterMod;
import net.kyrptonaught.inventorysorter.SortCases;
import net.kyrptonaught.inventorysorter.SortType;
import net.kyrptonaught.inventorysorter.network.PlayerSortPrevention;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2614;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_481;
import net.minecraft.class_7923;

public class InventoryHelper {
    public static final double MAX_LOOKUP_DISTANCE = 6.0;
    private static class_2960 lastCheckedId;
    private static long lastCheckedTimestamp;
    private static final long TIMEOUT_MS = 300000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T withTargetedScreenHandler(class_3222 player, Function<ScreenContext, T> action) {
        class_239 hit = player.method_5745(6.0, 1.0f, false);
        if (!(hit instanceof class_3965)) {
            return null;
        }
        class_3965 blockHit = (class_3965)hit;
        class_2338 blockPos = blockHit.method_17777();
        class_1937 world = player.method_37908();
        class_2680 blockState = world.method_8320(blockPos);
        class_1263 inventory = null;
        class_3908 namedScreenHandlerFactory = null;
        if (blockState.method_31709()) {
            class_2586 blockEntity = world.method_8321(blockPos);
            inventory = class_2614.method_11250((class_1937)world, (class_2338)blockPos);
            namedScreenHandlerFactory = blockState.method_26196(world, blockPos);
            if (namedScreenHandlerFactory == null && blockEntity instanceof class_3908) {
                namedScreenHandlerFactory = (class_3908)blockEntity;
            }
        } else {
            namedScreenHandlerFactory = blockState.method_26196(world, blockPos);
        }
        if (namedScreenHandlerFactory == null) {
            return null;
        }
        OptionalInt syncId = player.method_17355(namedScreenHandlerFactory);
        if (syncId.isEmpty()) {
            return null;
        }
        class_1703 screenHandler = namedScreenHandlerFactory.createMenu(syncId.getAsInt(), player.method_31548(), (class_1657)player);
        try {
            class_2960 id = class_7923.field_41187.method_10221((Object)screenHandler.method_17358());
            if (id == null) {
                T t = null;
                return t;
            }
            T t = action.apply(new ScreenContext(screenHandler, id, inventory));
            return t;
        }
        catch (Exception e) {
            T t = null;
            return t;
        }
        finally {
            player.method_7346();
            screenHandler.method_7595((class_1657)player);
        }
    }

    public static class_2561 sortTargetedBlock(class_3222 player, SortType sortType) {
        Boolean result = InventoryHelper.withTargetedScreenHandler(player, context -> {
            if (context.inventory == null) {
                return false;
            }
            if (InventoryHelper.canSortInventory((class_1657)player, context.handler)) {
                String languageCode = player.method_53823().comp_1951().toLowerCase();
                InventoryHelper.sortInventory(context.inventory, 0, context.inventory.method_5439(), sortType, languageCode);
                return true;
            }
            return false;
        });
        if (result == null) {
            return class_2561.method_43471((String)"inventorysorter.cmd.sort.error");
        }
        if (result.booleanValue()) {
            return class_2561.method_43471((String)"inventorysorter.cmd.sort.sorted");
        }
        return class_2561.method_43471((String)"inventorysorter.cmd.sort.notsortable");
    }

    public static boolean sortInventory(class_3222 player, boolean shouldSortPlayerInventory, SortType sortType) {
        class_1263 inv;
        String languageCode = player.method_53823().comp_1951().toLowerCase();
        if (shouldSortPlayerInventory) {
            InventoryHelper.sortInventory((class_1263)player.method_31548(), 9, 27, sortType, languageCode);
            return true;
        }
        if (InventoryHelper.canSortInventory((class_1657)player) && (inv = InventoryHelper.getInventory(player.field_7512)) != null) {
            InventoryHelper.sortInventory(inv, 0, inv.method_5439(), sortType, languageCode);
            return true;
        }
        return false;
    }

    public static class_1263 getInventory(class_1703 screenHandler) {
        if (screenHandler.field_7761.isEmpty()) {
            return null;
        }
        return ((class_1735)screenHandler.field_7761.getFirst()).field_7871;
    }

    private static void sortInventory(class_1263 inv, int startSlot, int invSize, SortType sortType, String languageCode) {
        int i;
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        for (i = 0; i < invSize; ++i) {
            InventoryHelper.addStackWithMerge(stacks, inv.method_5438(startSlot + i));
        }
        stacks.sort(SortCases.getComparator(sortType, languageCode));
        if (stacks.size() == 0) {
            return;
        }
        for (i = 0; i < invSize; ++i) {
            inv.method_5447(startSlot + i, i < stacks.size() ? (class_1799)stacks.get(i) : class_1799.field_8037);
        }
        inv.method_5431();
    }

    private static void addStackWithMerge(List<class_1799> stacks, class_1799 newStack) {
        if (newStack.method_7909() == class_1802.field_8162) {
            return;
        }
        if (newStack.method_7946() && newStack.method_7947() != newStack.method_7914()) {
            for (int j = stacks.size() - 1; j >= 0; --j) {
                class_1799 oldStack = stacks.get(j);
                if (!InventoryHelper.canMergeItems(newStack, oldStack)) continue;
                InventoryHelper.combineStacks(newStack, oldStack);
                if (oldStack.method_7909() != class_1802.field_8162 && oldStack.method_7947() != 0) continue;
                stacks.remove(j);
            }
        }
        stacks.add(newStack);
    }

    private static void combineStacks(class_1799 stack, class_1799 stack2) {
        if (stack.method_7914() >= stack.method_7947() + stack2.method_7947()) {
            stack.method_7933(stack2.method_7947());
            stack2.method_7939(0);
        }
        int maxInsertAmount = Math.min(stack.method_7914() - stack.method_7947(), stack2.method_7947());
        stack.method_7933(maxInsertAmount);
        stack2.method_7934(maxInsertAmount);
    }

    private static boolean canMergeItems(class_1799 itemStack_1, class_1799 itemStack_2) {
        if (!itemStack_1.method_7946() || !itemStack_2.method_7946()) {
            return false;
        }
        if (itemStack_1.method_7947() == itemStack_1.method_7914() || itemStack_2.method_7947() == itemStack_2.method_7914()) {
            return false;
        }
        if (itemStack_1.method_7909() != itemStack_2.method_7909()) {
            return false;
        }
        if (itemStack_1.method_7919() != itemStack_2.method_7919()) {
            return false;
        }
        return class_1799.method_31577((class_1799)itemStack_1, (class_1799)itemStack_2);
    }

    public static boolean shouldDisplayButtons(class_1657 player) {
        if (player.field_7512 == null || !player.field_7512.method_7597(player)) {
            return false;
        }
        if (player.field_7512 instanceof class_1723) {
            return true;
        }
        if (player.field_7512 instanceof class_481.class_483) {
            return true;
        }
        try {
            class_2960 id = class_7923.field_41187.method_10221((Object)player.field_7512.method_17358());
            if (id == null) {
                return false;
            }
            InventoryHelper.setLastChecked(id);
            return InventorySorterMod.compatibility.shouldShowSortButton(id);
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }

    public static boolean canSortInventory(class_1657 player) {
        if (player.field_7512 instanceof class_1723) {
            return false;
        }
        return InventoryHelper.canSortInventory(player, player.field_7512);
    }

    public static boolean canSortInventory(class_1657 player, class_1703 screenHandler) {
        if (screenHandler == null || !screenHandler.method_7597(player)) {
            return false;
        }
        if (player.method_7325()) {
            return false;
        }
        try {
            class_2960 id = class_7923.field_41187.method_10221((Object)screenHandler.method_17358());
            if (id == null) {
                return false;
            }
            return InventoryHelper.isSortableContainer(player, screenHandler, id);
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }

    private static boolean isSortableContainer(class_1657 player, class_1703 screenHandler, class_2960 screenID) {
        PlayerSortPrevention playerSortPrevention = (PlayerSortPrevention)player.getAttachedOrCreate(InventorySorterMod.PLAYER_SORT_PREVENTION);
        if (!InventorySorterMod.compatibility.isSortAllowed(screenID, playerSortPrevention.preventSortForScreens())) {
            return false;
        }
        int numSlots = screenHandler.field_7761.size();
        if (numSlots <= 36) {
            return false;
        }
        return numSlots - 36 >= 9;
    }

    private static void setLastChecked(class_2960 id) {
        lastCheckedId = id;
        lastCheckedTimestamp = System.currentTimeMillis();
    }

    public static Optional<class_2960> getLastCheckedId() {
        if (lastCheckedId != null && System.currentTimeMillis() - lastCheckedTimestamp > 300000L) {
            lastCheckedId = null;
        }
        return Optional.ofNullable(lastCheckedId);
    }

    public record ScreenContext(class_1703 handler, class_2960 screenId, class_1263 inventory) {
    }
}

