/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.inventorysorter.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.kyrptonaught.inventorysorter.InventoryHelper;
import net.kyrptonaught.inventorysorter.InventorySorterMod;
import net.kyrptonaught.inventorysorter.commands.CommandTranslations;
import net.kyrptonaught.inventorysorter.config.NewConfigOptions;
import net.kyrptonaught.inventorysorter.network.HideButton;
import net.kyrptonaught.inventorysorter.permissions.CommandPermission;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class AdminCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher, LiteralArgumentBuilder<class_2168> rootCommand) {
        LiteralArgumentBuilder admin = (LiteralArgumentBuilder)class_2170.method_9247((String)"admin").requires(CommandPermission.hasAny("admin.reload", "admin.nosort", "admin.nosort.add", "admin.nosort.remove", "admin.nosort.list", "admin.hidebutton", "admin.hidebutton.add", "admin.hidebutton.remove", "admin.hidebutton.list", "admin.remote", "admin.remote.set", "admin.remote.clear", "admin.remote.show").or(CommandPermission.require("admin", 2)));
        dispatcher.register((LiteralArgumentBuilder)rootCommand.then(admin.then(class_2170.method_9247((String)"nosort").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(CommandPermission.require("admin.nosort.add", 2))).executes(AdminCommands::nosortAdd)))));
        dispatcher.register((LiteralArgumentBuilder)rootCommand.then(admin.then(class_2170.method_9247((String)"nosort").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(CommandPermission.require("admin.nosort.remove", 2))).executes(AdminCommands::nosortRemove)))));
        dispatcher.register((LiteralArgumentBuilder)rootCommand.then(admin.then(class_2170.method_9247((String)"nosort").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(CommandPermission.require("admin.nosort.list", 2))).executes(AdminCommands::nosortList)))));
        dispatcher.register((LiteralArgumentBuilder)rootCommand.then(admin.then(class_2170.method_9247((String)"hidebutton").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(CommandPermission.require("admin.hidebutton.add", 2))).executes(AdminCommands::hidebuttonAdd)))));
        dispatcher.register((LiteralArgumentBuilder)rootCommand.then(admin.then(class_2170.method_9247((String)"hidebutton").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(CommandPermission.require("admin.hidebutton.remove", 2))).executes(AdminCommands::hidebuttonRemove)))));
        dispatcher.register((LiteralArgumentBuilder)rootCommand.then(admin.then(class_2170.method_9247((String)"hidebutton").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(CommandPermission.require("admin.hidebutton.list", 2))).executes(AdminCommands::hidebuttonList)))));
        dispatcher.register((LiteralArgumentBuilder)rootCommand.then(admin.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(CommandPermission.require("admin.reload", 2))).executes(AdminCommands::reload))));
        dispatcher.register((LiteralArgumentBuilder)rootCommand.then(admin.then(class_2170.method_9247((String)"remote").then(class_2170.method_9247((String)"set").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"url", (ArgumentType)StringArgumentType.string()).requires(CommandPermission.require("admin.remote.set", 2))).executes(AdminCommands::remoteSet))))));
        dispatcher.register((LiteralArgumentBuilder)rootCommand.then(admin.then(class_2170.method_9247((String)"remote").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear").requires(CommandPermission.require("admin.remote.clear", 2))).executes(AdminCommands::remoteClear)))));
        dispatcher.register((LiteralArgumentBuilder)rootCommand.then(admin.then(class_2170.method_9247((String)"remote").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"show").requires(CommandPermission.require("admin.remote.show", 2))).executes(AdminCommands::remoteShow)))));
    }

    public static int nosortAdd(CommandContext<class_2168> commandContext) {
        class_3222 player = ((class_2168)commandContext.getSource()).method_44023();
        if (player == null) {
            ((class_2168)commandContext.getSource()).method_9226(CommandTranslations::playerRequired, false);
            return 0;
        }
        Boolean success = InventoryHelper.withTargetedScreenHandler(player, context -> {
            NewConfigOptions config = InventorySorterMod.getConfig();
            config.disableSortForScreen(context.screenId().toString());
            config.save();
            InventorySorterMod.compatibility.reload();
            return true;
        });
        if (Boolean.FALSE.equals(success)) {
            ((class_2168)commandContext.getSource()).method_9226(() -> class_2561.method_43471((String)"inventorysorter.cmd.nosort.add.fail"), false);
            return 0;
        }
        ((class_2168)commandContext.getSource()).method_9226(() -> class_2561.method_43471((String)"inventorysorter.cmd.nosort.add.success"), false);
        return 1;
    }

    public static int nosortRemove(CommandContext<class_2168> commandContext) {
        class_3222 player = ((class_2168)commandContext.getSource()).method_44023();
        if (player == null) {
            ((class_2168)commandContext.getSource()).method_9226(CommandTranslations::playerRequired, false);
            return 0;
        }
        Boolean success = InventoryHelper.withTargetedScreenHandler(player, context -> {
            NewConfigOptions config = InventorySorterMod.getConfig();
            config.enableSortForScreen(context.screenId().toString());
            config.save();
            InventorySorterMod.compatibility.reload();
            return true;
        });
        if (Boolean.FALSE.equals(success)) {
            ((class_2168)commandContext.getSource()).method_9226(() -> class_2561.method_43471((String)"inventorysorter.cmd.nosort.remove.fail"), false);
            return 0;
        }
        ((class_2168)commandContext.getSource()).method_9226(() -> class_2561.method_43471((String)"inventorysorter.cmd.nosort.remove.success"), false);
        return 1;
    }

    public static int nosortList(CommandContext<class_2168> commandContext) {
        NewConfigOptions config = InventorySorterMod.getConfig();
        ((class_2168)commandContext.getSource()).method_9226(() -> class_2561.method_43469((String)"inventorysorter.cmd.nosort.list", (Object[])new Object[]{String.join((CharSequence)",", config.preventSortForScreens)}), false);
        return 1;
    }

    public static int hidebuttonAdd(CommandContext<class_2168> commandContext) {
        class_3222 player = ((class_2168)commandContext.getSource()).method_44023();
        if (player == null) {
            ((class_2168)commandContext.getSource()).method_9226(CommandTranslations::playerRequired, false);
            return 0;
        }
        Boolean success = InventoryHelper.withTargetedScreenHandler(player, context -> {
            NewConfigOptions config = InventorySorterMod.getConfig();
            config.disableButtonForScreen(context.screenId().toString());
            config.save();
            InventorySorterMod.compatibility.reload();
            return true;
        });
        if (Boolean.FALSE.equals(success)) {
            ((class_2168)commandContext.getSource()).method_9226(() -> class_2561.method_43471((String)"inventorysorter.cmd.hideButton.add.fail"), false);
            return 0;
        }
        HideButton.fromConfig(InventorySorterMod.getConfig()).sync(((class_2168)commandContext.getSource()).method_9211());
        ((class_2168)commandContext.getSource()).method_9226(() -> class_2561.method_43471((String)"inventorysorter.cmd.hideButton.add.success"), false);
        return 1;
    }

    public static int hidebuttonRemove(CommandContext<class_2168> commandContext) {
        class_3222 player = ((class_2168)commandContext.getSource()).method_44023();
        if (player == null) {
            ((class_2168)commandContext.getSource()).method_9226(CommandTranslations::playerRequired, false);
            return 0;
        }
        Boolean success = InventoryHelper.withTargetedScreenHandler(player, context -> {
            NewConfigOptions config = InventorySorterMod.getConfig();
            config.enableButtonForScreen(context.screenId().toString());
            config.save();
            InventorySorterMod.compatibility.reload();
            return true;
        });
        if (Boolean.FALSE.equals(success)) {
            ((class_2168)commandContext.getSource()).method_9226(() -> class_2561.method_43471((String)"inventorysorter.cmd.hideButton.remove.fail"), false);
            return 0;
        }
        HideButton.fromConfig(InventorySorterMod.getConfig()).sync(((class_2168)commandContext.getSource()).method_9211());
        ((class_2168)commandContext.getSource()).method_9226(() -> class_2561.method_43471((String)"inventorysorter.cmd.hideButton.remove.success"), false);
        return 1;
    }

    public static int hidebuttonList(CommandContext<class_2168> commandContext) {
        NewConfigOptions config = InventorySorterMod.getConfig();
        ((class_2168)commandContext.getSource()).method_9226(() -> class_2561.method_43469((String)"inventorysorter.cmd.hideButton.list", (Object[])new Object[]{String.join((CharSequence)",", config.hideButtonsForScreens)}), false);
        return 1;
    }

    public static int remoteSet(CommandContext<class_2168> commandContext) {
        String url = StringArgumentType.getString(commandContext, (String)"url");
        NewConfigOptions config = InventorySorterMod.getConfig();
        config.customCompatibilityListDownloadUrl = url;
        config.save();
        InventorySorterMod.reloadConfig();
        ((class_2168)commandContext.getSource()).method_9226(() -> class_2561.method_43469((String)"inventorysorter.cmd.remote.set.success", (Object[])new Object[]{url}), false);
        return 1;
    }

    public static int remoteClear(CommandContext<class_2168> commandContext) {
        NewConfigOptions config = InventorySorterMod.getConfig();
        config.customCompatibilityListDownloadUrl = "";
        config.save();
        InventorySorterMod.reloadConfig();
        ((class_2168)commandContext.getSource()).method_9226(() -> class_2561.method_43471((String)"inventorysorter.cmd.remote.clear.success"), false);
        return 1;
    }

    public static int remoteShow(CommandContext<class_2168> commandContext) {
        NewConfigOptions config = InventorySorterMod.getConfig();
        ((class_2168)commandContext.getSource()).method_9226(() -> class_2561.method_43469((String)"inventorysorter.cmd.remote.show", (Object[])new Object[]{config.customCompatibilityListDownloadUrl}), false);
        return 1;
    }

    public static int reload(CommandContext<class_2168> commandContext) {
        InventorySorterMod.reloadConfig();
        ((class_2168)commandContext.getSource()).method_9226(() -> class_2561.method_43471((String)"inventorysorter.cmd.reload.success"), false);
        return 1;
    }
}

