/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.inventorysorter.compat;

import com.google.gson.Gson;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.kyrptonaught.inventorysorter.InventorySorterMod;
import net.kyrptonaught.inventorysorter.compat.sources.CompatibilityLoader;
import net.minecraft.class_2960;

public class Compatibility {
    Set<class_2960> shouldHideSortButtons = ConcurrentHashMap.newKeySet();
    Set<class_2960> shouldPreventSort = ConcurrentHashMap.newKeySet();
    List<CompatibilityLoader> loaders = new ArrayList<CompatibilityLoader>();

    public Compatibility(ArrayList<CompatibilityLoader> loaders) {
        this.loaders = loaders;
        this.load();
    }

    public void addLoader(CompatibilityLoader loader) {
        this.loaders.add(loader);
    }

    public void load() {
        for (CompatibilityLoader loader : this.loaders) {
            new Thread(() -> {
                try {
                    Set<class_2960> hideButtons = loader.getShouldHideSortButtons();
                    Set<class_2960> preventSort = loader.getPreventSort();
                    this.shouldHideSortButtons.addAll(hideButtons);
                    this.shouldPreventSort.addAll(preventSort);
                    InventorySorterMod.LOGGER.debug("Successfully loaded compatibility data from {}", (Object)loader.getClass().getSimpleName());
                }
                catch (Exception e) {
                    InventorySorterMod.LOGGER.error("Error loading compatibility data from {}", (Object)loader.getClass().getSimpleName(), (Object)e);
                }
            }).start();
        }
    }

    public void reload() {
        this.shouldHideSortButtons.clear();
        this.shouldPreventSort.clear();
        this.load();
    }

    public boolean shouldShowSortButton(class_2960 inventoryIdentifier) {
        return !this.shouldHideSortButtons.contains(inventoryIdentifier);
    }

    public boolean isSortAllowed(class_2960 inventoryIdentifier, Set<String> playerSortPrevention) {
        if (this.shouldPreventSort.contains(inventoryIdentifier)) {
            return false;
        }
        return !playerSortPrevention.contains(inventoryIdentifier.toString());
    }

    public void addShouldHideSortButton(String identifier) {
        this.shouldHideSortButtons.add(class_2960.method_60654((String)identifier));
    }

    public static Set<class_2960> parseJson(Reader fileInputStream) {
        String[] rawIdentifiers;
        HashSet<class_2960> identifiers = new HashSet<class_2960>();
        Gson gson = new Gson().newBuilder().create();
        for (String rawIdentifier : rawIdentifiers = (String[])gson.fromJson(fileInputStream, String[].class)) {
            class_2960 identifier = class_2960.method_60654((String)rawIdentifier);
            identifiers.add(identifier);
        }
        return identifiers;
    }
}

