/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.inventorysorter.compat.sources;

import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import net.kyrptonaught.inventorysorter.InventorySorterMod;
import net.kyrptonaught.inventorysorter.compat.Compatibility;
import net.kyrptonaught.inventorysorter.compat.sources.CompatibilityLoader;
import net.minecraft.class_2960;

public class OfficialListLoader
implements CompatibilityLoader {
    private static final String BASE_URL = "https://raw.githubusercontent.com/KyrptonaughtMC/Inventory-Sorter/refs/heads/main/src/main/resources/data/inventorysorter/";
    private static final String DO_NOT_SORT_FILE = "https://raw.githubusercontent.com/KyrptonaughtMC/Inventory-Sorter/refs/heads/main/src/main/resources/data/inventorysorter/do-not-sort.json";
    private static final String HIDE_SORT_BUTTONS_FILE = "https://raw.githubusercontent.com/KyrptonaughtMC/Inventory-Sorter/refs/heads/main/src/main/resources/data/inventorysorter/hide-buttons.json";

    @Override
    public Set<class_2960> getPreventSort() {
        return this.downloadIndividualList(DO_NOT_SORT_FILE);
    }

    @Override
    public Set<class_2960> getShouldHideSortButtons() {
        return this.downloadIndividualList(HIDE_SORT_BUTTONS_FILE);
    }

    protected Set<class_2960> downloadIndividualList(String URL2) {
        InventorySorterMod.LOGGER.debug("Loading compatibility data from: {}", (Object)URL2);
        try {
            URL url = URI.create(URL2).toURL();
            InputStreamReader reader = new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);
            return Compatibility.parseJson(reader);
        }
        catch (Exception e) {
            InventorySorterMod.LOGGER.error("Error downloading compatibility data from URL: {}", (Object)URL2);
            return new HashSet<class_2960>();
        }
    }
}

