/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.inventorysorter.e2e;

import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.booleans.Boolean2ObjectFunction;
import java.util.Map;
import java.util.UUID;
import java.util.function.IntFunction;
import net.kyrptonaught.inventorysorter.InventoryHelper;
import net.kyrptonaught.inventorysorter.SortType;
import net.kyrptonaught.inventorysorter.e2e.TestUtils;
import net.minecraft.class_10129;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_4516;
import net.minecraft.class_6302;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9275;
import net.minecraft.class_9296;
import net.minecraft.class_9326;
import net.minecraft.class_9334;

public class SortingTests {
    public static final String template = "fabric-gametest-api-v1:empty";

    @class_6302(method_35936="fabric-gametest-api-v1:empty")
    public void testSimpleStackable(class_4516 ctx) {
        TestUtils.Scenario scenario = TestUtils.setUpScene(ctx, Map.of(5, new class_1799((class_1935)class_1802.field_8477, 32), 6, new class_1799((class_1935)class_1802.field_8477, 32)));
        InventoryHelper.sortInventory(scenario.player(), false, SortType.NAME);
        TestUtils.assertContents(ctx, scenario, Map.of(0, new class_1799((class_1935)class_1802.field_8477, 64)));
        ctx.method_36036();
    }

    @class_6302(method_35936="fabric-gametest-api-v1:empty")
    public void testSimpleStackableWithLeftovers(class_4516 ctx) {
        TestUtils.Scenario scenario = TestUtils.setUpScene(ctx, Map.of(5, new class_1799((class_1935)class_1802.field_8477, 32), 6, new class_1799((class_1935)class_1802.field_8477, 33)));
        InventoryHelper.sortInventory(scenario.player(), false, SortType.NAME);
        TestUtils.assertContents(ctx, scenario, Map.of(0, new class_1799((class_1935)class_1802.field_8477, 64), 1, new class_1799((class_1935)class_1802.field_8477, 1)));
        ctx.method_36036();
    }

    @class_6302(method_35936="fabric-gametest-api-v1:empty")
    public void testSpectatorsCannotSort(class_4516 ctx) {
        TestUtils.Scenario scenario = TestUtils.setUpScene(ctx, Map.of(5, new class_1799((class_1935)class_1802.field_8477, 32), 6, new class_1799((class_1935)class_1802.field_8477, 33)), TestUtils.IS_SPECTATOR);
        class_3222 player = scenario.player();
        player.method_7336(class_1934.field_9219);
        InventoryHelper.sortInventory(player, false, SortType.NAME);
        TestUtils.assertContents(ctx, scenario, Map.of(5, new class_1799((class_1935)class_1802.field_8477, 32), 6, new class_1799((class_1935)class_1802.field_8477, 33)));
        ctx.method_36036();
    }

    @class_6302(method_35936="fabric-gametest-api-v1:empty")
    public void testSortWithStackables(class_4516 ctx) {
        TestUtils.Scenario scenario = TestUtils.setUpScene(ctx, Map.ofEntries(Map.entry(0, new class_1799((class_1935)class_1802.field_17507, 12)), Map.entry(1, new class_1799((class_1935)class_1802.field_23843, 9)), Map.entry(2, new class_1799((class_1935)class_1802.field_17520, 55)), Map.entry(3, new class_1799((class_1935)class_1802.field_8803, 1)), Map.entry(26, new class_1799((class_1935)class_1802.field_8803, 2)), Map.entry(5, new class_1799((class_1935)class_1802.field_8477, 32)), Map.entry(15, new class_1799((class_1935)class_1802.field_8477, 32)), Map.entry(7, new class_1799((class_1935)class_1802.field_8280, 2)), Map.entry(8, new class_1799((class_1935)class_1802.field_8153, 33)), Map.entry(24, new class_1799((class_1935)class_1802.field_28656, 40)), Map.entry(10, new class_1799((class_1935)class_1802.field_8143, 45)), Map.entry(11, new class_1799((class_1935)class_1802.field_28656, 51))));
        InventoryHelper.sortInventory(scenario.player(), false, SortType.NAME);
        TestUtils.assertContents(ctx, scenario, Map.ofEntries(Map.entry(0, new class_1799((class_1935)class_1802.field_17507, 12)), Map.entry(1, new class_1799((class_1935)class_1802.field_23843, 9)), Map.entry(2, new class_1799((class_1935)class_1802.field_17520, 55)), Map.entry(3, new class_1799((class_1935)class_1802.field_8477, 64)), Map.entry(4, new class_1799((class_1935)class_1802.field_8803, 3)), Map.entry(5, new class_1799((class_1935)class_1802.field_8153, 33)), Map.entry(6, new class_1799((class_1935)class_1802.field_8280, 2)), Map.entry(7, new class_1799((class_1935)class_1802.field_28656, 64)), Map.entry(8, new class_1799((class_1935)class_1802.field_28656, 27)), Map.entry(9, new class_1799((class_1935)class_1802.field_8143, 45))));
        ctx.method_36036();
    }

    @class_6302(method_35936="fabric-gametest-api-v1:empty")
    public void testCustomMaxStackSizeSorting(class_4516 ctx) {
        class_9326 changes = class_9326.method_57841().method_57854(class_9334.field_50071, (Object)99).method_57852();
        TestUtils.Scenario scenario = TestUtils.setUpScene(ctx, Map.of(5, new class_1799((class_1935)class_1802.field_8803, 7), 6, new class_1799((class_1935)class_1802.field_8803, 8), 7, new class_1799((class_6880)class_1802.field_8803.method_40131(), 99, changes), 9, new class_1799((class_6880)class_1802.field_8803.method_40131(), 99, changes), 11, new class_1799((class_6880)class_1802.field_8803.method_40131(), 99, changes), 15, new class_1799((class_6880)class_1802.field_8803.method_40131(), 99, changes), 19, new class_1799((class_6880)class_1802.field_8803.method_40131(), 99, changes), 26, new class_1799((class_6880)class_1802.field_8803.method_40131(), 99, changes), 1, new class_1799((class_1935)class_1802.field_8803, 16)));
        InventoryHelper.sortInventory(scenario.player(), false, SortType.NAME);
        TestUtils.assertContents(ctx, scenario, Map.of(0, new class_1799((class_1935)class_1802.field_8803, 99), 1, new class_1799((class_1935)class_1802.field_8803, 99), 2, new class_1799((class_1935)class_1802.field_8803, 99), 3, new class_1799((class_1935)class_1802.field_8803, 99), 4, new class_1799((class_1935)class_1802.field_8803, 99), 5, new class_1799((class_1935)class_1802.field_8803, 99), 6, new class_1799((class_1935)class_1802.field_8803, 16), 7, new class_1799((class_1935)class_1802.field_8803, 15)));
        ctx.method_36036();
    }

    @class_6302(method_35936="fabric-gametest-api-v1:empty")
    public void testSameItemDifferentName(class_4516 ctx) {
        class_9326 changes = class_9326.method_57841().method_57854(class_9334.field_50239, (Object)class_2561.method_30163((String)"omelette")).method_57852();
        class_1799 omelette = new class_1799((class_6880)class_1802.field_8803.method_40131(), 4, changes);
        TestUtils.Scenario scenario = TestUtils.setUpScene(ctx, Map.of(5, new class_1799((class_1935)class_1802.field_8803, 7), 6, new class_1799((class_1935)class_1802.field_8803, 8), 12, new class_1799((class_1935)class_1802.field_8803, 4), 1, omelette));
        InventoryHelper.sortInventory(scenario.player(), false, SortType.NAME);
        TestUtils.assertContents(ctx, scenario, Map.of(0, new class_1799((class_1935)class_1802.field_8803, 16), 1, new class_1799((class_1935)class_1802.field_8803, 3), 2, omelette));
        ctx.method_36036();
    }

    @class_6302(method_35936="fabric-gametest-api-v1:empty")
    public void testSimplePickaxes(class_4516 ctx) {
        TestUtils.Scenario scenario = TestUtils.setUpScene(ctx, Map.of(0, new class_1799((class_1935)class_1802.field_22024, 1), 1, new class_1799((class_1935)class_1802.field_8377, 1), 2, new class_1799((class_1935)class_1802.field_8403, 1), 3, new class_1799((class_1935)class_1802.field_8335, 1), 4, new class_1799((class_1935)class_1802.field_8387, 1), 5, new class_1799((class_1935)class_1802.field_8647, 1)));
        InventoryHelper.sortInventory(scenario.player(), false, SortType.NAME);
        TestUtils.assertContents(ctx, scenario, Map.of(0, new class_1799((class_1935)class_1802.field_8377, 1), 1, new class_1799((class_1935)class_1802.field_8335, 1), 2, new class_1799((class_1935)class_1802.field_8403, 1), 3, new class_1799((class_1935)class_1802.field_22024, 1), 4, new class_1799((class_1935)class_1802.field_8387, 1), 5, new class_1799((class_1935)class_1802.field_8647, 1)));
        ctx.method_36036();
    }

    @class_6302(method_35936="fabric-gametest-api-v1:empty")
    public void testDamagedPickaxes(class_4516 ctx) {
        class_1799 diamondPick80PercentDamaged = new class_1799(class_6880.method_40223((Object)class_1802.field_8377), 1, class_9326.method_57841().method_57854(class_9334.field_49629, (Object)TestUtils.damageForPercent(class_1802.field_8377, 20)).method_57852());
        class_1799 diamondPick25PercentDamaged = new class_1799(class_6880.method_40223((Object)class_1802.field_8377), 1, class_9326.method_57841().method_57854(class_9334.field_49629, (Object)TestUtils.damageForPercent(class_1802.field_8377, 75)).method_57852());
        class_1799 netheritePick75PercentDamaged = new class_1799(class_6880.method_40223((Object)class_1802.field_22024), 1, class_9326.method_57841().method_57854(class_9334.field_49629, (Object)TestUtils.damageForPercent(class_1802.field_22024, 25)).method_57852());
        class_1799 netheritePick50PercentDamaged = new class_1799(class_6880.method_40223((Object)class_1802.field_22024), 1, class_9326.method_57841().method_57854(class_9334.field_49629, (Object)TestUtils.damageForPercent(class_1802.field_22024, 50)).method_57852());
        class_1799 netheritePickNotDamaged = new class_1799((class_1935)class_1802.field_22024, 1);
        class_1799 diamondPickNotDamaged = new class_1799((class_1935)class_1802.field_8377, 1);
        TestUtils.Scenario scenario = TestUtils.setUpScene(ctx, Map.of(0, diamondPick80PercentDamaged, 2, diamondPick25PercentDamaged, 23, netheritePick75PercentDamaged, 12, netheritePick50PercentDamaged, 16, netheritePickNotDamaged, 1, diamondPickNotDamaged));
        InventoryHelper.sortInventory(scenario.player(), false, SortType.NAME);
        TestUtils.assertContents(ctx, scenario, Map.of(0, diamondPickNotDamaged, 1, diamondPick80PercentDamaged, 2, diamondPick25PercentDamaged, 3, netheritePickNotDamaged, 4, netheritePick75PercentDamaged, 5, netheritePick50PercentDamaged));
        ctx.method_36036();
    }

    @class_6302(method_35936="fabric-gametest-api-v1:empty")
    public void testPlayerHeads(class_4516 ctx) {
        class_9296 houseofmeza = new class_9296(new GameProfile(UUID.randomUUID(), "houseofmeza"));
        class_9296 kyrptonaught = new class_9296(new GameProfile(UUID.randomUUID(), "Kyrptonaught"));
        class_9296 morgant1c = new class_9296(new GameProfile(UUID.randomUUID(), "morgant1c"));
        class_9296 zombie_konsti = new class_9296(new GameProfile(UUID.randomUUID(), "Zombie_konsti"));
        class_9326 houseofmezaHead = class_9326.method_57841().method_57854(class_9334.field_49617, (Object)houseofmeza).method_57852();
        class_9326 kyrptonaughtHead = class_9326.method_57841().method_57854(class_9334.field_49617, (Object)kyrptonaught).method_57852();
        class_9326 morgant1cHead = class_9326.method_57841().method_57854(class_9334.field_49617, (Object)morgant1c).method_57852();
        class_9326 zombie_konstiHead = class_9326.method_57841().method_57854(class_9334.field_49617, (Object)zombie_konsti).method_57852();
        TestUtils.Scenario scenario = TestUtils.setUpScene(ctx, Map.of(0, new class_1799(class_6880.method_40223((Object)class_1802.field_8575), 1, zombie_konstiHead), 1, new class_1799(class_6880.method_40223((Object)class_1802.field_8575), 4, morgant1cHead), 2, new class_1799(class_6880.method_40223((Object)class_1802.field_8575), 1, houseofmezaHead), 3, new class_1799(class_6880.method_40223((Object)class_1802.field_8575), 32, kyrptonaughtHead), 4, new class_1799((class_1935)class_1802.field_8575, 16), 5, new class_1799(class_6880.method_40223((Object)class_1802.field_8575), 33, kyrptonaughtHead)));
        InventoryHelper.sortInventory(scenario.player(), false, SortType.NAME);
        TestUtils.assertContents(ctx, scenario, Map.of(0, new class_1799(class_6880.method_40223((Object)class_1802.field_8575), 1, houseofmezaHead), 1, new class_1799(class_6880.method_40223((Object)class_1802.field_8575), 64, kyrptonaughtHead), 2, new class_1799(class_6880.method_40223((Object)class_1802.field_8575), 1, kyrptonaughtHead), 3, new class_1799(class_6880.method_40223((Object)class_1802.field_8575), 4, morgant1cHead), 4, new class_1799((class_1935)class_1802.field_8575, 16), 5, new class_1799(class_6880.method_40223((Object)class_1802.field_8575), 1, zombie_konstiHead)));
        ctx.method_36036();
    }

    @class_6302(method_35936="fabric-gametest-api-v1:empty")
    public void testEnchantedBooks(class_4516 ctx) {
        class_2378 registry = ctx.method_35943().method_30349().method_30530(class_7924.field_41265);
        class_1799 sharpnessBook = new class_1799((class_1935)class_1802.field_8598, 1);
        class_1799 silkTouchBook = new class_1799((class_1935)class_1802.field_8598, 1);
        class_1799 fortune1Book = new class_1799((class_1935)class_1802.field_8598, 1);
        class_1799 fortune3Book = new class_1799((class_1935)class_1802.field_8598, 1);
        class_1799 bulkBook = new class_1799((class_1935)class_1802.field_8598, 1);
        class_1890.method_57531((class_1799)sharpnessBook, builder -> builder.method_57550(registry.method_47983((Object)((class_1887)registry.method_29107(class_1893.field_9118))), 1));
        class_1890.method_57531((class_1799)silkTouchBook, builder -> builder.method_57550(registry.method_47983((Object)((class_1887)registry.method_29107(class_1893.field_9099))), 1));
        class_1890.method_57531((class_1799)fortune1Book, builder -> builder.method_57550(registry.method_47983((Object)((class_1887)registry.method_29107(class_1893.field_9130))), 1));
        class_1890.method_57531((class_1799)fortune3Book, builder -> builder.method_57550(registry.method_47983((Object)((class_1887)registry.method_29107(class_1893.field_9130))), 3));
        class_1890.method_57531((class_1799)bulkBook, builder -> {
            builder.method_57550(registry.method_47983((Object)((class_1887)registry.method_29107(class_1893.field_9099))), 1);
            builder.method_57550(registry.method_47983((Object)((class_1887)registry.method_29107(class_1893.field_9130))), 3);
            builder.method_57550(registry.method_47983((Object)((class_1887)registry.method_29107(class_1893.field_9131))), 5);
            builder.method_57550(registry.method_47983((Object)((class_1887)registry.method_29107(class_1893.field_9119))), 3);
        });
        TestUtils.Scenario scenario = TestUtils.setUpScene(ctx, Map.of(2, fortune3Book, 7, bulkBook, 12, fortune1Book, 16, silkTouchBook, 24, sharpnessBook));
        InventoryHelper.sortInventory(scenario.player(), false, SortType.NAME);
        TestUtils.assertContents(ctx, scenario, Map.of(0, fortune1Book, 1, fortune3Book, 2, sharpnessBook, 3, silkTouchBook, 4, bulkBook));
        ctx.method_36036();
    }

    @class_6302(method_35936="fabric-gametest-api-v1:empty")
    public void testCategorySort(class_4516 ctx) {
        class_1799 coloredBlockStack = new class_1799((class_1935)class_1802.field_19044, 64);
        class_1799 naturalBlockStack = new class_1799((class_1935)class_1802.field_8831, 64);
        class_1799 functionalBlockStack = new class_1799((class_1935)class_1802.field_8465, 64);
        class_1799 redstoneBlockStack = new class_1799((class_1935)class_1802.field_8793, 64);
        class_1799 toolStack = new class_1799((class_1935)class_1802.field_8377, 1);
        class_1799 combatStack = new class_1799((class_1935)class_1802.field_22022, 1);
        class_1799 foodStack = new class_1799((class_1935)class_1802.field_8176, 64);
        class_1799 ingredientStack = new class_1799((class_1935)class_1802.field_8861, 64);
        class_1799 spawnEggStack = new class_1799((class_1935)class_1802.field_8433, 64);
        TestUtils.Scenario scenario = TestUtils.setUpScene(ctx, Map.ofEntries(Map.entry(20, new class_1799((class_1935)class_1802.field_8118, 4)), Map.entry(19, new class_1799((class_1935)class_1802.field_8113, 14)), Map.entry(11, coloredBlockStack), Map.entry(23, naturalBlockStack), Map.entry(13, functionalBlockStack), Map.entry(4, redstoneBlockStack), Map.entry(15, toolStack), Map.entry(6, combatStack), Map.entry(7, foodStack), Map.entry(18, ingredientStack), Map.entry(9, spawnEggStack)));
        InventoryHelper.sortInventory(scenario.player(), false, SortType.CATEGORY);
        TestUtils.assertContents(ctx, scenario, Map.ofEntries(Map.entry(0, new class_1799((class_1935)class_1802.field_8118, 4)), Map.entry(1, new class_1799((class_1935)class_1802.field_8113, 14)), Map.entry(2, redstoneBlockStack), Map.entry(3, coloredBlockStack), Map.entry(4, naturalBlockStack), Map.entry(5, functionalBlockStack), Map.entry(6, toolStack), Map.entry(7, combatStack), Map.entry(8, foodStack), Map.entry(9, ingredientStack), Map.entry(10, spawnEggStack)));
        ctx.method_36036();
    }

    @class_6302(method_35936="fabric-gametest-api-v1:empty")
    public void testOminousPotions(class_4516 ctx) {
        IntFunction<class_9326> potionLevel = level -> class_9326.method_57841().method_57854(class_9334.field_50238, (Object)new class_10129(level - 1)).method_57852();
        TestUtils.Scenario scenario = TestUtils.setUpScene(ctx, Map.of(0, new class_1799(class_6880.method_40223((Object)class_1802.field_50140), 12, potionLevel.apply(1)), 3, new class_1799(class_6880.method_40223((Object)class_1802.field_50140), 42, potionLevel.apply(4)), 6, new class_1799(class_6880.method_40223((Object)class_1802.field_50140), 34, potionLevel.apply(5)), 9, new class_1799(class_6880.method_40223((Object)class_1802.field_50140), 55, potionLevel.apply(1)), 10, new class_1799(class_6880.method_40223((Object)class_1802.field_50140), 3, potionLevel.apply(2)), 12, new class_1799(class_6880.method_40223((Object)class_1802.field_50140), 58, potionLevel.apply(3)), 14, new class_1799(class_6880.method_40223((Object)class_1802.field_50140), 45, potionLevel.apply(4)), 20, new class_1799(class_6880.method_40223((Object)class_1802.field_50140), 5, potionLevel.apply(2)), 25, new class_1799(class_6880.method_40223((Object)class_1802.field_50140), 11, potionLevel.apply(4))));
        InventoryHelper.sortInventory(scenario.player(), false, SortType.NAME);
        TestUtils.assertContents(ctx, scenario, Map.of(0, new class_1799(class_6880.method_40223((Object)class_1802.field_50140), 64, potionLevel.apply(1)), 1, new class_1799(class_6880.method_40223((Object)class_1802.field_50140), 3, potionLevel.apply(1)), 2, new class_1799(class_6880.method_40223((Object)class_1802.field_50140), 8, potionLevel.apply(2)), 3, new class_1799(class_6880.method_40223((Object)class_1802.field_50140), 58, potionLevel.apply(3)), 4, new class_1799(class_6880.method_40223((Object)class_1802.field_50140), 64, potionLevel.apply(4)), 5, new class_1799(class_6880.method_40223((Object)class_1802.field_50140), 34, potionLevel.apply(4)), 6, new class_1799(class_6880.method_40223((Object)class_1802.field_50140), 34, potionLevel.apply(5))));
        ctx.method_36036();
    }

    @class_6302(method_35936="fabric-gametest-api-v1:empty")
    public void testVaults(class_4516 ctx) {
        Boolean2ObjectFunction setOminous = isOminous -> class_9326.method_57841().method_57854(class_9334.field_49623, (Object)new class_9275(Map.of("ominous", String.valueOf(isOminous)))).method_57852();
        TestUtils.Scenario scenario = TestUtils.setUpScene(ctx, Map.of(2, new class_1799(class_6880.method_40223((Object)class_1802.field_48847), 12, (class_9326)setOminous.apply((Object)false)), 12, new class_1799(class_6880.method_40223((Object)class_1802.field_48847), 32, (class_9326)setOminous.apply((Object)true)), 22, new class_1799(class_6880.method_40223((Object)class_1802.field_48847), 10, (class_9326)setOminous.apply((Object)false)), 6, new class_1799(class_6880.method_40223((Object)class_1802.field_48847), 12, (class_9326)setOminous.apply((Object)false)), 3, new class_1799(class_6880.method_40223((Object)class_1802.field_48847), 12, (class_9326)setOminous.apply((Object)true))));
        InventoryHelper.sortInventory(scenario.player(), false, SortType.NAME);
        TestUtils.assertContents(ctx, scenario, Map.of(0, new class_1799(class_6880.method_40223((Object)class_1802.field_48847), 34, (class_9326)setOminous.apply((Object)false)), 1, new class_1799(class_6880.method_40223((Object)class_1802.field_48847), 44, (class_9326)setOminous.apply((Object)true))));
        ctx.method_36036();
    }
}

