/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.inventorysorter.network;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.kyrptonaught.inventorysorter.InventoryHelper;
import net.kyrptonaught.inventorysorter.InventorySorterMod;
import net.kyrptonaught.inventorysorter.SortType;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public record InventorySortPacket(boolean shouldSortPlayerInventory, int sortType) implements class_8710
{
    private static final class_8710.class_9154<InventorySortPacket> ID = new class_8710.class_9154(class_2960.method_60655((String)"inventorysorter", (String)"sort_inv_packet"));
    private static final class_9139<class_9129, InventorySortPacket> CODEC = class_8710.method_56484(InventorySortPacket::write, InventorySortPacket::new);

    public InventorySortPacket(class_2540 buf) {
        this(buf.readBoolean(), buf.readInt());
    }

    public static void registerReceivePacket() {
        PayloadTypeRegistry.playC2S().register(ID, CODEC);
        ServerPlayNetworking.registerGlobalReceiver(ID, (payload, context) -> {
            SortType sortType = SortType.values()[payload.sortType];
            class_3222 player = context.player();
            MinecraftServer server = player.method_5682();
            server.execute(() -> InventoryHelper.sortInventory(player, payload.shouldSortPlayerInventory, sortType));
        });
    }

    @Environment(value=EnvType.CLIENT)
    public static void sendSortPacket(boolean shouldSortPlayerInventory) {
        ClientPlayNetworking.send((class_8710)new InventorySortPacket(shouldSortPlayerInventory, InventorySorterMod.getConfig().sortType.ordinal()));
        if (!shouldSortPlayerInventory && InventorySorterMod.getConfig().sortPlayerInventory) {
            InventorySortPacket.sendSortPacket(true);
        }
    }

    public void write(class_2540 buf) {
        buf.method_52964(this.shouldSortPlayerInventory);
        buf.method_53002(this.sortType);
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return ID;
    }
}

