/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.inventorysorter;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.kyrptonaught.inventorysorter.commands.CommandRegistry;
import net.kyrptonaught.inventorysorter.compat.Compatibility;
import net.kyrptonaught.inventorysorter.compat.sources.CompatibilityLoader;
import net.kyrptonaught.inventorysorter.compat.sources.ConfigLoader;
import net.kyrptonaught.inventorysorter.compat.sources.LocalLoader;
import net.kyrptonaught.inventorysorter.compat.sources.OfficialListLoader;
import net.kyrptonaught.inventorysorter.compat.sources.PredefinedLoader;
import net.kyrptonaught.inventorysorter.compat.sources.RemoteConfigLoader;
import net.kyrptonaught.inventorysorter.config.Config;
import net.kyrptonaught.inventorysorter.config.NewConfigOptions;
import net.kyrptonaught.inventorysorter.network.ClientSync;
import net.kyrptonaught.inventorysorter.network.HideButton;
import net.kyrptonaught.inventorysorter.network.InventorySortPacket;
import net.kyrptonaught.inventorysorter.network.LastSeenVersionPacket;
import net.kyrptonaught.inventorysorter.network.PlayerSortPrevention;
import net.kyrptonaught.inventorysorter.network.ReloadConfigPacket;
import net.kyrptonaught.inventorysorter.network.ServerPresencePacket;
import net.kyrptonaught.inventorysorter.network.SortSettings;
import net.minecraft.class_1761;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_7706;
import net.minecraft.class_8710;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventorySorterMod
implements ModInitializer {
    public static final String MOD_ID = "inventorysorter";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"inventorysorter");
    public static final String VERSION = "2.1.2";
    private static NewConfigOptions CONFIG = Config.load();
    public static final Compatibility compatibility = new Compatibility(new ArrayList<CompatibilityLoader>(List.of(new PredefinedLoader(), new LocalLoader(), new OfficialListLoader(), new ConfigLoader(InventorySorterMod::getConfig), new RemoteConfigLoader(() -> InventorySorterMod.getConfig().customCompatibilityListDownloadUrl))));
    public static final AttachmentType<SortSettings> SORT_SETTINGS = AttachmentRegistry.create((class_2960)class_2960.method_60655((String)"inventorysorter", (String)"sort_settings"), builder -> builder.initializer(() -> SortSettings.DEFAULT).persistent(SortSettings.NBT_CODEC).copyOnDeath());
    public static final AttachmentType<PlayerSortPrevention> PLAYER_SORT_PREVENTION = AttachmentRegistry.create((class_2960)class_2960.method_60655((String)"inventorysorter", (String)"player_sort_prevention"), builder -> builder.initializer(() -> PlayerSortPrevention.DEFAULT).persistent(PlayerSortPrevention.NBT_CODEC).copyOnDeath());
    public static final AttachmentType<ClientSync> CLIENT_SYNC = AttachmentRegistry.create((class_2960)class_2960.method_60655((String)"inventorysorter", (String)"client_sync"), builder -> builder.persistent(ClientSync.NBT_CODEC).copyOnDeath());
    public static final AttachmentType<LastSeenVersionPacket> LAST_SEEN_VERSION = AttachmentRegistry.create((class_2960)class_2960.method_60655((String)"inventorysorter", (String)"last_seen_version"), builder -> builder.persistent(LastSeenVersionPacket.NBT_CODEC));

    public static NewConfigOptions getConfig() {
        return CONFIG;
    }

    public static void reloadConfig() {
        CONFIG = Config.load();
        compatibility.reload();
    }

    public void onInitialize() {
        CommandRegistrationCallback.EVENT.register(CommandRegistry::register);
        PayloadTypeRegistry.playC2S().register(ClientSync.ID, ClientSync.CODEC);
        PayloadTypeRegistry.playS2C().register(LastSeenVersionPacket.ID, LastSeenVersionPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(ServerPresencePacket.ID, ServerPresencePacket.CODEC);
        PayloadTypeRegistry.playS2C().register(HideButton.ID, HideButton.CODEC);
        PayloadTypeRegistry.playS2C().register(ReloadConfigPacket.ID, ReloadConfigPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(PlayerSortPrevention.ID, PlayerSortPrevention.CODEC);
        PayloadTypeRegistry.playS2C().register(PlayerSortPrevention.ID, PlayerSortPrevention.CODEC);
        PayloadTypeRegistry.playC2S().register(SortSettings.ID, SortSettings.CODEC);
        PayloadTypeRegistry.playS2C().register(SortSettings.ID, SortSettings.CODEC);
        InventorySortPacket.registerReceivePacket();
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            class_1761.class_8128 context = new class_1761.class_8128(server.method_27728().method_45560(), false, (class_7225.class_7874)server.method_30611());
            class_7706.method_47341().forEach(group -> {
                if (group.method_45414().isEmpty()) {
                    group.method_47306(context);
                }
            });
        });
        ServerPlayConnectionEvents.JOIN.register((handler, server, client) -> {
            class_3222 player = handler.method_32311();
            ServerPlayNetworking.send((class_3222)player, (class_8710)new ServerPresencePacket());
            if (!player.hasAttached(LAST_SEEN_VERSION)) {
                LastSeenVersionPacket.DEFAULT.send(player);
            } else {
                Objects.requireNonNull((LastSeenVersionPacket)player.getAttached(LAST_SEEN_VERSION)).send(player);
            }
            player.setAttached(LAST_SEEN_VERSION, (Object)new LastSeenVersionPacket(VERSION, player.method_53823().comp_1951().toLowerCase()));
            if (client.method_3816()) {
                if (!player.hasAttached(SORT_SETTINGS)) {
                    player.setAttached(SORT_SETTINGS, (Object)SortSettings.DEFAULT);
                }
                if (!player.hasAttached(PLAYER_SORT_PREVENTION)) {
                    player.setAttached(PLAYER_SORT_PREVENTION, (Object)PlayerSortPrevention.DEFAULT);
                }
                if (!player.hasAttached(CLIENT_SYNC)) {
                    player.setAttached(CLIENT_SYNC, (Object)ClientSync.DEFAULT);
                }
                if (!((ClientSync)player.getAttached(CLIENT_SYNC)).seenClient()) {
                    SortSettings sortSettings;
                    PlayerSortPrevention sortPrevention = (PlayerSortPrevention)player.getAttached(PLAYER_SORT_PREVENTION);
                    if (sortPrevention != PlayerSortPrevention.DEFAULT) {
                        sortPrevention.sync(player);
                    }
                    if ((sortSettings = (SortSettings)player.getAttached(SORT_SETTINGS)) != SortSettings.DEFAULT) {
                        sortSettings.sync(player);
                    }
                }
                HideButton.fromConfig(InventorySorterMod.getConfig()).sync(player);
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(SortSettings.ID, (payload, context) -> context.player().setAttached(SORT_SETTINGS, (Object)payload));
        ServerPlayNetworking.registerGlobalReceiver(PlayerSortPrevention.ID, (payload, context) -> context.player().setAttached(PLAYER_SORT_PREVENTION, (Object)payload));
        ServerPlayNetworking.registerGlobalReceiver(ClientSync.ID, (payload, context) -> context.player().setAttached(CLIENT_SYNC, (Object)new ClientSync(true)));
    }
}

