/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.inventorysorter;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import net.kyrptonaught.inventorysorter.SortType;
import net.minecraft.class_10129;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_6880;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_9275;
import net.minecraft.class_9296;
import net.minecraft.class_9304;
import net.minecraft.class_9323;
import net.minecraft.class_9334;

public class SortCases {
    static Comparator<class_1799> getComparator(SortType sortType, String language) {
        Collator collator = Collator.getInstance(SortCases.fromMinecraftLocale(language));
        Comparator<class_1799> defaultComparator = Comparator.comparing(SortCases::getSortableName, collator).thenComparing(SortCases::isOminous).thenComparing(SortCases::getOminousAmplifier).thenComparing(class_1799::method_7919).thenComparing(class_1799::method_7947, Comparator.reverseOrder());
        switch (sortType) {
            case CATEGORY: {
                return Comparator.comparing(SortCases::getGroupIdentifier).thenComparing(defaultComparator);
            }
            case MOD: {
                return Comparator.comparing(stack -> class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12836()).thenComparing(defaultComparator);
            }
            case NAME: {
                return defaultComparator;
            }
            case ID: {
                return Comparator.comparing(stack -> class_7923.field_41178.method_10221((Object)stack.method_7909()).toString()).thenComparing(defaultComparator);
            }
        }
        return defaultComparator;
    }

    private static int getGroupIdentifier(class_1799 stack) {
        List groups = class_7706.method_47341();
        for (int i = 0; i < groups.size(); ++i) {
            class_1761 group = (class_1761)groups.get(i);
            List stacks = group.method_45414().stream().toList();
            OptionalInt index = IntStream.range(0, stacks.size()).filter(j -> class_1799.method_31577((class_1799)((class_1799)stacks.get(j)), (class_1799)stack)).findFirst();
            if (!index.isPresent()) continue;
            return i * 1000 + index.getAsInt();
        }
        return 99999;
    }

    private static int getOminousAmplifier(class_1799 stack) {
        class_9323 components = stack.method_57353();
        if (components.method_57832(class_9334.field_50238)) {
            int i = ((class_10129)components.method_58694(class_9334.field_50238)).comp_3090() + 1;
            return i;
        }
        return 0;
    }

    private static boolean isOminous(class_1799 stack) {
        class_9323 components = stack.method_57353();
        if (!components.method_57832(class_9334.field_49623)) {
            return false;
        }
        String result = ((class_9275)components.method_58694(class_9334.field_49623)).comp_2381().getOrDefault("ominous", "false");
        return Boolean.parseBoolean(result);
    }

    private static String getSortableName(class_1799 stack) {
        class_9323 components = stack.method_57353();
        if (components.method_57832(class_9334.field_49617)) {
            return SortCases.playerHeadName(stack).toLowerCase();
        }
        if (stack.method_31574(class_1802.field_8598)) {
            return SortCases.enchantedBookNameCase(stack).toLowerCase();
        }
        return SortCases.stackName(stack).toLowerCase();
    }

    private static String playerHeadName(class_1799 stack) {
        class_9296 profileComponent = (class_9296)stack.method_57353().method_58694(class_9334.field_49617);
        Optional componentName = profileComponent.method_73317();
        return componentName.orElseGet(() -> SortCases.stackName(stack));
    }

    private static String stackName(class_1799 stack) {
        return stack.method_7964().getString();
    }

    private static String enchantedBookNameCase(class_1799 stack) {
        class_9304 enchantmentsComponent = (class_9304)stack.method_57353().method_58694(class_9334.field_49643);
        ArrayList<String> names = new ArrayList<String>();
        StringBuilder enchantNames = new StringBuilder();
        for (Object2IntMap.Entry entry : enchantmentsComponent.method_57539()) {
            names.add(class_1887.method_8179((class_6880)((class_6880)entry.getKey()), (int)entry.getIntValue()).getString());
        }
        Collections.sort(names);
        for (String string : names) {
            enchantNames.append(string).append(" ");
        }
        return stack.method_7964().getString() + " " + enchantmentsComponent.method_57541() + " " + String.valueOf(enchantNames);
    }

    private static Locale fromMinecraftLocale(String mcLocale) {
        String[] parts = mcLocale.toLowerCase().split("_");
        if (parts.length == 2) {
            return Locale.of(parts[0], parts[1].toUpperCase());
        }
        return Locale.getDefault();
    }
}

