/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.inventorysorter.client;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.kyrptonaught.inventorysorter.InventorySorterMod;
import net.kyrptonaught.inventorysorter.client.ConfigScreen;
import net.kyrptonaught.inventorysorter.client.SortButtonWidget;
import net.kyrptonaught.inventorysorter.client.SortableContainerScreen;
import net.kyrptonaught.inventorysorter.client.TranslationReminder;
import net.kyrptonaught.inventorysorter.compat.config.CompatConfig;
import net.kyrptonaught.inventorysorter.compat.sources.ConfigLoader;
import net.kyrptonaught.inventorysorter.config.NewConfigOptions;
import net.kyrptonaught.inventorysorter.network.ClientSync;
import net.kyrptonaught.inventorysorter.network.HideButton;
import net.kyrptonaught.inventorysorter.network.LastSeenVersionPacket;
import net.kyrptonaught.inventorysorter.network.PlayerSortPrevention;
import net.kyrptonaught.inventorysorter.network.ReloadConfigPacket;
import net.kyrptonaught.inventorysorter.network.ServerPresencePacket;
import net.kyrptonaught.inventorysorter.network.SortSettings;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_8710;

public class InventorySorterModClient
implements ClientModInitializer {
    private CompatConfig serverConfig = new CompatConfig();
    private volatile boolean serverIsPresent = false;
    private ScheduledExecutorService scheduler;
    public static class_2960 PLAYER_INVENTORY = class_2960.method_60654((String)"player_inventory");
    private static final class_304.class_11900 category = class_304.class_11900.method_74698((class_2960)class_2960.method_60655((String)"inventorysorter", (String)"main"));
    public static final class_304 configButton = new class_304("inventorysorter.key.config", 80, category);
    public static final class_304 sortButton = new class_304("inventorysorter.key.sort", 80, category);
    public static final class_3675.class_306 modifierButton = class_3675.class_307.field_1668.method_1447(341);

    public void onInitializeClient() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdownScheduler));
        KeyBindingHelper.registerKeyBinding((class_304)configButton);
        KeyBindingHelper.registerKeyBinding((class_304)sortButton);
        InventorySorterMod.compatibility.addLoader(new ConfigLoader(() -> this.serverConfig));
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            this.serverIsPresent = false;
            this.scheduler = Executors.newSingleThreadScheduledExecutor();
            ClientPlayNetworking.send((class_8710)new ClientSync(true));
            InventorySorterModClient.syncConfig();
            this.scheduler.schedule(() -> {
                if (!this.serverIsPresent) {
                    this.scheduler.schedule(() -> {
                        if (!this.serverIsPresent && client.field_1724 != null) {
                            client.execute(() -> client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"[Inventory Sorter] ").method_27694(style -> style.method_10982(Boolean.valueOf(true)).method_10977(class_124.field_1075)).method_10852((class_2561)class_2561.method_43471((String)"inventorysorter.warning.missing-server").method_27694(style -> style.method_10982(Boolean.valueOf(false)).method_10977(class_124.field_1054))), false));
                        }
                    }, 20L, TimeUnit.SECONDS);
                }
            }, 5L, TimeUnit.SECONDS);
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            this.serverConfig = new CompatConfig();
            InventorySorterMod.compatibility.reload();
            this.serverIsPresent = false;
            this.shutdownScheduler();
        });
        ScreenEvents.BEFORE_INIT.register((client, screen, scaledWidth, scaledHeight) -> ScreenMouseEvents.afterMouseScroll((class_437)screen).register((scr, x, y, horizontalAmount, verticalAmount, consumed) -> {
            SortButtonWidget playerButton;
            if (!(scr instanceof SortableContainerScreen)) {
                return false;
            }
            SortableContainerScreen innerScreen = (SortableContainerScreen)scr;
            SortButtonWidget inventoryButton = innerScreen.inventorySorter$getSortButton();
            if (inventoryButton != null && inventoryButton.field_22764 && inventoryButton.method_49606()) {
                inventoryButton.method_25401(x, y, verticalAmount, horizontalAmount);
            }
            if ((playerButton = innerScreen.inventorySorter$getPlayerSortButton()) != null && playerButton.field_22764 && playerButton.method_49606()) {
                playerButton.method_25401(x, y, verticalAmount, horizontalAmount);
            }
            return true;
        }));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            class_3675.class_306 config = KeyBindingHelper.getBoundKeyOf((class_304)configButton);
            class_3675.class_306 sort = KeyBindingHelper.getBoundKeyOf((class_304)sortButton);
            Supplier<Boolean> keyToCheck = () -> ((class_304)configButton).method_1436();
            if (config.method_1444() == sort.method_1444()) {
                keyToCheck = () -> sortButton.method_1436() || configButton.method_1436();
            }
            if (keyToCheck.get().booleanValue()) {
                client.method_1507(ConfigScreen.getConfigScreen(client.field_1755));
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(SortSettings.ID, (payload, context) -> {
            NewConfigOptions currentConfig = InventorySorterMod.getConfig();
            currentConfig.enableDoubleClickSort = payload.enableDoubleClick();
            currentConfig.sortType = payload.sortType();
            currentConfig.save();
        });
        ClientPlayNetworking.registerGlobalReceiver(PlayerSortPrevention.ID, (payload, context) -> {
            NewConfigOptions currentConfig = InventorySorterMod.getConfig();
            currentConfig.preventSortForScreens.retainAll(payload.preventSortForScreens());
            payload.preventSortForScreens().forEach(currentConfig::disableSortForScreen);
            currentConfig.save();
            InventorySorterMod.compatibility.reload();
        });
        ClientPlayNetworking.registerGlobalReceiver(HideButton.ID, (payload, context) -> {
            this.serverConfig.hideButtonsForScreens = payload.hideButtonForScreens().stream().toList();
            InventorySorterMod.compatibility.reload();
        });
        ClientPlayNetworking.registerGlobalReceiver(ReloadConfigPacket.ID, (payload, context) -> InventorySorterMod.reloadConfig());
        ClientPlayNetworking.registerGlobalReceiver(LastSeenVersionPacket.ID, (payload, context) -> {
            class_310 client = context.client();
            if (payload.lastSeenVersion().equals("2.1.2") && payload.lastSeenLanguage().equals(client.method_1526().method_4669().toLowerCase())) {
                return;
            }
            TranslationReminder.notify(client);
        });
        ClientPlayNetworking.registerGlobalReceiver(ServerPresencePacket.ID, (payload, context) -> {
            this.serverIsPresent = true;
        });
    }

    public static void syncConfig() {
        NewConfigOptions config = InventorySorterMod.getConfig();
        ClientPlayNetworking.send((class_8710)SortSettings.fromConfig(config));
        ClientPlayNetworking.send((class_8710)PlayerSortPrevention.fromConfig(config));
    }

    private void shutdownScheduler() {
        if (this.scheduler == null || this.scheduler.isShutdown()) {
            return;
        }
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.scheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

