/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.inventorysorter.client;

import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.kyrptonaught.inventorysorter.ButtonType;
import net.kyrptonaught.inventorysorter.InventoryHelper;
import net.kyrptonaught.inventorysorter.InventorySorterMod;
import net.kyrptonaught.inventorysorter.SortType;
import net.kyrptonaught.inventorysorter.client.InventorySorterModClient;
import net.kyrptonaught.inventorysorter.config.NewConfigOptions;
import net.kyrptonaught.inventorysorter.config.ScrollBehaviour;
import net.kyrptonaught.inventorysorter.mixin.RecipeBookScreenAccessor;
import net.kyrptonaught.inventorysorter.network.InventorySortPacket;
import net.minecraft.class_10260;
import net.minecraft.class_1041;
import net.minecraft.class_10799;
import net.minecraft.class_11907;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1723;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_3675;
import net.minecraft.class_370;
import net.minecraft.class_374;
import net.minecraft.class_437;
import net.minecraft.class_507;
import net.minecraft.class_5481;
import net.minecraft.class_7923;
import net.minecraft.class_8000;
import net.minecraft.class_8001;
import net.minecraft.class_8666;

@Environment(value=EnvType.CLIENT)
public class SortButtonWidget
extends class_344 {
    private static final class_8666 TEXTURES = new class_8666(class_2960.method_60655((String)"inventorysorter", (String)"textures/gui/button_unfocused.png"), class_2960.method_60655((String)"inventorysorter", (String)"textures/gui/button_focused.png"));
    private final ButtonType buttonType;
    private final boolean playerInv;
    private final class_8000 widgetTooltipPositioner = class_8001.field_41687;
    private final class_3675.class_306 modifierKey;
    private class_437 parentScreen;
    private static final int RECIPE_BOOK_OFFSET = 77;
    private int initialX;
    private static final ScheduledExecutorService debounceExecutor = Executors.newSingleThreadScheduledExecutor();
    private static ScheduledFuture<?> debounceTask;

    public SortButtonWidget(ButtonType buttonType, int x, int y, boolean playerInv, class_437 parent) {
        super(x, y, 10, 9, TEXTURES, null, (class_2561)class_2561.method_43470((String)""));
        this.buttonType = buttonType;
        this.playerInv = playerInv;
        this.modifierKey = InventorySorterModClient.modifierButton;
        this.parentScreen = parent;
        this.initialX = x;
    }

    public void method_25306(class_11907 input) {
        class_310 instance = class_310.method_1551();
        String screenID = null;
        if (InventoryHelper.canSortInventory((class_1657)instance.field_1724)) {
            screenID = class_7923.field_41187.method_10221((Object)instance.field_1724.field_7512.method_17358()).toString();
        }
        if (instance.field_1724.field_7512 instanceof class_1723) {
            screenID = InventorySorterModClient.PLAYER_INVENTORY.toString();
        }
        if (screenID == null) {
            InventorySortPacket.sendSortPacket(this.playerInv);
            return;
        }
        if (this.isModifierPressed()) {
            InventorySorterMod.getConfig().disableButtonForScreen(screenID);
            InventorySorterMod.compatibility.addShouldHideSortButton(screenID);
            InventorySorterMod.getConfig().save();
            InventorySorterMod.compatibility.reload();
            InventorySorterModClient.syncConfig();
            class_370.method_27024((class_374)instance.method_1566(), (class_370.class_9037)class_370.class_9037.field_47588, (class_2561)class_2561.method_43471((String)"inventorysorter.sortButton.toast.hide.success.title"), (class_2561)class_2561.method_43469((String)"inventorysorter.sortButton.toast.hide.success.description", (Object[])new Object[]{screenID}));
            this.field_22764 = false;
        } else {
            InventorySortPacket.sendSortPacket(this.playerInv);
        }
    }

    public void method_75752(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        int offset = 0;
        if (!this.field_22764) {
            return;
        }
        if (this.parentScreen != null && this.parentScreen instanceof class_10260) {
            class_10260 s = (class_10260)this.parentScreen;
            class_507<?> widget = ((RecipeBookScreenAccessor)s).getRecipeBook();
            offset = widget.method_2605() ? 77 : 0;
        }
        this.method_46421(this.initialX + offset);
        context.method_51448().pushMatrix();
        context.method_51448().scale(0.5f, 0.5f);
        context.method_51448().translate((float)this.method_46426(), (float)this.method_46427());
        class_2960 identifier = TEXTURES.method_52729(true, this.method_49606());
        context.method_25290(class_10799.field_56883, identifier, this.method_46426(), this.method_46427(), 0.0f, 0.0f, 20, 18, 20, 18);
        context.method_51448().popMatrix();
        this.renderTooltip(context, mouseX, mouseY);
    }

    public boolean method_25401(double mouseX, double mouseY, double verticalAmount, double horizontalAmount) {
        NewConfigOptions config = InventorySorterMod.getConfig();
        if (config.scrollBehaviour == ScrollBehaviour.DISABLED) {
            return false;
        }
        if (config.scrollBehaviour == ScrollBehaviour.MODIFIER && !this.isModifierPressed()) {
            return false;
        }
        if (config.scrollBehaviour == ScrollBehaviour.FREE && this.isModifierPressed()) {
            return false;
        }
        int current = config.sortType.ordinal();
        if (verticalAmount > 0.0) {
            if (++current >= SortType.values().length) {
                current = 0;
            }
        } else if (--current < 0) {
            current = SortType.values().length - 1;
        }
        config.sortType = SortType.values()[current];
        if (debounceTask != null) {
            debounceTask.cancel(false);
        }
        debounceTask = debounceExecutor.schedule(() -> {
            config.save();
            InventorySorterModClient.syncConfig();
        }, 300L, TimeUnit.MILLISECONDS);
        return true;
    }

    private boolean isModifierPressed() {
        return class_3675.method_15987((class_1041)class_310.method_1551().method_22683(), (int)this.modifierKey.method_1444());
    }

    public void renderTooltip(class_332 context, int mouseX, int mouseY) {
        NewConfigOptions config = InventorySorterMod.getConfig();
        if (config.showTooltips && this.method_49606()) {
            class_310 instance = class_310.method_1551();
            class_327 textRenderer = instance.field_1772;
            ArrayList<class_5481> lines = new ArrayList<class_5481>();
            if ((config.scrollBehaviour == ScrollBehaviour.FREE || config.scrollBehaviour == ScrollBehaviour.DISABLED) && this.isModifierPressed()) {
                lines.add(class_2561.method_43471((String)"inventorysorter.sortButton.tooltip.hide").method_30937());
            }
            if (config.scrollBehaviour == ScrollBehaviour.MODIFIER && this.isModifierPressed()) {
                lines.add(class_2561.method_43469((String)"inventorysorter.sortButton.tooltip.sortType", (Object[])new Object[]{class_2561.method_43471((String)InventorySorterMod.getConfig().sortType.getTranslationKey()).method_27692(class_124.field_1067)}).method_30937());
                lines.add(class_2561.method_43471((String)"inventorysorter.sortButton.tooltip.help.sortType").method_27692(class_124.field_1080).method_30937());
                lines.add(class_2561.method_43471((String)"inventorysorter.sortButton.tooltip.hide").method_27692(class_124.field_1080).method_30937());
            }
            if (!this.isModifierPressed()) {
                lines.add(class_2561.method_43469((String)"inventorysorter.sortButton.tooltip.sortType", (Object[])new Object[]{class_2561.method_43471((String)InventorySorterMod.getConfig().sortType.getTranslationKey()).method_27692(class_124.field_1067)}).method_30937());
                if (config.scrollBehaviour == ScrollBehaviour.MODIFIER) {
                    lines.add(class_2561.method_43469((String)"inventorysorter.sortButton.tooltip.help.sortType.modifier", (Object[])new Object[]{this.modifierKey.method_27445()}).method_27692(class_124.field_1063).method_30937());
                } else if (config.scrollBehaviour != ScrollBehaviour.DISABLED) {
                    lines.add(class_2561.method_43471((String)"inventorysorter.sortButton.tooltip.help.sortType").method_27692(class_124.field_1063).method_30937());
                }
                lines.add(class_2561.method_43469((String)"inventorysorter.sortButton.tooltip.help.hide", (Object[])new Object[]{this.modifierKey.method_27445()}).method_27692(class_124.field_1063).method_30937());
            }
            context.method_51436(textRenderer, lines, this.widgetTooltipPositioner, mouseX, mouseY, true);
        }
    }
}

